/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pointinfo;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.pointinfo.AbstractPointInfoModule;
import org.openstreetmap.josm.plugins.pointinfo.PointInfoPlugin;
import org.openstreetmap.josm.plugins.pointinfo.PointInfoUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

class PointInfoAction
extends MapMode
implements MouseListener {
    private static final long serialVersionUID = 1L;
    protected boolean cancel;
    protected AbstractPointInfoModule module;
    private String htmlText = "";
    private String coordinatesText = "";

    PointInfoAction() {
        super(I18n.tr((String)"Point info", (Object[])new Object[0]), "pointinfo", I18n.tr((String)"Point info.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:pointInfo", (String)I18n.tr((String)"More tools: {0}", (Object[])new Object[]{I18n.tr((String)"Point info", (Object[])new Object[0])}), (int)88, (int)5009), PointInfoAction.getCursor());
    }

    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        MainApplication.getMap().mapView.setCursor(PointInfoAction.getCursor());
        MainApplication.getMap().mapView.addMouseListener((MouseListener)this);
    }

    public void exitMode() {
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)this);
    }

    private static Cursor getCursor() {
        return ImageProvider.getCursor((String)"crosshair", (String)"pointinfo");
    }

    protected void infoAsync(Point clickPoint) {
        this.cancel = false;
        final LatLon pos = MainApplication.getMap().mapView.getLatLon(clickPoint.x, clickPoint.y);
        try {
            this.module = PointInfoPlugin.getModule(pos);
            PleaseWaitRunnable infoTask = new PleaseWaitRunnable(I18n.tr((String)"Connecting server", (Object[])new Object[0])){

                protected void realRun() throws SAXException {
                    PointInfoAction.this.infoSync(pos, this.progressMonitor.createSubTaskMonitor(-1, true));
                }

                protected void finish() {
                }

                protected void afterFinish() {
                    if (PointInfoAction.this.htmlText.length() > 0) {
                        JEditorPane msgLabel = new JEditorPane("text/html", PointInfoAction.this.htmlText);
                        msgLabel.setEditable(false);
                        msgLabel.setOpaque(false);
                        msgLabel.addHyperlinkListener(hle -> {
                            if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                                Logging.info((String)hle.getURL().toString());
                                if (hle.getURL() == null || hle.getURL().toString().isEmpty()) {
                                    return;
                                }
                                if (!hle.getURL().toString().startsWith("http")) {
                                    PointInfoAction.this.module.performAction(hle.getURL().toString());
                                } else {
                                    String ret = OpenBrowser.displayUrl((String)hle.getURL().toString());
                                    if (ret != null) {
                                        PointInfoUtils.showNotification(ret, "error");
                                    }
                                }
                            }
                        });
                        JScrollPane scrollPane = new JScrollPane(msgLabel);
                        Object[] objects = new Object[]{scrollPane};
                        ImageIcon icon = ImageProvider.get((String)"dialogs/pointinfo", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.SETTINGS_TAB);
                        JOptionPane.showMessageDialog(null, objects, I18n.tr((String)"PointInfo", (Object[])new Object[0]) + " " + PointInfoAction.this.coordinatesText, -1, icon);
                    }
                }

                protected void cancel() {
                    PointInfoAction.this.cancel();
                }
            };
            new Thread((Runnable)infoTask).start();
        }
        catch (Exception e) {
            Logging.error((Throwable)e);
        }
    }

    private void infoSync(LatLon pos, ProgressMonitor progressMonitor) {
        progressMonitor.beginTask(null, 3);
        try {
            this.module.prepareData(pos);
            this.htmlText = this.module.getHtml();
            this.coordinatesText = PointInfoUtils.formatCoordinates(pos.lat(), pos.lon());
        }
        finally {
            progressMonitor.finishTask();
        }
        progressMonitor.invalidate();
        if (this.htmlText.length() == 0) {
            GuiHelper.runInEDTAndWait(() -> PointInfoUtils.showNotification(I18n.tr((String)"Data not available.", (Object[])new Object[0]) + "\n(" + pos.toDisplayString() + ")", "warning"));
            return;
        }
    }

    public void cancel() {
        this.cancel = true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.requestFocusInMapView();
        this.updateKeyModifiers(e);
        if (e.getButton() == 1) {
            this.infoAsync(e.getPoint());
        }
    }

    protected void updateKeyModifiers(MouseEvent e) {
        this.ctrl = (e.getModifiers() & 2) != 0;
        this.alt = (e.getModifiers() & 0x28) != 0;
        this.shift = (e.getModifiers() & 1) != 0;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

