/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.lib.internal;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.plugins.pmtiles.lib.Directory;
import org.openstreetmap.josm.plugins.pmtiles.lib.DirectoryEntry;

public final class DirectoryParser {
    private DirectoryParser() {
    }

    public static Directory parse(InputStream inputStream) throws IOException {
        int lastByte = inputStream.read();
        int currentInt = lastByte & 0x7F;
        int shift = 7;
        while ((lastByte & 0x80) != 0) {
            lastByte = inputStream.read();
            currentInt |= (lastByte & 0x7F) << shift;
            shift += 7;
        }
        int entrySize = currentInt;
        long[] tileIds = new long[entrySize];
        long[] runLengths = new long[entrySize];
        long[] lengths = new long[entrySize];
        long[] offsets = new long[entrySize];
        for (int index = 0; lastByte != -1 && index < entrySize * 4; ++index) {
            lastByte = inputStream.read();
            long currentLong = lastByte & 0x7F;
            shift = 7;
            while ((lastByte & 0x80) != 0 && lastByte != -1) {
                lastByte = inputStream.read();
                currentLong |= (long)(lastByte & 0x7F) << shift;
                shift += 7;
            }
            if (index < tileIds.length) {
                tileIds[index] = currentLong;
                continue;
            }
            if (index < entrySize * 2) {
                runLengths[index - entrySize] = currentLong;
                continue;
            }
            if (index < entrySize * 3) {
                lengths[index - 2 * entrySize] = currentLong;
                continue;
            }
            offsets[index - 3 * entrySize] = currentLong;
        }
        DirectoryEntry[] entries = new DirectoryEntry[entrySize];
        for (int i = 0; i < entries.length; ++i) {
            if (i == 0) {
                entries[i] = new DirectoryEntry(tileIds[i], offsets[i] - 1L, lengths[i], runLengths[i]);
                continue;
            }
            DirectoryEntry lastEntry = entries[i - 1];
            long offset = offsets[i] == 0L ? lastEntry.offset() + lastEntry.length() : offsets[i] - 1L;
            entries[i] = new DirectoryEntry(tileIds[i] + lastEntry.tileId(), offset, lengths[i], runLengths[i]);
        }
        return new Directory(entries);
    }
}

