/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fit.lib.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.openstreetmap.josm.plugins.fit.lib.FitBaseType;
import org.openstreetmap.josm.plugins.fit.lib.global.FitDevDataRecord;
import org.openstreetmap.josm.plugins.fit.lib.records.FitDevDoubleData;
import org.openstreetmap.josm.plugins.fit.lib.records.FitDevFloatData;
import org.openstreetmap.josm.plugins.fit.lib.records.FitDevIntData;
import org.openstreetmap.josm.plugins.fit.lib.records.FitDevLongData;
import org.openstreetmap.josm.plugins.fit.lib.records.FitDevStringData;
import org.openstreetmap.josm.plugins.fit.lib.records.FitDevUnknown;
import org.openstreetmap.josm.plugins.fit.lib.records.IFitDevData;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperField;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperFieldDescriptionMessage;
import org.openstreetmap.josm.plugins.fit.lib.utils.NumberUtils;
import org.openstreetmap.josm.plugins.fit.lib.utils.StringUtils;

public final class DevDataUtils {
    private static final FitDevDataRecord EMPTY_IFITDEVDATA = new FitDevDataRecord(new IFitDevData[0]);

    private DevDataUtils() {
    }

    public static FitDevDataRecord parseDevFields(boolean littleEndian, Collection<FitDeveloperField> developerFieldList, FitDeveloperFieldDescriptionMessage[] devFields, InputStream inputStream) throws IOException {
        if (developerFieldList.isEmpty()) {
            return EMPTY_IFITDEVDATA;
        }
        IFitDevData[] arrayData = new IFitDevData[developerFieldList.size()];
        int index = 0;
        for (FitDeveloperField fitField : developerFieldList) {
            FitDeveloperFieldDescriptionMessage devField = devFields[fitField.developerDataIndex()];
            String fieldName = devField.fieldName();
            String units = devField.units();
            short fieldSize = fitField.size();
            int n = index++;
            arrayData[n] = switch (FitBaseType.fromBaseTypeField(devField.fitBaseTypeId())) {
                default -> throw new MatchException(null, null);
                case FitBaseType.float64 -> new FitDevDoubleData(fieldName, units, NumberUtils.decodeDouble(fieldSize, littleEndian, inputStream));
                case FitBaseType.float32 -> new FitDevFloatData(fieldName, units, Float.valueOf(NumberUtils.decodeFloat(fieldSize, littleEndian, inputStream)));
                case FitBaseType.enum_, FitBaseType.sint8, FitBaseType.uint8, FitBaseType.uint8z, FitBaseType.sint16, FitBaseType.uint16, FitBaseType.uint16z, FitBaseType.sint32 -> new FitDevIntData(fieldName, units, NumberUtils.decodeInt(fieldSize, littleEndian, inputStream));
                case FitBaseType.uint32, FitBaseType.uint32z, FitBaseType.sint64, FitBaseType.uint64, FitBaseType.uint64z -> new FitDevLongData(fieldName, units, NumberUtils.decodeLong(fieldSize, littleEndian, inputStream));
                case FitBaseType.string -> new FitDevStringData(fieldName, units, StringUtils.decodeString(inputStream));
                case FitBaseType.byte_, FitBaseType.UNKNOWN -> new FitDevUnknown(fieldName, units, inputStream.readNBytes(fieldSize));
            };
        }
        return new FitDevDataRecord(arrayData);
    }
}

