/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fit.lib.global;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.openstreetmap.josm.plugins.fit.lib.global.FitDeveloperDataIdMessage;
import org.openstreetmap.josm.plugins.fit.lib.global.FitDevice;
import org.openstreetmap.josm.plugins.fit.lib.global.FitUnknownRecord;
import org.openstreetmap.josm.plugins.fit.lib.global.HeartRateCadenceDistanceSpeed;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDefinitionMessage;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperField;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperFieldDescriptionMessage;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitField;
import org.openstreetmap.josm.plugins.fit.lib.utils.DevDataUtils;

public interface Global {
    public static final byte MESSAGE_NUMBER_FILE_ID = 0;
    public static final short MESSAGE_NUMBER_APP_ID = 207;
    public static final short MESSAGE_NUMBER_DEV_FIELD_DESCRIPTION = 206;

    public static Object parseData(int globalMessageNumber, boolean littleEndian, List<FitField> fieldList, List<FitDeveloperField> developerFieldList, FitDeveloperFieldDescriptionMessage[] developerFields, InputStream inputStream) throws IOException {
        return switch (globalMessageNumber) {
            case 0 -> FitDevice.parse(littleEndian, fieldList, developerFieldList, developerFields, inputStream);
            case 20 -> HeartRateCadenceDistanceSpeed.parse(littleEndian, fieldList, developerFieldList, developerFields, inputStream);
            case 206 -> FitDeveloperFieldDescriptionMessage.parse(littleEndian, fieldList, developerFieldList, developerFields, inputStream);
            case 207 -> FitDeveloperDataIdMessage.parse(littleEndian, fieldList, developerFieldList, developerFields, inputStream);
            default -> {
                FitUnknownRecord.FieldData[] fieldData = new FitUnknownRecord.FieldData[fieldList.size()];
                int index = 0;
                for (FitField field : fieldList) {
                    fieldData[index++] = new FitUnknownRecord.FieldData(field, inputStream.readNBytes(field.size()));
                }
                yield new FitUnknownRecord(fieldData, DevDataUtils.parseDevFields(littleEndian, developerFieldList, developerFields, inputStream));
            }
        };
    }

    public static Object parseData(FitDefinitionMessage definitionMessage, FitDeveloperFieldDescriptionMessage[] developerFields, InputStream inputStream) throws IOException {
        return Global.parseData(definitionMessage.globalMessageNumber(), definitionMessage.littleEndian(), definitionMessage.fitFields(), definitionMessage.fitDeveloperFields(), developerFields, inputStream);
    }
}

