/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fit.lib.global;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.openstreetmap.josm.plugins.fit.lib.global.FitData;
import org.openstreetmap.josm.plugins.fit.lib.global.FitDevDataRecord;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperField;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperFieldDescriptionMessage;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitField;
import org.openstreetmap.josm.plugins.fit.lib.utils.DevDataUtils;
import org.openstreetmap.josm.plugins.fit.lib.utils.NumberUtils;

public record FitDevice(short type, int manufacturer, int product, long serialNumber, long timeCreated, FitDevDataRecord devData) implements FitData
{
    public static FitDevice parse(boolean littleEndian, List<FitField> fieldList, List<FitDeveloperField> developerFieldList, FitDeveloperFieldDescriptionMessage[] developerFields, InputStream inputStream) throws IOException {
        short type = 255;
        int manufacturer = 65535;
        int product = 65535;
        long serialNumber = 0L;
        long timeCreated = 0xFFFFFFFFL;
        block7: for (FitField fitField : fieldList) {
            short size = fitField.size();
            switch (fitField.fieldDefinitionNumber()) {
                case 0: {
                    type = NumberUtils.decodeByte(size, littleEndian, inputStream);
                    continue block7;
                }
                case 1: {
                    manufacturer = NumberUtils.decodeInt(size, littleEndian, inputStream);
                    continue block7;
                }
                case 2: {
                    product = NumberUtils.decodeInt(size, littleEndian, inputStream);
                    continue block7;
                }
                case 3: {
                    serialNumber = NumberUtils.decodeLong(size, littleEndian, inputStream);
                    continue block7;
                }
                case 4: {
                    timeCreated = NumberUtils.decodeLong(size, littleEndian, inputStream);
                    continue block7;
                }
            }
            inputStream.readNBytes(size);
        }
        return new FitDevice(type, manufacturer, product, serialNumber, timeCreated, DevDataUtils.parseDevFields(littleEndian, developerFieldList, developerFields, inputStream));
    }
}

