/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fit.lib;

public enum FitBaseType {
    enum_(false, 0, 1, 255L),
    sint8(false, 1, 1, 127L),
    uint8(false, 2, 1, 255L),
    sint16(true, 131, 2, 32767L),
    uint16(true, 132, 2, 65535L),
    sint32(true, 133, 4, Integer.MAX_VALUE),
    uint32(true, 134, 4, 0xFFFFFFFFL),
    string(false, 7, 1, 0L),
    float32(true, 136, 4, 0xFFFFFFFFL),
    float64(true, 137, 8, -1L),
    uint8z(false, 10, 1, 0L),
    uint16z(true, 139, 2, 0L),
    uint32z(true, 140, 4, 0L),
    byte_(false, 13, 1, 255L),
    sint64(true, 142, 8, Long.MAX_VALUE),
    uint64(true, 143, 8, -1L),
    uint64z(true, 144, 8, 0L),
    UNKNOWN(false, 255, 0, 0L);

    private static final FitBaseType[] values;
    private final boolean endianAbility;
    private final short baseTypeField;
    private final byte size;
    private final long invalidValue;

    private FitBaseType(boolean endianAbility, int baseTypeField, int size, long invalidValue) {
        this.size = (byte)size;
        this.invalidValue = invalidValue;
        this.endianAbility = endianAbility;
        this.baseTypeField = (short)baseTypeField;
    }

    public static FitBaseType fromBaseTypeField(int baseTypeField) {
        for (FitBaseType type : values) {
            if (type.baseTypeField != baseTypeField) continue;
            return type;
        }
        return UNKNOWN;
    }

    byte size() {
        return this.size;
    }

    public long invalidValue() {
        return this.invalidValue;
    }

    static {
        values = FitBaseType.values();
    }
}

