/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.fit.lib.FitReader;
import org.openstreetmap.josm.plugins.fit.lib.FitReaderOptions;
import org.openstreetmap.josm.plugins.fit.lib.global.FitData;
import org.openstreetmap.josm.plugins.fit.lib.global.HeartRateCadenceDistanceSpeed;
import org.openstreetmap.josm.tools.I18n;

public class FitPlugin
extends Plugin {
    public FitPlugin(PluginInformation info) {
        super(info);
        ExtensionFileFilter.addImporter((FileImporter)new FitImporter());
    }

    private static final class FitImporter
    extends FileImporter {
        public FitImporter() {
            super(new ExtensionFileFilter("fit", "fit", I18n.tr((String)"FIT Files (*.fit)", (Object[])new Object[0])));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
            try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                FitData[] records = FitReader.read(inputStream, FitReaderOptions.TRY_TO_FINISH);
                GpxData gpxData = new GpxData(true);
                progressMonitor.beginTask(I18n.tr((String)"Processing FIT records", (Object[])new Object[0]), records.length);
                ArrayList<WayPoint> waypoints = new ArrayList<WayPoint>(records.length % 1000);
                int i = 0;
                while (true) {
                    if (i >= records.length) {
                        waypoints.trimToSize();
                        gpxData.addTrack((IGpxTrack)new GpxTrack(Collections.singleton(waypoints), Collections.emptyMap()));
                        gpxData.endUpdate();
                        MainApplication.getLayerManager().addLayer((Layer)new GpxLayer(gpxData, file.getName(), true));
                        return;
                    }
                    FitData r = records[i];
                    if (i % 1000 == 0) {
                        progressMonitor.worked(1);
                    }
                    if (r instanceof HeartRateCadenceDistanceSpeed) {
                        Object devData;
                        Object unknown;
                        int speed;
                        int distance;
                        short s2;
                        short s;
                        double ele;
                        double lon;
                        double lat;
                        Instant timestamp;
                        HeartRateCadenceDistanceSpeed heartRateCadenceDistanceSpeed = (HeartRateCadenceDistanceSpeed)r;
                        try {
                            double d;
                            Object object = heartRateCadenceDistanceSpeed.timestamp();
                            timestamp = object;
                            lat = d = heartRateCadenceDistanceSpeed.lat();
                            lon = d = heartRateCadenceDistanceSpeed.lon();
                            ele = d = heartRateCadenceDistanceSpeed.ele();
                            int n = heartRateCadenceDistanceSpeed.heartRate();
                            s = n;
                            n = heartRateCadenceDistanceSpeed.cadence();
                            s2 = n;
                            distance = n = heartRateCadenceDistanceSpeed.distance();
                            speed = n = heartRateCadenceDistanceSpeed.speed();
                            unknown = object = (Object)heartRateCadenceDistanceSpeed.unknown();
                            devData = object = heartRateCadenceDistanceSpeed.devData();
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        WayPoint waypoint = new WayPoint(new LatLon(lat, lon));
                        waypoint.setInstant(timestamp);
                        waypoint.attr.putAll(Map.of("ele", ele, "heart_rate", s, "cadence", s2, "distance", distance, "speed", speed, "unknown", unknown, "devData", devData));
                        waypoints.add(waypoint);
                    }
                    ++i;
                }
            }
        }
    }
}

