/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.geochat;

import java.awt.event.KeyEvent;
import java.util.HashSet;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;

public class JPanelTextField
extends DisableShortcutsOnFocusGainedTextField {
    private final KeyStroke[] standardKeys;
    private static final int MODIFIERS_MASK = 960;

    public JPanelTextField() {
        this.setFocusTraversalKeys(0, new HashSet());
        this.standardKeys = this.getInputMap(0).allKeys();
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            String text;
            int code = e.getKeyCode();
            if (code == 10) {
                text = this.getText();
                if (text.length() > 0) {
                    this.processEnter(text);
                    this.setText("");
                }
            } else if (code == 9) {
                String word;
                String complete;
                int start;
                text = this.getText();
                int caret = this.getCaretPosition();
                for (start = caret - 1; start >= 0 && Character.isJavaIdentifierPart(text.charAt(start)); --start) {
                }
                if (++start < caret && (complete = this.autoComplete(word = text.substring(start, caret), start == 0)) != null && !complete.equals(word)) {
                    StringBuilder sb = new StringBuilder();
                    if (start > 0) {
                        sb.append(text, 0, start);
                    }
                    sb.append(complete);
                    if (caret < text.length()) {
                        sb.append(text.substring(caret));
                    }
                    this.setText(sb.toString());
                    this.setCaretPosition(start + complete.length());
                }
            } else if (code == 27 && MainApplication.isDisplayingMapView()) {
                MainApplication.getMap().mapView.requestFocus();
            }
            boolean keyIsStandard = false;
            for (KeyStroke ks : this.standardKeys) {
                if (code != ks.getKeyCode() || (e.getModifiersEx() & 0x3C0) != (ks.getModifiers() & 0x3C0)) continue;
                keyIsStandard = true;
                break;
            }
            if (!keyIsStandard) {
                e.consume();
            }
        }
        super.processKeyEvent(e);
    }

    protected void processEnter(String text) {
    }

    protected String autoComplete(String word, boolean atStart) {
        return word;
    }
}

