/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.NodeWayUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AdjacentNodesAction
extends JosmAction {
    public static final boolean treeMode = false;
    private transient Set<Way> activeWays = new HashSet<Way>();

    public AdjacentNodesAction() {
        super(I18n.tr((String)"Adjacent nodes", (Object[])new Object[0]), "adjnodes", I18n.tr((String)"Select adjacent nodes", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:adjnodes", (String)I18n.tr((String)"Selection: {0}", (Object[])new Object[]{I18n.tr((String)"Adjacent nodes", (Object[])new Object[0])}), (int)69, (int)5003), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/AdjacentNodes"));
    }

    public void actionPerformed(ActionEvent e) {
        DataSet ds = this.getLayerManager().getActiveDataSet();
        Collection selectedNodes = ds.getSelectedNodes();
        LinkedHashSet<Way> selectedWays = new LinkedHashSet<Way>(ds.getSelectedWays());
        if (selectedNodes.isEmpty() && selectedWays.isEmpty()) {
            return;
        }
        if (selectedWays.isEmpty()) {
            if (selectedNodes.size() == 1) {
                this.activeWays.clear();
            }
        } else {
            this.activeWays = selectedWays;
        }
        if (selectedNodes.isEmpty()) {
            LinkedHashSet<Node> newNodes = new LinkedHashSet<Node>();
            NodeWayUtils.addNodesConnectedToWays(selectedWays, newNodes);
            this.activeWays.clear();
            ds.setSelected(newNodes);
            return;
        }
        if (this.activeWays.isEmpty()) {
            NodeWayUtils.addWaysConnectedToNodes(selectedNodes, this.activeWays);
        }
        LinkedHashSet<Node> newNodes = new LinkedHashSet<Node>();
        for (Node node : selectedNodes) {
            for (Way w : this.activeWays) {
                NodeWayUtils.addNeighbours(w, node, newNodes);
            }
        }
        newNodes.removeAll(selectedNodes);
        if (newNodes.isEmpty()) {
            this.activeWays.clear();
        }
        ds.addSelected(newNodes);
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        boolean hasSel;
        boolean bl = hasSel = selection != null && !selection.isEmpty();
        if (!hasSel && this.activeWays != null) {
            this.activeWays.clear();
        }
        this.setEnabled(hasSel);
    }
}

