/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import relcontext.ChosenRelation;
import relcontext.actions.SplittingMultipolygons;
import relcontext.actions.TheRing;

public class CreateMultipolygonAction
extends JosmAction {
    private static final String PREF_MULTIPOLY = "reltoolbox.multipolygon.";
    protected ChosenRelation chRel;
    public static final List<String> DEFAULT_LINEAR_TAGS = Arrays.asList("barrier", "source");
    private static final Set<String> REMOVE_FROM_BOUNDARY_TAGS = new TreeSet<String>(Arrays.asList("boundary", "boundary_type", "type", "admin_level"));

    public CreateMultipolygonAction(ChosenRelation chRel) {
        super("Multi", "data/multipolygon", I18n.tr((String)"Create a multipolygon from selected objects", (Object[])new Object[0]), Shortcut.registerShortcut((String)"reltoolbox:multipolygon", (String)I18n.tr((String)"Relation Toolbox: {0}", (Object[])new Object[]{I18n.tr((String)"Create multipolygon", (Object[])new Object[0])}), (int)65, (int)5008), false);
        this.chRel = chRel;
        this.updateEnabledState();
    }

    public CreateMultipolygonAction() {
        this(null);
    }

    public static boolean getDefaultPropertyValue(String property) {
        switch (property) {
            case "boundary": 
            case "alltags": 
            case "allowsplit": {
                return false;
            }
            case "boundaryways": 
            case "tags": 
            case "single": {
                return true;
            }
        }
        throw new IllegalArgumentException(property);
    }

    private boolean getPref(String property) {
        return Config.getPref().getBoolean(PREF_MULTIPOLY + property, CreateMultipolygonAction.getDefaultPropertyValue(property));
    }

    public void actionPerformed(ActionEvent e) {
        MultipolygonBuilder mpc;
        String error;
        boolean isBoundary = this.getPref("boundary");
        DataSet ds = this.getLayerManager().getEditDataSet();
        Collection selectedWays = ds.getSelectedWays();
        if (!isBoundary && this.getPref("tags")) {
            List<Relation> rels = null;
            if (this.getPref("allowsplit") || selectedWays.size() == 1) {
                if (SplittingMultipolygons.canProcess(selectedWays)) {
                    rels = SplittingMultipolygons.process(ds.getSelectedWays());
                }
            } else if (TheRing.areAllOfThoseRings(selectedWays)) {
                ArrayList<Command> commands = new ArrayList<Command>();
                rels = TheRing.makeManySimpleMultipolygons(ds.getSelectedWays(), commands);
                if (!commands.isEmpty()) {
                    UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.tr((String)"Create multipolygons from rings", (Object[])new Object[0]), commands));
                }
            }
            if (rels != null && !rels.isEmpty()) {
                if (this.chRel != null) {
                    this.chRel.set(rels.size() == 1 ? rels.get(0) : null);
                }
                if (rels.size() == 1) {
                    ds.setSelected(rels);
                } else {
                    ds.clearSelection();
                }
                return;
            }
        }
        if ((error = (mpc = new MultipolygonBuilder()).makeFromWays(ds.getSelectedWays())) != null) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), error);
            return;
        }
        Relation rel = new Relation();
        if (isBoundary) {
            rel.put("type", "boundary");
            rel.put("boundary", "administrative");
        } else {
            rel.put("type", "multipolygon");
        }
        for (MultipolygonBuilder.JoinedPolygon poly : mpc.outerWays) {
            for (Way w : poly.ways) {
                rel.addMember(new RelationMember("outer", (OsmPrimitive)w));
            }
        }
        for (MultipolygonBuilder.JoinedPolygon poly : mpc.innerWays) {
            for (Way w : poly.ways) {
                rel.addMember(new RelationMember("inner", (OsmPrimitive)w));
            }
        }
        List<Command> list = this.removeTagsFromInnerWays(rel);
        if (!list.isEmpty() && isBoundary) {
            UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.tr((String)"Move tags from ways to relation", (Object[])new Object[0]), list));
            list = new ArrayList<Command>();
        }
        if (isBoundary) {
            if (!this.askForAdminLevelAndName(rel)) {
                return;
            }
            this.addBoundaryMembers(rel);
            if (this.getPref("boundaryways")) {
                list.addAll(this.fixWayTagsForBoundary(rel));
            }
        }
        list.add((Command)new AddCommand(ds, (OsmPrimitive)rel));
        UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.tr((String)"Create multipolygon", (Object[])new Object[0]), list));
        if (this.chRel != null) {
            this.chRel.set(rel);
        }
        ds.setSelected(new PrimitiveId[]{rel});
    }

    protected void updateEnabledState() {
        if (this.getLayerManager().getEditDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getLayerManager().getEditDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        boolean isEnabled = true;
        if (selection == null || selection.isEmpty()) {
            isEnabled = false;
        } else if (!this.getPref("boundary")) {
            for (OsmPrimitive osmPrimitive : selection) {
                if (osmPrimitive instanceof Way) continue;
                isEnabled = false;
                break;
            }
        }
        this.setEnabled(isEnabled);
    }

    private void addBoundaryMembers(Relation rel) {
        for (OsmPrimitive p : this.getLayerManager().getEditDataSet().getSelected()) {
            Node n;
            String role = null;
            if (p.getType().equals((Object)OsmPrimitiveType.RELATION)) {
                role = "subarea";
            } else if (p.getType().equals((Object)OsmPrimitiveType.NODE) && !(n = (Node)p).isIncomplete()) {
                role = n.hasKey("place") ? "admin_centre" : "label";
            }
            if (role == null) continue;
            rel.addMember(new RelationMember(role, p));
        }
    }

    private List<Command> fixWayTagsForBoundary(Relation rel) {
        ArrayList<Command> commands = new ArrayList<Command>();
        if (!rel.hasKey("boundary") || !rel.hasKey("admin_level")) {
            return commands;
        }
        String adminLevelStr = rel.get("admin_level");
        int adminLevel = 0;
        try {
            adminLevel = Integer.parseInt(adminLevelStr);
        }
        catch (NumberFormatException e) {
            return commands;
        }
        HashSet<OsmPrimitive> waysBoundary = new HashSet<OsmPrimitive>();
        HashSet<OsmPrimitive> waysAdminLevel = new HashSet<OsmPrimitive>();
        for (OsmPrimitive p : rel.getMemberPrimitives()) {
            if (!(p instanceof Way)) continue;
            int count = 0;
            if (p.hasKey("boundary") && p.get("boundary").equals("administrative")) {
                ++count;
            }
            if (p.hasKey("admin_level")) {
                ++count;
            }
            if (p.keySet().size() - count != 0) continue;
            if (!p.hasKey("boundary")) {
                waysBoundary.add(p);
            }
            if (!p.hasKey("admin_level")) {
                waysAdminLevel.add(p);
                continue;
            }
            try {
                int oldAdminLevel = Integer.parseInt(p.get("admin_level"));
                if (oldAdminLevel <= adminLevel) continue;
                waysAdminLevel.add(p);
            }
            catch (NumberFormatException e) {
                waysAdminLevel.add(p);
            }
        }
        if (!waysBoundary.isEmpty()) {
            commands.add((Command)new ChangePropertyCommand(waysBoundary, "boundary", "administrative"));
        }
        if (!waysAdminLevel.isEmpty()) {
            commands.add((Command)new ChangePropertyCommand(waysAdminLevel, "admin_level", adminLevelStr));
        }
        return commands;
    }

    private List<Command> removeTagsFromInnerWays(Relation relation) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (relation.hasKeys()) {
            for (String key : relation.keySet()) {
                values.put(key, relation.get(key));
            }
        }
        ArrayList<Way> innerWays = new ArrayList<Way>();
        ArrayList<Way> outerWays = new ArrayList<Way>();
        TreeSet<Object> conflictingKeys = new TreeSet<Object>();
        for (Object m : relation.getMembers()) {
            if (m.hasRole() && "inner".equals(m.getRole()) && m.isWay() && m.getWay().hasKeys()) {
                innerWays.add(m.getWay());
            }
            if (!m.hasRole() || !"outer".equals(m.getRole()) || !m.isWay() || !m.getWay().hasKeys()) continue;
            Way way = m.getWay();
            outerWays.add(way);
            for (Object key : way.keySet()) {
                if (!values.containsKey(key)) {
                    values.put((String)key, way.get((String)key));
                    continue;
                }
                if (relation.hasKey((String)key) || ((String)values.get(key)).equals(way.get((String)key))) continue;
                conflictingKeys.add(key);
            }
        }
        boolean isBoundary = this.getPref("boundary");
        if (isBoundary || !this.getPref("alltags")) {
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.hasRole() || !relationMember.getRole().equals("outer") || !relationMember.isWay()) continue;
                for (Object key : values.keySet()) {
                    if (relationMember.getWay().hasKey((String)key) || relation.hasKey((String)key)) continue;
                    conflictingKeys.add(key);
                }
            }
        }
        for (String string : conflictingKeys) {
            values.remove(string);
        }
        for (String string : Config.getPref().getList("reltoolbox.multipolygon.lineartags", DEFAULT_LINEAR_TAGS)) {
            values.remove(string);
        }
        if (values.containsKey("natural") && ((String)values.get("natural")).equals("coastline")) {
            values.remove("natural");
        }
        String name = (String)values.get("name");
        if (isBoundary) {
            TreeSet treeSet = new TreeSet(values.keySet());
            for (Object key : treeSet) {
                if (REMOVE_FROM_BOUNDARY_TAGS.contains(key)) continue;
                values.remove(key);
            }
        }
        values.put("area", "yes");
        ArrayList<Command> arrayList = new ArrayList<Command>();
        boolean moveTags = this.getPref("tags");
        for (String key : values.keySet()) {
            ArrayList<Way> affectedWays = new ArrayList<Way>();
            String value = (String)values.get(key);
            for (Way way : innerWays) {
                if (!way.hasKey(key) || !isBoundary && !value.equals(way.get(key))) continue;
                affectedWays.add(way);
            }
            if (moveTags) {
                for (Way way : outerWays) {
                    if (!way.hasKey(key)) continue;
                    affectedWays.add(way);
                }
            }
            if (affectedWays.size() <= 0) continue;
            arrayList.add((Command)new ChangePropertyCommand(affectedWays, key, null));
        }
        if (moveTags) {
            if (isBoundary) {
                values.put("name", name);
            }
            boolean fixed = false;
            Relation r2 = new Relation(relation);
            for (String key : values.keySet()) {
                if (r2.hasKey(key) || key.equals("area") || isBoundary && !key.equals("admin_level") && !key.equals("name")) continue;
                if (relation.isNew()) {
                    relation.put(key, (String)values.get(key));
                } else {
                    r2.put(key, (String)values.get(key));
                }
                fixed = true;
            }
            if (fixed && !relation.isNew()) {
                arrayList.add((Command)new ChangeCommand((OsmPrimitive)relation, (OsmPrimitive)r2));
            }
        }
        return arrayList;
    }

    private boolean askForAdminLevelAndName(Relation rel) {
        String relAL = rel.get("admin_level");
        String relName = rel.get("name");
        if (relAL != null && relName != null) {
            return true;
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(I18n.tr((String)"Enter admin level and name for the border relation:", (Object[])new Object[0])), GBC.eol().insets(0, 0, 0, 5));
        final JTextField admin = new JTextField();
        admin.setText(relAL != null ? relAL : Config.getPref().get("reltoolbox.multipolygon.lastadmin", ""));
        panel.add((Component)new JLabel(I18n.tr((String)"Admin level", (Object[])new Object[0])), GBC.std());
        panel.add(Box.createHorizontalStrut(10), GBC.std());
        panel.add((Component)admin, GBC.eol().fill(2).insets(0, 0, 0, 5));
        JTextField name = new JTextField();
        if (relName != null) {
            name.setText(relName);
        }
        panel.add((Component)new JLabel(I18n.tr((String)"Name", (Object[])new Object[0])), GBC.std());
        panel.add(Box.createHorizontalStrut(10), GBC.std());
        panel.add((Component)name, GBC.eol().fill(2));
        final JOptionPane optionPane = new JOptionPane(panel, 3, 2){

            @Override
            public void selectInitialValue() {
                admin.requestFocusInWindow();
                admin.selectAll();
            }
        };
        final JDialog dlg = optionPane.createDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Create a new relation", (Object[])new Object[0]));
        dlg.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        name.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dlg.setVisible(false);
                optionPane.setValue(0);
            }
        });
        dlg.setVisible(true);
        Object answer = optionPane.getValue();
        if (answer == null || answer == JOptionPane.UNINITIALIZED_VALUE || answer instanceof Integer && (Integer)answer != 0) {
            return false;
        }
        String admin_level = admin.getText().trim();
        String new_name = name.getText().trim();
        if (admin_level.equals("10") || admin_level.length() == 1 && Character.isDigit(admin_level.charAt(0))) {
            rel.put("admin_level", admin_level);
            Config.getPref().put("reltoolbox.multipolygon.lastadmin", admin_level);
        }
        if (new_name.length() > 0) {
            rel.put("name", new_name);
        }
        return true;
    }
}

