/*
 * Decompiled with CFR 0.152.
 */
package relcontext.relationfix;

import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import relcontext.relationfix.MultipolygonFixer;

public class BoundaryFixer
extends MultipolygonFixer {
    public BoundaryFixer() {
        super("boundary", "multipolygon");
    }

    @Override
    public boolean isFixerApplicable(Relation rel) {
        return super.isFixerApplicable(rel) && "administrative".equals(rel.get("boundary"));
    }

    @Override
    public boolean isRelationGood(Relation rel) {
        for (RelationMember m : rel.getMembers()) {
            if (m.getType().equals((Object)OsmPrimitiveType.RELATION) && !"subarea".equals(m.getRole())) {
                this.setWarningMessage(I18n.tr((String)"Relation without ''subarea'' role found", (Object[])new Object[0]));
                return false;
            }
            if (m.getType().equals((Object)OsmPrimitiveType.NODE) && !"label".equals(m.getRole()) && !"admin_centre".equals(m.getRole())) {
                this.setWarningMessage(I18n.tr((String)"Node without ''label'' or ''admin_centre'' role found", (Object[])new Object[0]));
                return false;
            }
            if (!m.getType().equals((Object)OsmPrimitiveType.WAY) || "outer".equals(m.getRole()) || "inner".equals(m.getRole())) continue;
            this.setWarningMessage(I18n.tr((String)"Way without ''inner'' or ''outer'' role found", (Object[])new Object[0]));
            return false;
        }
        this.clearWarningMessage();
        return true;
    }

    @Override
    public Command fixRelation(Relation rel) {
        Relation r = rel;
        Relation rr = this.fixMultipolygonRoles(r);
        boolean fixed = false;
        if (rr != null) {
            fixed = true;
            r = rr;
        }
        if ((rr = this.fixBoundaryRoles(r)) != null) {
            fixed = true;
            r = rr;
        }
        if (fixed) {
            DataSet ds = (DataSet)Utils.firstNonNull((Object[])new DataSet[]{rel.getDataSet(), MainApplication.getLayerManager().getEditDataSet()});
            return new ChangeCommand(ds, (OsmPrimitive)rel, (OsmPrimitive)r);
        }
        return null;
    }

    private Relation fixBoundaryRoles(Relation source) {
        Relation r = new Relation(source);
        boolean fixed = false;
        for (int i = 0; i < r.getMembersCount(); ++i) {
            Node n;
            RelationMember m = r.getMember(i);
            String role = null;
            if (m.isRelation()) {
                role = "subarea";
            } else if (m.isNode() && !(n = (Node)m.getMember()).isIncomplete()) {
                String place;
                role = n.hasKey("place") ? ((place = n.get("place")).equals("state") || place.equals("country") || place.equals("county") || place.equals("region") ? "label" : "admin_centre") : "label";
            }
            if (role == null || role.equals(m.getRole())) continue;
            r.setMember(i, new RelationMember(role, m.getMember()));
            fixed = true;
        }
        return fixed ? r : null;
    }
}

