/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;

public class ReconstructPolygonAction
extends JosmAction
implements ChosenRelationListener {
    private final ChosenRelation rel;
    private static final List<String> IRRELEVANT_KEYS = Arrays.asList("source", "created_by", "note");

    public ReconstructPolygonAction(ChosenRelation rel) {
        super(I18n.tr((String)"Reconstruct polygon", (Object[])new Object[0]), "dialogs/filter", I18n.tr((String)"Reconstruct polygon from multipolygon relation", (Object[])new Object[0]), Shortcut.registerShortcut((String)"reltoolbox:reconstructpoly", (String)I18n.tr((String)"Relation Toolbox: {0}", (Object[])new Object[]{I18n.tr((String)"Reconstruct polygon from multipolygon relation", (Object[])new Object[0])}), (int)65535, (int)5000), false);
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(ReconstructPolygonAction.isSuitableRelation(rel.get()));
    }

    public void actionPerformed(ActionEvent e) {
        Relation r = this.rel.get();
        boolean relationReused = false;
        ArrayList<Way> ways = new ArrayList<Way>();
        boolean wont = false;
        for (RelationMember m : r.getMembers()) {
            if (m.isWay()) {
                ways.add(m.getWay());
                continue;
            }
            wont = true;
        }
        if (wont) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Multipolygon must consist only of ways", (Object[])new Object[0]), I18n.tr((String)"Reconstruct polygon", (Object[])new Object[0]), 0);
            return;
        }
        MultipolygonBuilder mpc = new MultipolygonBuilder();
        String error = mpc.makeFromWays(ways);
        if (error != null) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), error);
            return;
        }
        this.rel.clear();
        ArrayList<Object> newSelection = new ArrayList<Object>();
        ArrayList<Object> commands = new ArrayList<Object>();
        Command relationDeleteCommand = DeleteCommand.delete(Collections.singleton(r), (boolean)true, (boolean)true);
        if (relationDeleteCommand == null) {
            return;
        }
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        for (MultipolygonBuilder.JoinedPolygon p : mpc.outerWays) {
            Object w3;
            ArrayList<Object> myInnerWays = new ArrayList<Object>();
            for (Object i : mpc.innerWays) {
                EastNorth en = ((Way)((MultipolygonBuilder.JoinedPolygon)i).ways.get(0)).firstNode().getEastNorth();
                if (!p.area.contains(en.east(), en.north())) continue;
                myInnerWays.add(i);
            }
            if (!myInnerWays.isEmpty()) {
                Relation n;
                Object i;
                if (relationReused) {
                    n = new Relation();
                    n.setKeys(r.getKeys());
                } else {
                    n = new Relation(r);
                    n.setMembers(null);
                }
                for (Way w2 : p.ways) {
                    n.addMember(new RelationMember("outer", (OsmPrimitive)w2));
                }
                i = myInnerWays.iterator();
                while (i.hasNext()) {
                    MultipolygonBuilder.JoinedPolygon i2 = (MultipolygonBuilder.JoinedPolygon)i.next();
                    for (Object w3 : i2.ways) {
                        n.addMember(new RelationMember("inner", (OsmPrimitive)w3));
                    }
                }
                if (relationReused) {
                    commands.add(new AddCommand(ds, (OsmPrimitive)n));
                } else {
                    relationReused = true;
                    commands.add(new ChangeCommand((OsmPrimitive)r, (OsmPrimitive)n));
                }
                newSelection.add(n);
                continue;
            }
            TagMap tags = ((Way)p.ways.get(0)).getKeys();
            if (!((Way)p.ways.get(0)).hasAreaTags()) {
                tags.clear();
            }
            List relations = ((Way)p.ways.get(0)).getReferrers();
            HashSet<String> noTags = new HashSet<String>(r.keySet());
            for (int i = 1; i < p.ways.size(); ++i) {
                w3 = (Way)p.ways.get(i);
                for (String key : w3.keySet()) {
                    String value = w3.get(key);
                    if (noTags.contains(key) || !tags.containsKey(key) || ((String)tags.get(key)).equals(value)) continue;
                    tags.remove(key);
                    noTags.add(key);
                }
                List referrers = w3.getReferrers();
                relations.removeIf(osmPrimitive -> !referrers.contains(osmPrimitive));
            }
            tags.putAll(r.getKeys());
            tags.remove("type");
            Way candidateWay = null;
            w3 = p.ways.iterator();
            while (w3.hasNext()) {
                Way w4 = (Way)w3.next();
                if (!w4.getReferrers().equals(relations)) continue;
                HashSet keys = new HashSet(w4.keySet());
                keys.removeAll(tags.keySet());
                IRRELEVANT_KEYS.forEach(keys::remove);
                if (!keys.isEmpty()) continue;
                if (candidateWay == null) {
                    candidateWay = w4;
                    continue;
                }
                if (candidateWay.isNew() && !w4.isNew()) {
                    Way tmp = w4;
                    w4 = candidateWay;
                    candidateWay = tmp;
                }
                commands.add(DeleteCommand.delete(Collections.singleton(w4)));
            }
            Way result = candidateWay == null ? new Way() : new Way(candidateWay);
            result.setNodes(p.nodes);
            result.addNode(result.firstNode());
            result.setKeys((Map)tags);
            newSelection.add(candidateWay == null ? result : candidateWay);
            commands.add(candidateWay == null ? new AddCommand(ds, (OsmPrimitive)result) : new ChangeCommand(candidateWay, (OsmPrimitive)result));
        }
        if (!relationReused) {
            commands.add(relationDeleteCommand);
        }
        UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.tr((String)"Reconstruct polygons from relation {0}", (Object[])new Object[]{r.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands));
        ds.setSelected(newSelection);
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setEnabled(ReconstructPolygonAction.isSuitableRelation(newRelation));
    }

    private static boolean isSuitableRelation(Relation newRelation) {
        return newRelation != null && "multipolygon".equals(newRelation.get("type")) && newRelation.getMembersCount() != 0;
    }
}

