/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.command.SplitWayCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.MultipolygonTest;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class SplitObjectAction
extends JosmAction {
    private static final String ALLOW_INV_MP_SPLIT_KEY = "utilsplugin2.split-object.allowInvalidMultipolygonSplit";

    public SplitObjectAction() {
        super(I18n.tr((String)"Split Object", (Object[])new Object[0]), "splitobject", I18n.tr((String)"Split an object at the selected nodes.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:splitobject", (String)I18n.tr((String)"More tools: {0}", (Object[])new Object[]{I18n.tr((String)"Split Object", (Object[])new Object[0])}), (int)88, (int)5004), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SplitObject"));
    }

    public void actionPerformed(ActionEvent e) {
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (!SplitObjectAction.checkSelection(ds.getSelected())) {
            SplitObjectAction.showWarningNotification(I18n.tr((String)"The current selection cannot be used for splitting.", (Object[])new Object[0]));
            return;
        }
        ArrayList<Node> selectedNodes = new ArrayList<Node>(ds.getSelectedNodes());
        ArrayList selectedWays = new ArrayList(ds.getSelectedWays());
        ArrayList selectedRelations = new ArrayList(ds.getSelectedRelations());
        Way selectedWay = null;
        Way splitWay = null;
        if (selectedNodes.size() != 2) {
            selectedNodes.clear();
            for (Way selWay : selectedWays) {
                if (selWay != null && selWay.isUsable() && selWay.getNodesCount() > 0 && !selWay.isClosed() && selWay.getKeys().isEmpty()) {
                    selectedNodes.add(selWay.firstNode());
                    selectedNodes.add(selWay.lastNode());
                    splitWay = selWay;
                    continue;
                }
                selectedWay = selWay;
            }
        } else if (selectedWays.size() == 1) {
            selectedWay = (Way)selectedWays.get(0);
        }
        if (selectedRelations.size() > 1) {
            SplitObjectAction.showWarningNotification(I18n.tr((String)"Only one multipolygon can be selected for splitting", (Object[])new Object[0]));
            return;
        }
        if (selectedRelations.size() == 1 && ((Relation)selectedRelations.get(0)).isMultipolygon()) {
            Relation selectedMultipolygon = (Relation)selectedRelations.get(0);
            if (splitWay == null) {
                SplitObjectAction.showWarningNotification(I18n.tr((String)"Splitting multipolygons requires a split way to be selected", (Object[])new Object[0]));
                return;
            }
            boolean allowInvalidMpSplit = Config.getPref().getBoolean(ALLOW_INV_MP_SPLIT_KEY, false);
            SplitObjectAction.splitMultipolygonAtWayChecked(selectedMultipolygon, splitWay, allowInvalidMpSplit);
            return;
        }
        if (selectedWay == null && !selectedNodes.isEmpty()) {
            HashMap<Way, Integer> wayOccurenceCounter = new HashMap<Way, Integer>();
            for (Node node : selectedNodes) {
                block2: for (Way w : node.getParentWays()) {
                    if (!w.isUsable() || w.getNodesCount() < 5 || !w.isClosed()) continue;
                    for (Node wn : w.getNodes()) {
                        if (!node.equals((Object)wn)) continue;
                        Integer old = (Integer)wayOccurenceCounter.get(w);
                        wayOccurenceCounter.put(w, old == null ? 1 : old + 1);
                        continue block2;
                    }
                }
            }
            if (wayOccurenceCounter.isEmpty()) {
                SplitObjectAction.showWarningNotification(I18n.trn((String)"The selected node is not in the middle of any way.", (String)"The selected nodes are not in the middle of any way.", (long)selectedNodes.size(), (Object[])new Object[0]));
                return;
            }
            for (Map.Entry entry : wayOccurenceCounter.entrySet()) {
                if (!((Integer)entry.getValue()).equals(selectedNodes.size())) continue;
                if (selectedWay != null) {
                    SplitObjectAction.showWarningNotification(I18n.trn((String)"There is more than one way using the node you selected. Please select the way as well.", (String)"There is more than one way using the nodes you selected. Please select the way as well.", (long)selectedNodes.size(), (Object[])new Object[0]));
                    return;
                }
                selectedWay = (Way)entry.getKey();
            }
            if (selectedWay == null) {
                SplitObjectAction.showWarningNotification(I18n.tr((String)"The selected nodes do not share the same way.", (Object[])new Object[0]));
                return;
            }
        } else if (selectedWay != null && !selectedNodes.isEmpty()) {
            if (!selectedWay.isClosed()) {
                SplitObjectAction.showWarningNotification(I18n.tr((String)"The selected way is not closed.", (Object[])new Object[0]));
                return;
            }
            HashSet nds = new HashSet(selectedNodes);
            nds.removeAll(selectedWay.getNodes());
            if (!nds.isEmpty()) {
                SplitObjectAction.showWarningNotification(I18n.trn((String)"The selected way does not contain the selected node.", (String)"The selected way does not contain all the selected nodes.", (long)selectedNodes.size(), (Object[])new Object[0]));
                return;
            }
        } else if (selectedWay != null && selectedNodes.isEmpty()) {
            SplitObjectAction.showWarningNotification(I18n.tr((String)"The selected way is not a split way, please select split points or split way too.", (Object[])new Object[0]));
            return;
        }
        Node node1 = (Node)selectedNodes.get(0);
        int nodeIndex1 = -1;
        Node node = (Node)selectedNodes.get(1);
        int nodeIndex2 = -1;
        int i = 0;
        for (Node wn : selectedWay.getNodes()) {
            if (nodeIndex1 == -1 && wn.equals((Object)node1)) {
                nodeIndex1 = i;
            } else if (nodeIndex2 == -1 && wn.equals((Object)node)) {
                nodeIndex2 = i;
            }
            ++i;
        }
        if ((splitWay == null || splitWay.getNodesCount() == 2) && (nodeIndex1 == nodeIndex2 + 1 || nodeIndex2 == nodeIndex1 + 1 || nodeIndex1 == 0 && nodeIndex2 == selectedWay.getNodesCount() - 2 || nodeIndex2 == 0 && nodeIndex1 == selectedWay.getNodesCount() - 2)) {
            SplitObjectAction.showWarningNotification(I18n.tr((String)"The selected nodes can not be consecutive nodes in the object.", (Object[])new Object[0]));
            return;
        }
        this.splitWayChecked(selectedNodes, selectedWay, splitWay);
    }

    private void splitWayChecked(List<Node> selectedNodes, Way selectedWay, Way splitWay) {
        List wayChunks = SplitWayCommand.buildSplitChunks((Way)selectedWay, selectedNodes);
        if (wayChunks != null) {
            if (splitWay == null) {
                for (List wayChunk : wayChunks) {
                    wayChunk.add((Node)wayChunk.get(0));
                }
            } else {
                for (List wayChunk : wayChunks) {
                    List way = splitWay.getNodes();
                    if (((Node)wayChunk.get(0)).equals((Object)splitWay.firstNode())) {
                        way.remove(way.size() - 1);
                        Collections.reverse(way);
                    } else {
                        way.remove(0);
                    }
                    wayChunk.addAll(way);
                }
            }
            SplitWayCommand result = SplitWayCommand.splitWay((Way)selectedWay, (List)wayChunks, Collections.emptyList());
            if (splitWay != null) {
                result.executeCommand();
                Command delCmd = DeleteCommand.delete(Collections.singletonList(splitWay));
                delCmd.executeCommand();
                UndoRedoHandler.getInstance().add((Command)new SplitObjectCommand(Arrays.asList(result, delCmd)), false);
            } else {
                UndoRedoHandler.getInstance().add((Command)result);
            }
            this.getLayerManager().getEditDataSet().setSelected((Collection)result.getNewSelection());
        }
    }

    public static Pair<List<Relation>, List<Command>> splitMultipolygonAtWayChecked(Relation mpRelation, Way splitWay, boolean allowInvalidSplit) {
        CheckParameterUtil.ensureParameterNotNull((Object)mpRelation, (String)"mpRelation");
        CheckParameterUtil.ensureParameterNotNull((Object)splitWay, (String)"splitWay");
        CheckParameterUtil.ensureThat((boolean)mpRelation.isMultipolygon(), (String)"mpRelation.isMultipolygon");
        try {
            Pair<List<Relation>, List<Command>> splitResult = SplitObjectAction.splitMultipolygonAtWay(mpRelation, splitWay, allowInvalidSplit);
            List mpRelations = (List)splitResult.a;
            List commands = (List)splitResult.b;
            ArrayList mpErrorsPostSplit = new ArrayList();
            for (Relation mp : mpRelations) {
                MultipolygonTest mpTestPostSplit = new MultipolygonTest();
                mpTestPostSplit.visit(mp);
                List severeErrors = mpTestPostSplit.getErrors().stream().filter(e -> e.getSeverity().getLevel() <= Severity.ERROR.getLevel()).collect(Collectors.toList());
                mpErrorsPostSplit.addAll(severeErrors);
            }
            if (!mpErrorsPostSplit.isEmpty()) {
                if (!allowInvalidSplit) {
                    SplitObjectAction.showWarningNotification(I18n.tr((String)"Multipolygon split would create invalid multipolygons! Split was not performed.", (Object[])new Object[0]));
                    for (TestError testError : mpErrorsPostSplit) {
                        SplitObjectAction.showWarningNotification(testError.getMessage());
                    }
                    for (int i = commands.size() - 1; i >= 0; --i) {
                        ((Command)commands.get(i)).undoCommand();
                    }
                    return new Pair(new ArrayList(), new ArrayList());
                }
                SplitObjectAction.showWarningNotification(I18n.tr((String)"Multipolygon split created invalid multipolygons! Please review and fix these errors.", (Object[])new Object[0]));
                for (TestError testError : mpErrorsPostSplit) {
                    SplitObjectAction.showWarningNotification(testError.getMessage());
                }
            }
            if (commands.size() > 1) {
                UndoRedoHandler.getInstance().add((Command)new SplitObjectCommand(commands), false);
            } else {
                UndoRedoHandler.getInstance().add((Command)commands.iterator().next(), false);
            }
            mpRelation.getDataSet().setSelected((Collection)mpRelations);
            return splitResult;
        }
        catch (IllegalArgumentException e2) {
            Logging.trace((Throwable)e2);
            SplitObjectAction.showWarningNotification(e2.getMessage());
            return new Pair(new ArrayList(), new ArrayList());
        }
    }

    public static Pair<List<Relation>, List<Command>> splitMultipolygonAtWay(Relation mpRelation, Way splitWay, boolean allowInvalidSplit) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)mpRelation, (String)"mpRelation");
        CheckParameterUtil.ensureParameterNotNull((Object)splitWay, (String)"splitWay");
        CheckParameterUtil.ensureThat((boolean)mpRelation.isMultipolygon(), (String)"mpRelation.isMultipolygon");
        ArrayList<Object> commands = new ArrayList<Object>();
        ArrayList<Relation> mpRelations = new ArrayList<Relation>();
        mpRelations.add(mpRelation);
        Multipolygon mp = new Multipolygon(mpRelation);
        if (mp.isIncomplete()) {
            throw new IllegalArgumentException(I18n.tr((String)"Cannot split incomplete multipolygon", (Object[])new Object[0]));
        }
        if (mp.getOuterPolygons().size() > 1) {
            throw new IllegalArgumentException(I18n.tr((String)"Cannot split multipolygon with multiple outer polygons", (Object[])new Object[0]));
        }
        if (mpRelation.getMembers().stream().filter(RelationMember::isWay).anyMatch(w -> w.getWay() == splitWay)) {
            throw new IllegalArgumentException(I18n.tr((String)"Split ways must not be a member of the multipolygon", (Object[])new Object[0]));
        }
        if (!mp.getOpenEnds().isEmpty()) {
            throw new IllegalArgumentException(I18n.tr((String)"Multipolygon has unclosed rings", (Object[])new Object[0]));
        }
        List outerWaysUnsplit = mp.getOuterWays();
        Node firstNode = splitWay.firstNode();
        Node lastNode = splitWay.lastNode();
        Set firstNodeWays = firstNode.getParentWays().stream().filter(outerWaysUnsplit::contains).collect(Collectors.toSet());
        Set lastNodeWays = lastNode.getParentWays().stream().filter(outerWaysUnsplit::contains).collect(Collectors.toSet());
        if (firstNodeWays.isEmpty() || lastNodeWays.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr((String)"The split way does not start/end on the multipolygon outer ways", (Object[])new Object[0]));
        }
        commands.addAll(SplitObjectAction.splitMultipolygonWaysAtNodes(mpRelation, Arrays.asList(firstNode, lastNode)));
        mp = new Multipolygon(mpRelation);
        List joinedOuter = null;
        try {
            joinedOuter = MultipolygonBuilder.joinWays((Collection)mp.getOuterWays());
        }
        catch (MultipolygonBuilder.JoinedPolygonCreationException e) {
            for (int i = commands.size() - 1; i >= 0; --i) {
                ((Command)commands.get(i)).undoCommand();
            }
            throw new IllegalArgumentException(I18n.tr((String)"Error in multipolygon: {0}", (Object[])new Object[]{e.getMessage()}), e);
        }
        for (MultipolygonBuilder.JoinedPolygon outerRing : joinedOuter) {
            int firstIndex = -1;
            int lastIndex = -1;
            if (outerRing.nodes.containsAll(Arrays.asList(firstNode, lastNode))) {
                for (int i = 0; i < outerRing.ways.size() && (firstIndex == -1 || lastIndex == -1); ++i) {
                    Node cEndNode;
                    Way w2 = (Way)outerRing.ways.get(i);
                    boolean reversed = (Boolean)outerRing.reversed.get(i);
                    Node cStartNode = reversed ? w2.lastNode() : w2.firstNode();
                    Node node = cEndNode = reversed ? w2.firstNode() : w2.lastNode();
                    if (cStartNode == firstNode) {
                        firstIndex = i;
                    }
                    if (cEndNode != lastNode) continue;
                    lastIndex = i;
                }
            }
            if (firstIndex == -1 || lastIndex == -1) continue;
            int startIt = -1;
            int endIt = -1;
            if (firstIndex <= lastIndex) {
                startIt = firstIndex;
                endIt = lastIndex + 1;
            } else {
                startIt = lastIndex + 1;
                endIt = firstIndex;
            }
            List newOuterRingWays = outerRing.ways.subList(startIt, endIt);
            RelationMember splitWayMember = new RelationMember("outer", (OsmPrimitive)splitWay);
            List mpMembers = mpRelation.getMembers();
            List newMpMembers = mpMembers.stream().filter(m -> m.isWay() && newOuterRingWays.contains(m.getWay())).collect(Collectors.toList());
            mpMembers.removeAll(newMpMembers);
            mpMembers.add(splitWayMember);
            Relation newMpRelation = new Relation(mpRelation, true, false);
            newMpMembers.add(splitWayMember);
            newMpRelation.setMembers(newMpMembers);
            Multipolygon newMp = new Multipolygon(newMpRelation);
            for (Multipolygon.PolyData inner : mp.getInnerPolygons()) {
                block10: for (Multipolygon.PolyData newOuter : newMp.getOuterPolygons()) {
                    Multipolygon.PolyData.Intersection intersection = newOuter.contains(inner.get());
                    switch (intersection) {
                        case INSIDE: {
                            Collection innerWayIds = inner.getWayIds();
                            List innerWayMembers = mpMembers.stream().filter(m -> m.isWay() && innerWayIds.contains(m.getWay().getUniqueId())).collect(Collectors.toList());
                            mpMembers.removeAll(innerWayMembers);
                            for (RelationMember innerWayMember : innerWayMembers) {
                                newMpRelation.addMember(innerWayMember);
                            }
                            continue block10;
                        }
                        case CROSSING: {
                            if (allowInvalidSplit) break;
                            for (int i = commands.size() - 1; i >= 0; --i) {
                                ((Command)commands.get(i)).undoCommand();
                            }
                            throw new IllegalArgumentException(I18n.tr((String)"Split way crosses inner polygon", (Object[])new Object[0]));
                        }
                    }
                }
            }
            ArrayList<Object> mpCreationCommands = new ArrayList<Object>();
            mpCreationCommands.add(new ChangeMembersCommand(mpRelation, mpMembers));
            mpCreationCommands.add(new AddCommand(mpRelation.getDataSet(), (OsmPrimitive)newMpRelation));
            mpCreationCommands.forEach(Command::executeCommand);
            commands.addAll(mpCreationCommands);
            mpRelations.add(newMpRelation);
        }
        return new Pair(mpRelations, commands);
    }

    public static List<SplitWayCommand> splitMultipolygonWaysAtNodes(Relation mpRelation, Collection<Node> splitNodes) {
        CheckParameterUtil.ensureParameterNotNull((Object)mpRelation, (String)"mpRelation");
        CheckParameterUtil.ensureParameterNotNull(splitNodes, (String)"splitNodes");
        Set mpWays = mpRelation.getMembers().stream().filter(RelationMember::isWay).map(RelationMember::getWay).collect(Collectors.toSet());
        ArrayList<SplitWayCommand> splitCmds = new ArrayList<SplitWayCommand>();
        for (Way way : mpWays) {
            List wayChunks;
            List containedNodes = way.getNodes().stream().filter(n -> splitNodes.contains(n) && (way.isClosed() || n != way.firstNode() && n != way.lastNode())).collect(Collectors.toList());
            if (containedNodes.isEmpty() || (wayChunks = SplitWayCommand.buildSplitChunks((Way)way, containedNodes)) == null) continue;
            SplitWayCommand result = SplitWayCommand.splitWay((Way)way, (List)wayChunks, Collections.emptyList());
            result.executeCommand();
            splitCmds.add(result);
        }
        return splitCmds;
    }

    private static boolean checkSelection(Collection<? extends OsmPrimitive> selection) {
        int node = 0;
        int ways = 0;
        int multipolygons = 0;
        for (OsmPrimitive osmPrimitive : selection) {
            if (osmPrimitive instanceof Way) {
                ++ways;
                continue;
            }
            if (osmPrimitive instanceof Node) {
                ++node;
                continue;
            }
            if (osmPrimitive.isMultipolygon()) {
                ++multipolygons;
                continue;
            }
            return false;
        }
        return node == 2 || ways == 1 || ways == 2 || multipolygons == 1 && ways == 1;
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(SplitObjectAction.checkSelection(selection));
    }

    private static void showWarningNotification(String msg) {
        new Notification(msg).setIcon(2).show();
    }

    private static class SplitObjectCommand
    extends SequenceCommand {
        SplitObjectCommand(Collection<Command> sequenz) {
            super(I18n.tr((String)"Split Object", (Object[])new Object[0]), sequenz, true);
            this.setSequenceComplete(true);
        }
    }
}

