/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ywms;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.util.Date;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.plugins.ywms.ImageLoader;

public class RequestProcessor
extends Thread {
    private Socket request;

    public RequestProcessor(Socket request) {
        super("YWMS request processor");
        this.setDaemon(true);
        this.request = request;
    }

    public static void processRequest(Socket request) {
        RequestProcessor processor = new RequestProcessor(request);
        processor.start();
    }

    public void run() {
        String url;
        BufferedOutputStream raw;
        OutputStreamWriter out;
        block18: {
            int c;
            out = null;
            raw = new BufferedOutputStream(this.request.getOutputStream());
            out = new OutputStreamWriter(raw);
            InputStreamReader in = new InputStreamReader((InputStream)new BufferedInputStream(this.request.getInputStream()), "ASCII");
            StringBuffer requestLine = new StringBuffer();
            while ((c = ((Reader)in).read()) != 13 && c != 10) {
                requestLine.append((char)c);
            }
            String get = requestLine.toString();
            StringTokenizer st = new StringTokenizer(get);
            String method = st.nextToken();
            url = st.nextToken();
            if (method.equals("GET")) break block18;
            this.sendNotImplemented(out);
            try {
                this.request.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            try {
                ImageLoader imageLdr = new ImageLoader(url);
                BufferedImage wmsImage = imageLdr.getBufferedImage();
                ByteArrayOutputStream imageStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)wmsImage, "jpeg", imageStream);
                byte[] data = imageStream.toByteArray();
                this.sendHeader(out, "200 OK", "image/jpeg", false);
                out.write("Content-length: " + data.length + "\r\n");
                out.write("\r\n");
                ((Writer)out).flush();
                ((OutputStream)raw).write(data);
                ((OutputStream)raw).flush();
            }
            catch (IOException raw2) {
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.sendError(out);
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                this.request.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void sendError(Writer out) throws IOException {
        this.sendHeader(out, "500 Internal Server Error", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Internal Error</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 500: Internal Server Error</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendNotImplemented(Writer out) throws IOException {
        this.sendHeader(out, "501 Not Implemented", "text/html", true);
        out.write("<HTML>\r\n");
        out.write("<HEAD><TITLE>Not Implemented</TITLE>\r\n");
        out.write("</HEAD>\r\n");
        out.write("<BODY>");
        out.write("<H1>HTTP Error 501: Not Implemented</h2>\r\n");
        out.write("</BODY></HTML>\r\n");
        out.flush();
    }

    private void sendHeader(Writer out, String status, String contentType, boolean endHeaders) throws IOException {
        out.write("HTTP/1.1 " + status + "\r\n");
        Date now = new Date();
        out.write("Date: " + now + "\r\n");
        out.write("Server: YWMS Server 1.0\r\n");
        out.write("Content-type: " + contentType + "\r\n");
        if (endHeaders) {
            out.write("\r\n");
        }
    }
}

