/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.gui.layers;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.MapboxVectorTileSource;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.style.MapboxVectorStyle;
import org.openstreetmap.josm.plugins.pmtiles.data.imagery.PMTilesImageryInfo;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.PMTilesTileSource;
import org.openstreetmap.josm.plugins.pmtiles.lib.Header;

public class PMTilesMVTTileSource
extends MapboxVectorTileSource
implements PMTilesTileSource {
    private final JsonObject metadata;
    private final Header header;
    private final MapboxVectorStyle styleSource;

    public PMTilesMVTTileSource(PMTilesImageryInfo info) {
        super((ImageryInfo)info);
        this.metadata = info.metadata();
        this.header = info.header();
        this.baseUrl = info.header().location().toString();
        if (info.metadata().containsKey((Object)"vector_layers") && ((JsonValue)info.metadata().get((Object)"vector_layers")).getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray tileJson = info.metadata().getJsonArray("vector_layers");
            JsonObjectBuilder builder = Json.createObjectBuilder().add("version", 8).add("sources", (JsonValue)tileJson);
            if (this.metadata.containsKey((Object)"name")) {
                builder.add("name", this.metadata.getString("name"));
            }
            this.styleSource = new MapboxVectorStyle(builder.build());
        } else {
            this.styleSource = null;
        }
    }

    @Override
    public JsonObject metadata() {
        return this.metadata;
    }

    @Override
    public Header header() {
        return this.header;
    }

    @Override
    public OsmMercator osmMercator() {
        return this.osmMercator;
    }

    public MapboxVectorStyle getStyleSource() {
        return this.styleSource;
    }
}

