/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.pmtiles.data.imagery.PMTilesImageryInfo;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.PMTilesImageLayer;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.PMTilesMVTLayer;
import org.openstreetmap.josm.plugins.pmtiles.lib.Header;
import org.openstreetmap.josm.plugins.pmtiles.lib.PMTiles;
import org.openstreetmap.josm.plugins.pmtiles.lib.TileType;
import org.openstreetmap.josm.tools.I18n;

public class PMTilesFileImporter
extends FileImporter {
    public PMTilesFileImporter() {
        super(new ExtensionFileFilter("pmtiles", "pmtiles", I18n.tr((String)"PMTiles tilesets ({0})", (Object[])new Object[]{".pmtiles"})));
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        Header header = PMTiles.readHeader(file.toURI());
        PMTilesImageryInfo info = new PMTilesImageryInfo(header);
        if (header.tileType() == TileType.MVT) {
            MainApplication.getLayerManager().addLayer((Layer)new PMTilesMVTLayer(info));
        } else {
            MainApplication.getLayerManager().addLayer((Layer)new PMTilesImageLayer(info));
        }
    }
}

