/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.gui.layers;

import org.openstreetmap.josm.plugins.pmtiles.data.imagery.PMTilesImageryInfo;
import org.openstreetmap.josm.tools.TextUtils;
import org.openstreetmap.josm.tools.Utils;

interface PMTilesLayer {
    public PMTilesImageryInfo getInfo();

    default public String getChangesetSourceTag() {
        StringBuilder sb = new StringBuilder();
        PMTilesImageryInfo info = this.getInfo();
        if (info.hasAttribution()) {
            sb.append(this.getInfo().getAttributionText(0, null, null).replaceAll("<a [^>]*>|</a>", "").replaceAll("  +", " "));
        }
        if (info.getName() != null) {
            if (!sb.isEmpty()) {
                sb.append(" - ");
            }
            sb.append(info.getName());
        }
        if (sb.isEmpty()) {
            String location = info.header().location().toString();
            if (Utils.isLocalUrl((String)location)) {
                String userName = Utils.getSystemProperty((String)"user.name");
                String userNameAlt = "<user.name>";
                sb.append(location.replace(userName, "<user.name>"));
            } else {
                sb.append(TextUtils.stripUrl((String)location));
            }
        }
        return sb.toString();
    }
}

