/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.gui.layers;

import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.plugins.pmtiles.data.imagery.PMTilesImageryInfo;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.PMTilesImageSource;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.PMTilesLayer;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.PMTilesLoader;

public class PMTilesImageLayer
extends AbstractCachedTileSourceLayer<PMTilesImageSource>
implements PMTilesLayer {
    public PMTilesImageLayer(PMTilesImageryInfo info) {
        super((ImageryInfo)info);
        if (info.getName() != null) {
            this.setName(info.getName());
        } else {
            this.setName(info.header().location().getPath());
        }
    }

    protected Class<? extends TileLoader> getTileLoaderClass() {
        return PMTilesLoader.class;
    }

    protected void initTileSource(PMTilesImageSource tileSource) {
        super.initTileSource((AbstractTMSTileSource)tileSource);
        TileLoader tileLoader = this.tileLoader = this.getTileLoaderFactory().makeTileLoader((TileLoaderListener)this, this.getHeaders(tileSource), (long)this.info.getMinimumTileExpire());
        if (tileLoader instanceof PMTilesLoader) {
            PMTilesLoader pmTilesLoader = (PMTilesLoader)tileLoader;
            pmTilesLoader.setInfo((PMTilesImageryInfo)this.info);
        }
    }

    protected String getCacheName() {
        return "PMTILES_IMAGE";
    }

    public Collection<String> getNativeProjections() {
        return Collections.singleton("EPSG:3857");
    }

    protected PMTilesImageSource getTileSource() {
        return new PMTilesImageSource((PMTilesImageryInfo)this.info);
    }

    @Override
    public PMTilesImageryInfo getInfo() {
        return (PMTilesImageryInfo)super.getInfo();
    }

    @Override
    public String getChangesetSourceTag() {
        return PMTilesLayer.super.getChangesetSourceTag();
    }
}

