/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.gui.layers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import org.apache.commons.jcs3.access.behavior.ICacheAccess;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.data.imagery.TileJobOptions;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.JCSCachedTileLoaderJob;
import org.openstreetmap.josm.plugins.pmtiles.gui.layers.PMTilesTileSource;
import org.openstreetmap.josm.plugins.pmtiles.lib.DirectoryCache;
import org.openstreetmap.josm.plugins.pmtiles.lib.Header;
import org.openstreetmap.josm.plugins.pmtiles.lib.PMTiles;
import org.openstreetmap.josm.plugins.pmtiles.lib.TileType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

class PMTileJob
extends JCSCachedTileLoaderJob<String, CacheEntry>
implements TileJob,
ICachedLoaderListener {
    private final Tile tile;
    private final Header header;
    private final DirectoryCache directoryCache;

    PMTileJob(ICacheAccess<String, CacheEntry> cache, TileJobOptions options, ThreadPoolExecutor downloadJobExecutor, Header header, Tile tile, DirectoryCache directoryCache) {
        super(cache, options, downloadJobExecutor);
        Objects.requireNonNull(directoryCache);
        this.tile = tile;
        this.header = header;
        this.directoryCache = directoryCache;
    }

    public void submit() {
        this.submit(false);
    }

    public void submit(boolean force) {
        this.tile.initLoading();
        try {
            super.submit(this, force);
        }
        catch (IOException | IllegalArgumentException e) {
            Logging.log((Level)Logging.LEVEL_WARN, (Throwable)e);
            this.tile.finishLoading();
            this.tile.setError(e.getMessage());
        }
    }

    public String getCacheKey() {
        return this.header.location().toString() + "/" + PMTilesTileSource.getTileId(this.header, this.tile.getZoom(), this.tile.getXtile(), this.tile.getYtile());
    }

    public URL getUrl() throws IOException {
        return new URL(this.getCacheKey());
    }

    public void loadingFinished(CacheEntry data, CacheEntryAttributes attributes, ICachedLoaderListener.LoadResult result) {
        switch (result) {
            case FAILURE: {
                this.tile.setError(data == null ? I18n.tr((String)"Data could not be read", (Object[])new Object[0]) : new String(data.getContent(), StandardCharsets.UTF_8));
                break;
            }
            case CANCELED: {
                this.tile.setLoaded(false);
                break;
            }
            case SUCCESS: {
                this.tile.finishLoading();
                this.tryLoadData(data);
            }
        }
    }

    @Override
    protected CacheEntry createCacheEntry(byte[] content) {
        return switch (this.header.tileType()) {
            default -> throw new IncompatibleClassChangeError();
            case TileType.MVT, TileType.UNKNOWN -> new CacheEntry(content);
            case TileType.JPEG, TileType.PNG, TileType.AVIF, TileType.WEBP -> new BufferedImageCacheEntry(content);
        };
    }

    private void tryLoadData(CacheEntry data) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(data.getContent());){
            this.tile.loadImage((InputStream)is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getUrlNoException() {
        return this.getCacheKey();
    }

    @Override
    protected boolean loadObject() {
        if (this.attributes == null) {
            this.attributes = new CacheEntryAttributes();
        }
        try {
            Logging.debug((String)"JCS - starting HttpClient GET request for URL: {0}", (Object[])new Object[]{this.getUrlNoException()});
            byte[] data = PMTiles.readData(this.header, PMTiles.convertToHilbert(this.tile.getZoom(), this.tile.getXtile(), this.tile.getYtile()), this.directoryCache);
            this.cacheData = this.createCacheEntry(data);
            this.cache.put((Object)this.getCacheKey(), (Object)this.cacheData, (IElementAttributes)this.attributes);
            return true;
        }
        catch (IOException e) {
            this.attributes.setError((Exception)e);
            this.attributes.setException((Exception)e);
            Logging.warn((String)"JCS - Silent failure during download: {0}", (Object[])new Object[]{this.getUrlNoException()});
            return false;
        }
    }
}

