/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import com.puppycrawl.tools.checkstyle.utils.XpathUtil;
import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.AttributeNode;
import com.puppycrawl.tools.checkstyle.xpath.iterators.DescendantIterator;
import com.puppycrawl.tools.checkstyle.xpath.iterators.FollowingIterator;
import com.puppycrawl.tools.checkstyle.xpath.iterators.PrecedingIterator;
import com.puppycrawl.tools.checkstyle.xpath.iterators.ReverseListIterator;
import java.util.List;
import java.util.Optional;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.util.Navigator;

public class ElementNode
extends AbstractNode {
    private static final String TEXT_ATTRIBUTE_NAME = "text";
    private static final AbstractNode[] EMPTY_ABSTRACT_NODE_ARRAY = new AbstractNode[0];
    private static final AttributeNode ATTRIBUTE_NODE_UNINITIALIZED = new AttributeNode(null, null);
    private final AbstractNode root;
    private final AbstractNode parent;
    private final DetailAST detailAst;
    private final int depth;
    private final int indexAmongSiblings;
    private AttributeNode attributeNode = ATTRIBUTE_NODE_UNINITIALIZED;

    public ElementNode(AbstractNode root, AbstractNode parent, DetailAST detailAst, int depth, int indexAmongSiblings) {
        super(root.getTreeInfo());
        this.parent = parent;
        this.root = root;
        this.detailAst = detailAst;
        this.depth = depth;
        this.indexAmongSiblings = indexAmongSiblings;
    }

    @Override
    public int compareOrder(NodeInfo other) {
        int result = 0;
        if (other instanceof AbstractNode && (result = Integer.compare(this.depth, ((AbstractNode)other).getDepth())) == 0) {
            result = ElementNode.compareCommonAncestorChildrenOrder(this, other);
        }
        return result;
    }

    private static int compareCommonAncestorChildrenOrder(NodeInfo first, NodeInfo second) {
        NodeInfo child1 = first;
        NodeInfo child2 = second;
        while (!child1.getParent().equals(child2.getParent())) {
            child1 = child1.getParent();
            child2 = child2.getParent();
        }
        int index1 = ((ElementNode)child1).indexAmongSiblings;
        int index2 = ((ElementNode)child2).indexAmongSiblings;
        return Integer.compare(index1, index2);
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    protected List<AbstractNode> createChildren() {
        return XpathUtil.createChildren(this.root, this, this.detailAst.getFirstChild());
    }

    @Override
    public boolean hasChildNodes() {
        return this.detailAst.hasChildren();
    }

    @Override
    public String getAttributeValue(String namespace, String localPart) {
        String result = TEXT_ATTRIBUTE_NAME.equals(localPart) ? (String)Optional.ofNullable(this.getAttributeNode()).map(AttributeNode::getStringValue).orElse(null) : null;
        return result;
    }

    @Override
    public String getLocalPart() {
        return TokenUtil.getTokenName(this.detailAst.getType());
    }

    @Override
    public int getNodeKind() {
        return 1;
    }

    @Override
    public NodeInfo getParent() {
        return this.parent;
    }

    @Override
    public NodeInfo getRoot() {
        return this.root;
    }

    @Override
    public AxisIterator iterateAxis(int axisNumber) {
        AxisIterator result;
        switch (axisNumber) {
            case 0: {
                result = new Navigator.AncestorEnumeration(this, false);
                break;
            }
            case 1: {
                result = new Navigator.AncestorEnumeration(this, true);
                break;
            }
            case 2: {
                result = SingleNodeIterator.makeIterator(this.getAttributeNode());
                break;
            }
            case 3: {
                if (this.hasChildNodes()) {
                    result = new ArrayIterator.OfNodes(this.getChildren().toArray(EMPTY_ABSTRACT_NODE_ARRAY));
                    break;
                }
                result = EmptyIterator.ofNodes();
                break;
            }
            case 4: {
                if (this.hasChildNodes()) {
                    result = new DescendantIterator(this, DescendantIterator.StartWith.CHILDREN);
                    break;
                }
                result = EmptyIterator.ofNodes();
                break;
            }
            case 5: {
                result = new DescendantIterator(this, DescendantIterator.StartWith.CURRENT_NODE);
                break;
            }
            case 9: {
                result = SingleNodeIterator.makeIterator(this.parent);
                break;
            }
            case 12: {
                result = SingleNodeIterator.makeIterator(this);
                break;
            }
            case 7: {
                result = this.getFollowingSiblingsIterator();
                break;
            }
            case 11: {
                result = this.getPrecedingSiblingsIterator();
                break;
            }
            case 6: {
                result = new FollowingIterator(this);
                break;
            }
            case 10: {
                result = new PrecedingIterator(this);
                break;
            }
            default: {
                throw ElementNode.throwUnsupportedOperationException();
            }
        }
        return result;
    }

    @Override
    public int getLineNumber() {
        return this.detailAst.getLineNo();
    }

    @Override
    public int getColumnNumber() {
        return this.detailAst.getColumnNo();
    }

    @Override
    public int getTokenType() {
        return this.detailAst.getType();
    }

    @Override
    public DetailAST getUnderlyingNode() {
        return this.detailAst;
    }

    private AxisIterator getPrecedingSiblingsIterator() {
        AxisIterator result = this.indexAmongSiblings == 0 ? EmptyIterator.ofNodes() : new ReverseListIterator(this.getPrecedingSiblings());
        return result;
    }

    private AxisIterator getFollowingSiblingsIterator() {
        AxisIterator result = this.indexAmongSiblings == this.parent.getChildren().size() - 1 ? EmptyIterator.ofNodes() : new ArrayIterator.OfNodes(this.getFollowingSiblings().toArray(EMPTY_ABSTRACT_NODE_ARRAY));
        return result;
    }

    private List<AbstractNode> getFollowingSiblings() {
        List<AbstractNode> siblings = this.parent.getChildren();
        return siblings.subList(this.indexAmongSiblings + 1, siblings.size());
    }

    private List<AbstractNode> getPrecedingSiblings() {
        List<AbstractNode> siblings = this.parent.getChildren();
        return siblings.subList(0, this.indexAmongSiblings);
    }

    private AttributeNode getAttributeNode() {
        if (this.attributeNode == ATTRIBUTE_NODE_UNINITIALIZED) {
            this.attributeNode = XpathUtil.supportsTextAttribute(this.detailAst) ? new AttributeNode(TEXT_ATTRIBUTE_NAME, XpathUtil.getTextAttributeValue(this.detailAst)) : null;
        }
        return this.attributeNode;
    }

    private static UnsupportedOperationException throwUnsupportedOperationException() {
        return new UnsupportedOperationException("Operation is not supported");
    }
}

