/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.CheckstyleParserErrorStrategy;
import com.puppycrawl.tools.checkstyle.DetailAstImpl;
import com.puppycrawl.tools.checkstyle.JavaAstVisitor;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.grammar.java.JavaLanguageLexer;
import com.puppycrawl.tools.checkstyle.grammar.java.JavaLanguageParser;
import com.puppycrawl.tools.checkstyle.utils.ParserUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;

public final class JavaParser {
    private JavaParser() {
    }

    public static DetailAST parse(FileContents contents) throws CheckstyleException {
        JavaLanguageParser.CompilationUnitContext compilationUnit;
        String fullText = contents.getText().getFullText().toString();
        CodePointCharStream codePointCharStream = CharStreams.fromString(fullText);
        JavaLanguageLexer lexer = new JavaLanguageLexer(codePointCharStream, true);
        lexer.setCommentListener(contents);
        lexer.removeErrorListeners();
        CommonTokenStream tokenStream = new CommonTokenStream(lexer);
        JavaLanguageParser parser = new JavaLanguageParser(tokenStream, 500);
        parser.setErrorHandler(new CheckstyleParserErrorStrategy());
        parser.removeErrorListeners();
        parser.addErrorListener(new CheckstyleErrorListener());
        try {
            compilationUnit = parser.compilationUnit();
        }
        catch (IllegalStateException ex) {
            String exceptionMsg = String.format(Locale.ROOT, "%s occurred while parsing file %s.", ex.getClass().getSimpleName(), contents.getFileName());
            throw new CheckstyleException(exceptionMsg, ex);
        }
        return new JavaAstVisitor(tokenStream).visit(compilationUnit);
    }

    public static DetailAST parseFileText(FileText text, Options options) throws CheckstyleException {
        FileContents contents = new FileContents(text);
        DetailAST ast = JavaParser.parse(contents);
        if (options == Options.WITH_COMMENTS) {
            JavaParser.appendHiddenCommentNodes(ast);
        }
        return ast;
    }

    public static DetailAST parseFile(File file, Options options) throws IOException, CheckstyleException {
        FileText text = new FileText(file.getAbsoluteFile(), StandardCharsets.UTF_8.name());
        return JavaParser.parseFileText(text, options);
    }

    public static DetailAST appendHiddenCommentNodes(DetailAST root) {
        DetailAST newCommentNode;
        DetailAST currentSibling;
        DetailAST curNode = root;
        DetailAST lastNode = root;
        while (curNode != null) {
            lastNode = curNode;
            if (((DetailAstImpl)curNode).getHiddenBefore() != null) {
                currentSibling = curNode;
                List<Token> commentsList = ((DetailAstImpl)curNode).getHiddenBefore();
                ListIterator<Token> reverseCommentsIterator = commentsList.listIterator(commentsList.size());
                while (reverseCommentsIterator.hasPrevious()) {
                    newCommentNode = JavaParser.createCommentAstFromToken((CommonToken)reverseCommentsIterator.previous());
                    ((DetailAstImpl)currentSibling).addPreviousSibling(newCommentNode);
                    currentSibling = newCommentNode;
                }
            }
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                toVisit = curNode.getNextSibling();
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
        if (lastNode != null && ((DetailAstImpl)lastNode).getHiddenAfter() != null) {
            currentSibling = lastNode;
            for (Token token : ((DetailAstImpl)lastNode).getHiddenAfter()) {
                newCommentNode = JavaParser.createCommentAstFromToken((CommonToken)token);
                ((DetailAstImpl)currentSibling).addNextSibling(newCommentNode);
                currentSibling = newCommentNode;
            }
        }
        return root;
    }

    private static DetailAST createCommentAstFromToken(CommonToken token) {
        DetailAST commentAst = token.getType() == 144 ? JavaParser.createSlCommentNode(token) : ParserUtil.createBlockCommentNode(token);
        return commentAst;
    }

    private static DetailAST createSlCommentNode(CommonToken token) {
        DetailAstImpl slComment = new DetailAstImpl();
        slComment.setType(144);
        slComment.setText("//");
        slComment.setColumnNo(token.getCharPositionInLine());
        slComment.setLineNo(token.getLine());
        DetailAstImpl slCommentContent = new DetailAstImpl();
        slCommentContent.setType(183);
        slCommentContent.setColumnNo(token.getCharPositionInLine() + 2);
        slCommentContent.setLineNo(token.getLine());
        slCommentContent.setText(token.getText());
        slComment.addChild(slCommentContent);
        return slComment;
    }

    private static class CheckstyleErrorListener
    extends BaseErrorListener {
        private CheckstyleErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
            String message = line + ":" + charPositionInLine + ": " + msg;
            throw new IllegalStateException(message, ex);
        }
    }

    public static enum Options {
        WITH_COMMENTS,
        WITHOUT_COMMENTS;

    }
}

