/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityManagerHandler {
    private static final Logger LOGGER;
    private static final boolean SECURITY_MANAGER_DISABLED;

    public static void disableSecurityManager() {
        if (SECURITY_MANAGER_DISABLED) {
            return;
        }
        SecurityManagerHandler.doDisableSecurityManager();
    }

    private static void doDisableSecurityManager() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            System.setSecurityManager(null);
        }
    }

    static {
        boolean securityManagerDisabled;
        LOGGER = LoggerFactory.getLogger(SecurityManagerHandler.class);
        try {
            String property = System.getProperty("edu.umd.cs.findbugs.securityManagerDisabled");
            securityManagerDisabled = property != null ? Boolean.parseBoolean(property) : SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17);
        }
        catch (Throwable t) {
            securityManagerDisabled = false;
            LOGGER.debug("failed to detect the ability of security manager feature, so treat it as available", t);
        }
        SECURITY_MANAGER_DISABLED = securityManagerDisabled;
    }
}

