/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.graph;

import edu.umd.cs.findbugs.graph.AbstractEdge;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import edu.umd.cs.findbugs.graph.Graph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractGraph<EdgeType extends AbstractEdge<EdgeType, VertexType>, VertexType extends AbstractVertex<EdgeType, VertexType>>
implements Graph<EdgeType, VertexType> {
    private final ArrayList<VertexType> vertexList = new ArrayList();
    private final ArrayList<EdgeType> edgeList = new ArrayList();
    private int maxVertexLabel = 0;
    private int maxEdgeLabel = 0;

    @Override
    public int getNumEdges() {
        return this.edgeList.size();
    }

    @Override
    public int getNumVertices() {
        return this.vertexList.size();
    }

    @Override
    public Iterator<EdgeType> edgeIterator() {
        return this.edgeList.iterator();
    }

    @Override
    public Iterator<VertexType> vertexIterator() {
        return this.vertexList.iterator();
    }

    public Iterable<VertexType> vertices() {
        return this.vertexList;
    }

    @Override
    public void addVertex(VertexType v) {
        this.vertexList.add(v);
        ((AbstractVertex)v).setLabel(this.maxVertexLabel++);
    }

    @Override
    public boolean containsVertex(VertexType v) {
        for (AbstractVertex existingVertex : this.vertexList) {
            if (v != existingVertex) continue;
            return true;
        }
        return false;
    }

    @Override
    public EdgeType createEdge(VertexType source, VertexType target) {
        EdgeType edge = this.allocateEdge(source, target);
        this.edgeList.add(edge);
        ((AbstractVertex)source).addOutgoingEdge(edge);
        ((AbstractVertex)target).addIncomingEdge(edge);
        ((AbstractEdge)edge).setLabel(this.maxEdgeLabel++);
        return edge;
    }

    @Override
    public EdgeType lookupEdge(VertexType source, VertexType target) {
        Iterator<EdgeType> i = this.outgoingEdgeIterator(source);
        while (i.hasNext()) {
            AbstractEdge edge = (AbstractEdge)i.next();
            if (edge.getTarget() != target) continue;
            return (EdgeType)edge;
        }
        return null;
    }

    @Override
    public int getNumVertexLabels() {
        return this.maxVertexLabel;
    }

    @Override
    public void setNumVertexLabels(int numLabels) {
        this.maxVertexLabel = numLabels;
    }

    @Override
    public int getNumEdgeLabels() {
        return this.maxEdgeLabel;
    }

    @Override
    public void setNumEdgeLabels(int numLabels) {
        this.maxEdgeLabel = numLabels;
    }

    @Override
    public void removeEdge(EdgeType edge) {
        if (!this.edgeList.remove(edge)) {
            throw new IllegalArgumentException("removing nonexistent edge!");
        }
        ((AbstractVertex)((AbstractEdge)edge).getSource()).removeOutgoingEdge(edge);
        ((AbstractVertex)((AbstractEdge)edge).getTarget()).removeIncomingEdge(edge);
    }

    @Override
    public void removeVertex(VertexType v) {
        if (!this.vertexList.remove(v)) {
            throw new IllegalArgumentException("removing nonexistent vertex!");
        }
        Iterator<EdgeType> i = this.incomingEdgeIterator(v);
        while (i.hasNext()) {
            this.removeEdge((EdgeType)((AbstractEdge)i.next()));
        }
        i = this.outgoingEdgeIterator(v);
        while (i.hasNext()) {
            this.removeEdge((EdgeType)((AbstractEdge)i.next()));
        }
    }

    @Override
    public Iterator<EdgeType> outgoingEdgeIterator(VertexType source) {
        return new OutgoingEdgeIterator(source);
    }

    @Override
    public Iterator<EdgeType> incomingEdgeIterator(VertexType target) {
        return new IncomingEdgeIterator(target);
    }

    @Override
    public int getNumIncomingEdges(VertexType vertex) {
        int count = 0;
        for (Object e = ((AbstractVertex)vertex).firstIncomingEdge; e != null; e = ((AbstractEdge)e).getNextIncomingEdge()) {
            ++count;
        }
        return count;
    }

    @Override
    public int getNumOutgoingEdges(VertexType vertex) {
        int count = 0;
        for (Object e = ((AbstractVertex)vertex).firstOutgoingEdge; e != null; e = ((AbstractEdge)e).getNextOutgoingEdge()) {
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<VertexType> successorIterator(VertexType source) {
        return new Iterator<VertexType>(){
            private final Iterator<EdgeType> iter;
            final /* synthetic */ AbstractVertex val$source;
            {
                this.val$source = abstractVertex;
                this.iter = AbstractGraph.this.outgoingEdgeIterator(this.val$source);
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public VertexType next() {
                return ((AbstractEdge)this.iter.next()).getTarget();
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    @Override
    public Iterator<VertexType> predecessorIterator(VertexType target) {
        return new Iterator<VertexType>(){
            private final Iterator<EdgeType> iter;
            final /* synthetic */ AbstractVertex val$target;
            {
                this.val$target = abstractVertex;
                this.iter = AbstractGraph.this.incomingEdgeIterator(this.val$target);
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public VertexType next() {
                return ((AbstractEdge)this.iter.next()).getSource();
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    protected abstract EdgeType allocateEdge(VertexType var1, VertexType var2);

    private static class OutgoingEdgeIterator<EdgeType extends AbstractEdge<EdgeType, VertexType>, VertexType extends AbstractVertex<EdgeType, VertexType>>
    implements Iterator<EdgeType> {
        private EdgeType edge;

        public OutgoingEdgeIterator(VertexType source) {
            this.edge = ((AbstractVertex)source).getFirstOutgoingEdge();
        }

        @Override
        public boolean hasNext() {
            return this.edge != null;
        }

        @Override
        public EdgeType next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            EdgeType result = this.edge;
            this.edge = ((AbstractEdge)this.edge).getNextOutgoingEdge();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IncomingEdgeIterator<EdgeType extends AbstractEdge<EdgeType, VertexType>, VertexType extends AbstractVertex<EdgeType, VertexType>>
    implements Iterator<EdgeType> {
        private EdgeType edge;

        public IncomingEdgeIterator(VertexType target) {
            this.edge = ((AbstractVertex)target).getFirstIncomingEdge();
        }

        @Override
        public boolean hasNext() {
            return this.edge != null;
        }

        @Override
        public EdgeType next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            EdgeType result = this.edge;
            this.edge = ((AbstractEdge)this.edge).getNextIncomingEdge();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

