/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.NameMatch;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassMatcher
implements Matcher {
    private static final Logger LOG = LoggerFactory.getLogger(ClassMatcher.class);
    private final NameMatch className;
    private final String role;

    public String toString() {
        return "Class(class=\"" + this.className.getValue() + "\")";
    }

    public ClassMatcher(String className) {
        this(className, null);
    }

    public ClassMatcher(String className, String role) {
        this.className = new NameMatch(className);
        this.role = role;
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        ClassAnnotation classAnnotation = bugInstance.getPrimaryClass();
        if (this.role != null && !"".equals(this.role)) {
            for (BugAnnotation bugAnnotation : bugInstance.getAnnotations()) {
                if (!(bugAnnotation instanceof ClassAnnotation) || !this.role.equals(bugAnnotation.getDescription())) continue;
                classAnnotation = (ClassAnnotation)bugAnnotation;
                break;
            }
        }
        String bugClassName = classAnnotation.getClassName();
        boolean bl = this.className.match(bugClassName);
        LOG.debug("Matching {} with {}, result = {}", new Object[]{bugClassName, this.className, bl});
        return bl;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("name", this.className.getSpec());
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        attributes.addOptionalAttribute("role", this.role);
        xmlOutput.openCloseTag("Class", attributes);
    }
}

