/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Edge;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionHandle;

public class ViewCFG
implements Detector {
    private final Pattern SPACE_ARROW = Pattern.compile(" ->");
    private final Pattern NUMBER_SUFFIX = Pattern.compile(" (\\d+)$");
    private final Pattern SPECIAL_METHOD = Pattern.compile("<(\\w+)>");
    private final BugReporter bugReporter;
    private Path tempDir;

    public ViewCFG(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        try {
            this.tempDir = Files.createTempDirectory("cfg-", new FileAttribute[0]);
        }
        catch (IOException e) {
            bugReporter.logError("Could not create temporary directory", e);
        }
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Path classDir;
        if (this.tempDir == null) {
            return;
        }
        JavaClass cls = classContext.getJavaClass();
        String classDirName = !cls.getPackageName().isEmpty() ? cls.getPackageName() + "." + cls.getClassName() : cls.getClassName();
        try {
            classDir = Files.createDirectory(Paths.get(this.tempDir.toString(), classDirName), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.bugReporter.logError("Could not create directory for class " + cls.getClassName(), e);
            return;
        }
        for (Method method : cls.getMethods()) {
            try {
                this.analyzeMethod(classContext, method, classDir);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error analyzing method", e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method, Path classDir) throws CFGBuilderException {
        PrintStream out;
        Path methodFile = this.getMethodFile(classDir, method.getName());
        try {
            out = new PrintStream(Files.createFile(methodFile, new FileAttribute[0]).toFile(), Charset.defaultCharset().name());
        }
        catch (IOException e) {
            this.bugReporter.logError("Could not create file for method " + method.getName(), e);
            return;
        }
        CFG cfg = classContext.getCFG(method);
        out.println("digraph " + method.getName() + " {");
        Iterator<BasicBlock> bi = cfg.blockIterator();
        while (bi.hasNext()) {
            BasicBlock block = bi.next();
            if (block == cfg.getEntry()) {
                out.println("  Node" + block.getLabel() + " [shape=record label=\"{" + block.getLabel() + " (ENTRY) }\"];");
                continue;
            }
            if (block == cfg.getExit()) {
                out.println("  Node" + block.getLabel() + " [shape=record label=\"{" + block.getLabel() + " (EXIT) }\"];");
                continue;
            }
            out.print("  Node" + block.getLabel() + " [shape=record label=\"{" + block.getLabel());
            if (block.getFirstInstruction() != null) {
                out.print("|");
            }
            BasicBlock.InstructionIterator ii = block.instructionIterator();
            while (ii.hasNext()) {
                InstructionHandle ins = (InstructionHandle)ii.next();
                String insStr = this.NUMBER_SUFFIX.matcher(this.SPACE_ARROW.matcher(ins.toString(false)).replaceAll("")).replaceAll(" #$1");
                out.print(insStr + "\\l");
            }
            out.println("}\"];");
        }
        Iterator ei = cfg.edgeIterator();
        block17: while (ei.hasNext()) {
            Edge edge = (Edge)ei.next();
            BasicBlock src = (BasicBlock)edge.getSource();
            BasicBlock tgt = (BasicBlock)edge.getTarget();
            switch (edge.getType()) {
                default: {
                    out.println("  Node" + src.getLabel() + " -> Node" + tgt.getLabel() + ";");
                    continue block17;
                }
                case 1: {
                    out.println("  Node" + src.getLabel() + " -> Node" + tgt.getLabel() + " [shape=plaintext label=\" True branch\"];");
                    continue block17;
                }
                case 9: {
                    out.println("  Node" + src.getLabel() + " -> Node" + tgt.getLabel() + " [shape=plaintext label=\" Handled exception for #" + ((BasicBlock)edge.getSource()).getExceptionThrower().getPosition() + "\"];");
                    continue block17;
                }
                case 8: {
                    out.println("  Node" + src.getLabel() + " -> Node" + tgt.getLabel() + " [shape=plaintext label=\" Unhandled exception for #" + ((BasicBlock)edge.getSource()).getExceptionThrower().getPosition() + "\"];");
                    continue block17;
                }
                case 7: {
                    out.println("  Node" + src.getLabel() + " -> Node" + tgt.getLabel() + " [shape=plaintext label=\" Return\"];");
                    continue block17;
                }
                case 10: {
                    out.println("  Node" + src.getLabel() + " -> Node" + tgt.getLabel() + " [shape=plaintext label=\" Start\"];");
                    continue block17;
                }
                case 13: {
                    out.println("  Node" + src.getLabel() + " -> Exit" + tgt.getLabel() + " [shape=plaintext label=\" Exit\"];");
                    continue block17;
                }
                case 2: {
                    out.println("  Node" + src.getLabel() + " -> Node" + tgt.getLabel() + " [shape=plaintext label=\" Switch case (non-default)\"];");
                    continue block17;
                }
                case 3: {
                    out.println("  Node" + src.getLabel() + " -> Node" + tgt.getLabel() + " [shape=plaintext label=\" Switch case (default)\"];");
                    continue block17;
                }
                case 4: {
                    out.println("  Node" + src.getLabel() + " -> Node" + tgt.getLabel() + " [shape=plaintext label=\" JSR statement\"];");
                    continue block17;
                }
                case 5: {
                    out.println("  Node" + src.getLabel() + " -> Node" + tgt.getLabel() + " [shape=plaintext label=\" RET statement\"];");
                    continue block17;
                }
                case 6: 
            }
            out.println("  Node" + src.getLabel() + " -> Node" + tgt.getLabel() + " [shape=plaintext label=\" GOTO statement\"];");
        }
        out.println("}");
        out.close();
        if (out.checkError()) {
            this.bugReporter.logError("Error writing to file " + methodFile.toString());
        }
    }

    private Path getMethodFile(Path classDir, String methodName) {
        Path methodFile;
        String methodFileNameBase = this.SPECIAL_METHOD.matcher(methodName).replaceAll("____$1");
        int index = 0;
        String methodFileName = methodFileNameBase;
        do {
            methodFile = Paths.get(classDir.toString(), methodFileName + ".dot");
            methodFileName = methodFileNameBase + ++index;
        } while (Files.exists(methodFile, new LinkOption[0]));
        return methodFile;
    }

    @Override
    public void report() {
        if (this.tempDir != null) {
            System.out.println("CFGs generated into directory: " + this.tempDir + ". Please do not forget to delete it.");
        }
    }
}

