/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.StringAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.UseAnnotationDatabase;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.NullDerefAndRedundantComparisonCollector;
import edu.umd.cs.findbugs.ba.npe.NullDerefAndRedundantComparisonFinder;
import edu.umd.cs.findbugs.ba.npe.NullValueUnconditionalDeref;
import edu.umd.cs.findbugs.ba.npe.PointerUsageRequiringNonNullValue;
import edu.umd.cs.findbugs.ba.npe.RedundantBranch;
import edu.umd.cs.findbugs.ba.npe.ReturnPathType;
import edu.umd.cs.findbugs.ba.npe.ReturnPathTypeDataflow;
import edu.umd.cs.findbugs.ba.npe.UsagesRequiringNonNullValues;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberSourceInfo;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.detect.DoomedCodeWarningProperty;
import edu.umd.cs.findbugs.detect.NullDerefProperty;
import edu.umd.cs.findbugs.props.GeneralWarningProperty;
import edu.umd.cs.findbugs.props.WarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.props.WarningPropertyUtil;
import edu.umd.cs.findbugs.visitclass.Util;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReturnInstruction;

public class NoiseNullDeref
implements Detector,
UseAnnotationDatabase,
NullDerefAndRedundantComparisonCollector {
    public static final boolean DEBUG = SystemProperties.getBoolean("fnd.debug");
    private static final boolean DEBUG_NULLARG = SystemProperties.getBoolean("fnd.debug.nullarg");
    private static final boolean MARK_DOOMED = SystemProperties.getBoolean("fnd.markdoomed", true);
    private static final String METHOD_NAME = SystemProperties.getProperty("fnd.method");
    private static final String CLASS = SystemProperties.getProperty("fnd.class");
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    private ClassContext classContext;
    private Method method;
    private ValueNumberDataflow vnaDataflow;

    public NoiseNullDeref(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        this.classContext = classContext;
        String currentMethod = null;
        JavaClass jclass = classContext.getJavaClass();
        String className = jclass.getClassName();
        String superClassName = jclass.getSuperclassName();
        if (superClassName.endsWith("ProtocolMessage")) {
            return;
        }
        if (CLASS != null && !className.equals(CLASS)) {
            return;
        }
        for (Method method : methodList = jclass.getMethods()) {
            try {
                if (method.isAbstract() || method.isNative() || method.getCode() == null) continue;
                currentMethod = SignatureConverter.convertMethodSignature(jclass, method);
                if (METHOD_NAME != null && !method.getName().equals(METHOD_NAME)) continue;
                if (DEBUG || DEBUG_NULLARG) {
                    System.out.println("Checking for NP in " + currentMethod);
                }
                this.analyzeMethod(classContext, method);
            }
            catch (MissingClassException e) {
                this.bugReporter.reportMissingClass(e.getClassNotFoundException());
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("While analyzing " + currentMethod + ": FindNullDeref caught dae exception", e);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("While analyzing " + currentMethod + ": FindNullDeref caught cfgb exception", e);
            }
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws DataflowAnalysisException, CFGBuilderException {
        MethodGen methodGen;
        if (DEBUG || DEBUG_NULLARG) {
            System.out.println("Pre FND ");
        }
        if ((methodGen = classContext.getMethodGen(method)) == null) {
            return;
        }
        this.method = method;
        if (DEBUG || DEBUG_NULLARG) {
            System.out.println("FND: " + SignatureConverter.convertMethodSignature(methodGen));
        }
        this.findPreviouslyDeadBlocks();
        this.vnaDataflow = classContext.getValueNumberDataflow(method);
        NullDerefAndRedundantComparisonFinder worker = new NullDerefAndRedundantComparisonFinder(classContext, method, this);
        worker.execute();
    }

    private BitSet findPreviouslyDeadBlocks() throws DataflowAnalysisException, CFGBuilderException {
        BitSet deadBlocks = new BitSet();
        ValueNumberDataflow vnaDataflow = this.classContext.getValueNumberDataflow(this.method);
        Iterator<BasicBlock> i = vnaDataflow.getCFG().blockIterator();
        while (i.hasNext()) {
            BasicBlock block = i.next();
            ValueNumberFrame vnaFrame = (ValueNumberFrame)vnaDataflow.getStartFact(block);
            if (!vnaFrame.isTop()) continue;
            deadBlocks.set(block.getLabel());
        }
        return deadBlocks;
    }

    @Override
    public void report() {
    }

    public boolean skipIfInsideCatchNull() {
        return this.classContext.getJavaClass().getClassName().indexOf("Test") >= 0 || this.method.getName().indexOf("test") >= 0 || this.method.getName().indexOf("Test") >= 0;
    }

    @Override
    @Deprecated
    public void foundNullDeref(Location location, ValueNumber valueNumber, IsNullValue refValue, ValueNumberFrame vnaFrame) {
        this.foundNullDeref(location, valueNumber, refValue, vnaFrame, true);
    }

    @Override
    public void foundNullDeref(Location location, ValueNumber valueNumber, IsNullValue refValue, ValueNumberFrame vnaFrame, boolean isConsistent) {
        BugAnnotation cause;
        if (!refValue.isNullOnComplicatedPath23()) {
            return;
        }
        WarningPropertySet<WarningProperty> propertySet = new WarningPropertySet<WarningProperty>();
        if (valueNumber.hasFlag(4)) {
            return;
        }
        boolean onExceptionPath = refValue.isException();
        if (onExceptionPath) {
            propertySet.addProperty(GeneralWarningProperty.ON_EXCEPTION_PATH);
        }
        BugAnnotation variable = ValueNumberSourceInfo.findAnnotationFromValueNumber(this.method, location, valueNumber, vnaFrame, "VALUE_OF");
        this.addPropertiesForDereferenceLocations(propertySet, Collections.singleton(location));
        Instruction ins = location.getHandle().getInstruction();
        ConstantPoolGen cpg = this.classContext.getConstantPoolGen();
        if (ins instanceof InvokeInstruction) {
            if (ins instanceof INVOKEDYNAMIC) {
                return;
            }
            InvokeInstruction iins = (InvokeInstruction)ins;
            XMethod invokedMethod = XFactory.createXMethod((InvokeInstruction)ins, cpg);
            cause = MethodAnnotation.fromXMethod(invokedMethod);
            cause.setDescription("METHOD_CALLED");
            if ("close".equals(iins.getMethodName(cpg)) && "()V".equals(iins.getSignature(cpg))) {
                propertySet.addProperty(NullDerefProperty.CLOSING_NULL);
            }
        } else if (ins instanceof FieldInstruction) {
            FieldInstruction fins = (FieldInstruction)ins;
            XField referencedField = XFactory.createXField(fins, cpg);
            cause = FieldAnnotation.fromXField(referencedField);
        } else {
            cause = new StringAnnotation(ins.getName());
        }
        boolean caught = this.inCatchNullBlock(location);
        if (caught && this.skipIfInsideCatchNull()) {
            return;
        }
        int basePriority = 2;
        if (!refValue.isNullOnComplicatedPath2()) {
            --basePriority;
        }
        this.reportNullDeref(propertySet, location, "NOISE_NULL_DEREFERENCE", basePriority, cause, variable);
    }

    private void reportNullDeref(WarningPropertySet<WarningProperty> propertySet, Location location, String type, int priority, BugAnnotation cause, @CheckForNull BugAnnotation variable) {
        BugInstance bugInstance = new BugInstance(this, type, priority).addClassAndMethod(this.classContext.getJavaClass(), this.method);
        bugInstance.add(cause);
        if (variable != null) {
            bugInstance.add(variable);
        } else {
            bugInstance.add(new LocalVariableAnnotation("?", -1, -1));
        }
        bugInstance.addSourceLine(this.classContext, this.method, location).describe("SOURCE_LINE_DEREF");
        if (FindBugsAnalysisFeatures.isRelaxedMode()) {
            WarningPropertyUtil.addPropertiesForDataMining(propertySet, this.classContext, this.method, location);
        }
        this.addPropertiesForDereferenceLocations(propertySet, Collections.singleton(location));
        propertySet.decorateBugInstance(bugInstance);
        this.bugReporter.reportBug(bugInstance);
    }

    public static boolean isThrower(BasicBlock target) {
        int maxCount = 7;
        for (InstructionHandle ins = target.getFirstInstruction(); ins != null && maxCount-- > 0; ins = ins.getNext()) {
            Instruction i = ins.getInstruction();
            if (i instanceof ATHROW) {
                return true;
            }
            if (!(i instanceof InstructionTargeter) && !(i instanceof ReturnInstruction)) continue;
            return false;
        }
        return false;
    }

    @Override
    public void foundRedundantNullCheck(Location location, RedundantBranch redundantBranch) {
    }

    @Override
    public void foundGuaranteedNullDeref(@Nonnull Set<Location> assignedNullLocationSet, @Nonnull Set<Location> derefLocationSet, SortedSet<Location> doomedLocations, ValueNumberDataflow vna, ValueNumber refValue, @CheckForNull BugAnnotation variableAnnotation, NullValueUnconditionalDeref deref, boolean npeIfStatementCovered) {
    }

    private void addPropertiesForDereferenceLocations(WarningPropertySet<WarningProperty> propertySet, Collection<Location> derefLocationSet) {
        boolean derefOutsideCatchBlock = false;
        boolean allDerefsAtDoomedLocations = true;
        for (Location loc : derefLocationSet) {
            if (!this.inCatchNullBlock(loc)) {
                derefOutsideCatchBlock = true;
            }
            if (this.isDoomed(loc)) continue;
            allDerefsAtDoomedLocations = false;
        }
        if (allDerefsAtDoomedLocations) {
            propertySet.addProperty(DoomedCodeWarningProperty.DOOMED_CODE);
        }
        boolean uniqueDereferenceLocations = this.uniqueLocations(derefLocationSet);
        if (!derefOutsideCatchBlock) {
            if (!uniqueDereferenceLocations || this.skipIfInsideCatchNull()) {
                propertySet.addProperty(GeneralWarningProperty.FALSE_POSITIVE);
            } else {
                propertySet.addProperty(NullDerefProperty.DEREFS_IN_CATCH_BLOCKS);
            }
        }
        if (!uniqueDereferenceLocations) {
            propertySet.addProperty(NullDerefProperty.DEREFS_ARE_CLONED);
        }
        this.addPropertiesForMethodContainingWarning(propertySet);
    }

    private boolean uniqueLocations(Collection<Location> derefLocationSet) {
        boolean uniqueDereferenceLocations = false;
        LineNumberTable table = this.method.getLineNumberTable();
        if (table == null) {
            uniqueDereferenceLocations = true;
        } else {
            BitSet linesMentionedMultipleTimes = this.classContext.linesMentionedMultipleTimes(this.method);
            for (Location loc : derefLocationSet) {
                int lineNumber = table.getSourceLine(loc.getHandle().getPosition());
                if (linesMentionedMultipleTimes.get(lineNumber)) continue;
                uniqueDereferenceLocations = true;
            }
        }
        return uniqueDereferenceLocations;
    }

    private void addPropertiesForMethodContainingWarning(WarningPropertySet<WarningProperty> propertySet) {
        boolean uncallable;
        XMethod xMethod = XFactory.createXMethod(this.classContext.getJavaClass(), this.method);
        boolean bl = uncallable = !AnalysisContext.currentXFactory().isCalledDirectlyOrIndirectly(xMethod) && xMethod.isPrivate();
        if (uncallable) {
            propertySet.addProperty(GeneralWarningProperty.IN_UNCALLABLE_METHOD);
        }
    }

    private boolean isDoomed(Location loc) {
        if (!MARK_DOOMED) {
            return false;
        }
        try {
            ReturnPathTypeDataflow rptDataflow = this.classContext.getReturnPathTypeDataflow(this.method);
            ReturnPathType rpt = (ReturnPathType)rptDataflow.getFactAtLocation(loc);
            return !rpt.canReturnNormally();
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error getting return path type", e);
            return false;
        }
    }

    String getDescription(Location loc, ValueNumber refValue) {
        try {
            UsagesRequiringNonNullValues usages = this.classContext.getUsagesRequiringNonNullValues(this.method);
            PointerUsageRequiringNonNullValue pu = usages.get(loc, refValue, this.vnaDataflow);
            if (pu == null) {
                return "SOURCE_LINE_DEREF";
            }
            return pu.getDescription();
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("Error getting UsagesRequiringNonNullValues for " + this.method, e);
            return "SOURCE_LINE_DEREF";
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError("Error getting UsagesRequiringNonNullValues for " + this.method, e);
            return "SOURCE_LINE_DEREF";
        }
    }

    boolean inCatchNullBlock(Location loc) {
        int pc = loc.getHandle().getPosition();
        int catchSize = Util.getSizeOfSurroundingTryBlock(this.classContext.getJavaClass().getConstantPool(), this.method.getCode(), "java/lang/NullPointerException", pc);
        if (catchSize < Integer.MAX_VALUE) {
            return true;
        }
        catchSize = Util.getSizeOfSurroundingTryBlock(this.classContext.getJavaClass().getConstantPool(), this.method.getCode(), "java/lang/Exception", pc);
        if (catchSize < 5) {
            return true;
        }
        catchSize = Util.getSizeOfSurroundingTryBlock(this.classContext.getJavaClass().getConstantPool(), this.method.getCode(), "java/lang/RuntimeException", pc);
        if (catchSize < 5) {
            return true;
        }
        catchSize = Util.getSizeOfSurroundingTryBlock(this.classContext.getJavaClass().getConstantPool(), this.method.getCode(), "java/lang/Throwable", pc);
        return catchSize < 5;
    }

    static class CheckCallSitesAndReturnInstructions {
        CheckCallSitesAndReturnInstructions() {
        }
    }
}

