/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberSourceInfo;
import edu.umd.cs.findbugs.visitclass.Util;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class LoadOfKnownNullValue
implements Detector {
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;

    public LoadOfKnownNullValue(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        for (Method method : methodList = classContext.getJavaClass().getMethods()) {
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (MethodUnprofitableException mue) {
                if (SystemProperties.getBoolean("unprofitable.debug")) {
                    this.bugReporter.logError("skipping unprofitable method in " + this.getClass().getName());
                }
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", e);
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", e);
            }
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        ALOAD load;
        int index;
        IsNullValue v;
        IsNullValueFrame frame;
        Instruction ins;
        InstructionHandle handle;
        Location location;
        Iterator<Location> i;
        BitSet lineMentionedMultipleTimes = classContext.linesMentionedMultipleTimes(method);
        BitSet linesWithLoadsOfNotDefinitelyNullValues = null;
        CFG cfg = classContext.getCFG(method);
        IsNullValueDataflow nullValueDataflow = classContext.getIsNullValueDataflow(method);
        MethodGen methodGen = classContext.getMethodGen(method);
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        if (lineMentionedMultipleTimes.cardinality() > 0) {
            linesWithLoadsOfNotDefinitelyNullValues = new BitSet();
            LineNumberTable lineNumbers = method.getLineNumberTable();
            i = cfg.locationIterator();
            while (i.hasNext()) {
                int sourceLine;
                location = i.next();
                handle = location.getHandle();
                ins = handle.getInstruction();
                if (!(ins instanceof ALOAD) || !(frame = (IsNullValueFrame)nullValueDataflow.getFactAtLocation(location)).isValid() || (v = (IsNullValue)frame.getValue(index = (load = (ALOAD)ins).getIndex())).isDefinitelyNull() || (sourceLine = lineNumbers.getSourceLine(handle.getPosition())) <= 0) continue;
                linesWithLoadsOfNotDefinitelyNullValues.set(sourceLine);
            }
        }
        IdentityHashMap sometimesGood = new IdentityHashMap();
        i = cfg.locationIterator();
        while (i.hasNext()) {
            location = i.next();
            handle = location.getHandle();
            ins = handle.getInstruction();
            if (!(ins instanceof ALOAD) || !(frame = (IsNullValueFrame)nullValueDataflow.getFactAtLocation(location)).isValid() || (v = (IsNullValue)frame.getValue(index = (load = (ALOAD)ins).getIndex())).isDefinitelyNull()) continue;
            sometimesGood.put(handle, null);
        }
        i = cfg.locationIterator();
        while (i.hasNext()) {
            int previousLine;
            int startLine;
            InstructionHandle targ;
            location = i.next();
            handle = location.getHandle();
            ins = handle.getInstruction();
            if (!(ins instanceof ALOAD) || sometimesGood.containsKey(handle) || !(frame = (IsNullValueFrame)nullValueDataflow.getFactAtLocation(location)).isValid() || !(v = (IsNullValue)frame.getValue(index = (load = (ALOAD)ins).getIndex())).isDefinitelyNull()) continue;
            InstructionHandle nextHandle = handle.getNext();
            Instruction next = nextHandle.getInstruction();
            int position = location.getHandle().getPosition();
            int catchSizeANY = Util.getSizeOfSurroundingTryBlock(method, "", position);
            if (catchSizeANY < Integer.MAX_VALUE && this.isNullTestedClose(classContext, load, nextHandle, next)) continue;
            InstructionHandle prevHandle = handle.getPrev();
            SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, handle);
            SourceLineAnnotation prevSourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, prevHandle);
            if (next instanceof ARETURN || next instanceof GOTO && (targ = ((BranchInstruction)next).getTarget()).getInstruction() instanceof ARETURN || (startLine = sourceLineAnnotation.getStartLine()) > 0 && lineMentionedMultipleTimes.get(startLine) && linesWithLoadsOfNotDefinitelyNullValues.get(startLine) || startLine < (previousLine = prevSourceLineAnnotation.getEndLine())) continue;
            int priority = 2;
            if (!v.isChecked()) {
                ++priority;
            }
            BugAnnotation variableAnnotation = null;
            try {
                ValueNumberFrame vnaFrame = (ValueNumberFrame)classContext.getValueNumberDataflow(method).getFactAfterLocation(location);
                if (vnaFrame.isValid()) {
                    LocalVariableAnnotation local;
                    ValueNumber valueNumber = (ValueNumber)vnaFrame.getTopValue();
                    if (valueNumber.hasFlag(4)) {
                        return;
                    }
                    variableAnnotation = ValueNumberSourceInfo.findAnnotationFromValueNumber(method, location, valueNumber, vnaFrame, "VALUE_OF");
                    if (variableAnnotation instanceof LocalVariableAnnotation && !(local = (LocalVariableAnnotation)variableAnnotation).isNamed()) {
                        ++priority;
                    }
                }
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
            }
            catch (CFGBuilderException cFGBuilderException) {
                // empty catch block
            }
            this.bugAccumulator.accumulateBug(new BugInstance(this, "NP_LOAD_OF_KNOWN_NULL_VALUE", priority).addClassAndMethod(methodGen, sourceFile).addOptionalAnnotation(variableAnnotation), sourceLineAnnotation);
        }
    }

    private boolean isNullTestedClose(ClassContext classContext, ALOAD load, InstructionHandle nextHandle, Instruction next) {
        if (!(next instanceof IFNULL)) {
            return false;
        }
        IFNULL ifNull = (IFNULL)next;
        InstructionHandle nextNextHandle = nextHandle.getNext();
        if (nextNextHandle == null) {
            return false;
        }
        Instruction nextInstruction = nextNextHandle.getInstruction();
        if (!(nextInstruction instanceof ALOAD)) {
            return false;
        }
        ALOAD nextLoad = (ALOAD)nextInstruction;
        if (load.getIndex() != nextLoad.getIndex()) {
            return false;
        }
        InstructionHandle nextNextNextHandle = nextNextHandle.getNext();
        if (nextNextNextHandle == null) {
            return false;
        }
        Instruction nextNextNextInstruction = nextNextNextHandle.getInstruction();
        if (!(nextNextNextInstruction instanceof INVOKEVIRTUAL)) {
            return false;
        }
        INVOKEVIRTUAL invokeVirtual = (INVOKEVIRTUAL)nextNextNextInstruction;
        String methodName = invokeVirtual.getMethodName(classContext.getConstantPoolGen());
        String methodSig = invokeVirtual.getSignature(classContext.getConstantPoolGen());
        if (!"close".equals(methodName) || !"()V".equals(methodSig)) {
            return false;
        }
        InstructionHandle nextNextNextNextHandle = nextNextNextHandle.getNext();
        return ifNull.getTarget() == nextNextNextNextHandle;
    }

    @Override
    public void report() {
    }
}

