/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DontUseFloatsAsLoopCounters
extends OpcodeStackDetector
implements StatelessDetector {
    private final BugReporter bugReporter;
    private static final Map<Integer, Integer> FLOAT_LOADERS;
    private static final Map<Integer, Integer> FLOAT_CONSTANT_PUSHERS;
    private static final Set<Integer> FLOAT_COMPARERS;
    private static final Set<Integer> FLOAT_STORERS;
    private static final Set<Integer> FLOAT_ADDITIVE_OPS;

    public DontUseFloatsAsLoopCounters(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void sawOpcode(int seen) {
        if ((seen == 167 || seen == 200) && this.getBranchTarget() < this.getPC() && this.checkLoopEnd() && this.checkLoopStart(this.getBranchTarget())) {
            this.bugReporter.reportBug(new BugInstance(this, "FL_FLOATS_AS_LOOP_COUNTERS", 2).addClassAndMethod(this).addSourceLine(this, this.getBranchTarget()));
        }
    }

    private boolean checkLoopEnd() {
        return FLOAT_STORERS.contains(this.getPrevOpcode(1)) && FLOAT_ADDITIVE_OPS.contains(this.getPrevOpcode(2));
    }

    private boolean checkLoopStart(int startPC) {
        if (!FLOAT_LOADERS.containsKey(this.getCodeByte(startPC))) {
            return false;
        }
        int nextPC = startPC + FLOAT_LOADERS.get(this.getCodeByte(startPC));
        if (!FLOAT_CONSTANT_PUSHERS.containsKey(this.getCodeByte(nextPC))) {
            return false;
        }
        nextPC += FLOAT_CONSTANT_PUSHERS.get(this.getCodeByte(nextPC)).intValue();
        if (!FLOAT_COMPARERS.contains(this.getCodeByte(nextPC++))) {
            return false;
        }
        return DontUseFloatsAsLoopCounters.isBranch(this.getCodeByte(nextPC));
    }

    static {
        HashMap<Integer, Integer> tmp = new HashMap<Integer, Integer>();
        tmp.put(23, 2);
        tmp.put(34, 1);
        tmp.put(35, 1);
        tmp.put(36, 1);
        tmp.put(37, 1);
        tmp.put(24, 2);
        tmp.put(38, 1);
        tmp.put(39, 1);
        tmp.put(40, 1);
        tmp.put(41, 1);
        FLOAT_LOADERS = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put(12, 1);
        tmp.put(13, 1);
        tmp.put(15, 1);
        tmp.put(18, 2);
        tmp.put(19, 3);
        tmp.put(20, 3);
        FLOAT_CONSTANT_PUSHERS = Collections.unmodifiableMap(tmp);
        FLOAT_COMPARERS = new HashSet<Integer>(Arrays.asList(150, 149, 152, 151));
        FLOAT_STORERS = new HashSet<Integer>(Arrays.asList(56, 67, 68, 69, 70, 57, 71, 72, 73, 74));
        FLOAT_ADDITIVE_OPS = new HashSet<Integer>(Arrays.asList(98, 102, 99, 103));
    }
}

