/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.Frame;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.vna.AvailableLoad;
import edu.umd.cs.findbugs.ba.vna.MergeTree;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysisFeatures;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFactory;
import edu.umd.cs.findbugs.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ValueNumberFrame
extends Frame<ValueNumber>
implements ValueNumberAnalysisFeatures {
    private ArrayList<ValueNumber> mergedValueList;
    private AvailableLoadBiMap availableLoadMap;
    private Map<AvailableLoad, ValueNumber> mergedLoads;
    private Map<ValueNumber, AvailableLoad> previouslyKnownAs;
    public boolean phiNodeForLoads;
    private static final boolean USE_WRITTEN_OUTSIDE_OF_CONSTRUCTOR = true;
    static int constructedUnmodifiableMap;
    static int reusedMap;
    static int createdEmptyMap;
    static int madeImmutableMutable;
    static int reusedMutableMap;

    public ValueNumberFrame(int numLocals) {
        super(numLocals);
        if (REDUNDANT_LOAD_ELIMINATION) {
            this.setAvailableLoadMap(AvailableLoadBiMap.emptyMap());
            this.setMergedLoads(Collections.emptyMap());
            this.setPreviouslyKnownAs(Collections.emptyMap());
        }
    }

    public String availableLoadMapAsString() {
        StringBuilder buf = new StringBuilder("{ ");
        for (Map.Entry<AvailableLoad, ValueNumber[]> e : this.getAvailableLoadMap().entrySet()) {
            buf.append(e.getKey());
            buf.append("=");
            for (ValueNumber v : e.getValue()) {
                buf.append(v).append(",");
            }
            buf.append(";  ");
        }
        buf.append(" }");
        return buf.toString();
    }

    @CheckForNull
    public AvailableLoad getLoad(ValueNumber v) {
        if (!REDUNDANT_LOAD_ELIMINATION) {
            return null;
        }
        return this.getAvailableLoadMap().getLoad(v);
    }

    public ValueNumber[] getAvailableLoad(AvailableLoad availableLoad) {
        return this.getAvailableLoadMap().get(availableLoad);
    }

    public void addAvailableLoad(AvailableLoad availableLoad, @Nonnull ValueNumber[] value) {
        Objects.requireNonNull(value);
        this.getUpdateableAvailableLoadMap().put(availableLoad, value);
        for (ValueNumber v : value) {
            this.getUpdateablePreviouslyKnownAs().put(v, availableLoad);
            if (!RLE_DEBUG) continue;
            System.out.println("Adding available load of " + availableLoad + " for " + v + " to " + System.identityHashCode(this));
        }
    }

    private static void removeAllKeys(AvailableLoadBiMap map, Iterable<AvailableLoad> removeMe) {
        for (AvailableLoad k : removeMe) {
            map.remove(k);
        }
    }

    public void killLoadsOfField(XField field) {
        if (!REDUNDANT_LOAD_ELIMINATION) {
            return;
        }
        HashSet<AvailableLoad> killMe = new HashSet<AvailableLoad>();
        for (AvailableLoad availableLoad : this.getAvailableLoadMap().keySet()) {
            if (!availableLoad.getField().equals(field)) continue;
            if (RLE_DEBUG) {
                System.out.println("KILLING Load of " + availableLoad + " in " + this);
            }
            killMe.add(availableLoad);
        }
        this.killAvailableLoads(killMe);
    }

    public void killAllLoads() {
        this.killAllLoads(false);
    }

    public void killAllLoads(boolean primitiveOnly) {
        if (!REDUNDANT_LOAD_ELIMINATION) {
            return;
        }
        FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
        HashSet<AvailableLoad> killMe = new HashSet<AvailableLoad>();
        for (AvailableLoad availableLoad : this.getAvailableLoadMap().keySet()) {
            XField field = availableLoad.getField();
            if (primitiveOnly && field.isReferenceType() || !field.isVolatile() && (field.isFinal() || !fieldSummary.isWrittenOutsideOfConstructor(field))) continue;
            if (RLE_DEBUG) {
                System.out.println("KILLING load of " + availableLoad + " in " + this);
            }
            killMe.add(availableLoad);
        }
        this.killAvailableLoads(killMe);
    }

    public void killAllLoadsExceptFor(@CheckForNull ValueNumber v) {
        if (!REDUNDANT_LOAD_ELIMINATION) {
            return;
        }
        AvailableLoad myLoad = this.getLoad(v);
        HashSet<AvailableLoad> killMe = new HashSet<AvailableLoad>();
        for (AvailableLoad availableLoad : this.getAvailableLoadMap().keySet()) {
            if (availableLoad.getField().isFinal() || availableLoad.equals(myLoad)) continue;
            if (RLE_DEBUG) {
                System.out.println("KILLING load of " + availableLoad + " in " + this);
            }
            killMe.add(availableLoad);
        }
        this.killAvailableLoads(killMe);
    }

    public void killAllLoadsOf(@CheckForNull ValueNumber v) {
        if (!REDUNDANT_LOAD_ELIMINATION) {
            return;
        }
        FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
        HashSet<AvailableLoad> killMe = new HashSet<AvailableLoad>();
        for (AvailableLoad availableLoad : this.getAvailableLoadMap().keySet()) {
            XField field;
            if (availableLoad.getReference() != v || (field = availableLoad.getField()).isFinal() || !fieldSummary.isWrittenOutsideOfConstructor(field)) continue;
            if (RLE_DEBUG) {
                System.out.println("Killing load of " + availableLoad + " in " + this);
            }
            killMe.add(availableLoad);
        }
        this.killAvailableLoads(killMe);
    }

    public void killLoadsOf(Set<XField> fieldsToKill) {
        if (!REDUNDANT_LOAD_ELIMINATION) {
            return;
        }
        HashSet<AvailableLoad> killMe = new HashSet<AvailableLoad>();
        for (AvailableLoad availableLoad : this.getAvailableLoadMap().keySet()) {
            if (!fieldsToKill.contains(availableLoad.getField())) continue;
            killMe.add(availableLoad);
        }
        this.killAvailableLoads(killMe);
    }

    public void killLoadsWithSimilarName(String className, String methodName) {
        if (!REDUNDANT_LOAD_ELIMINATION) {
            return;
        }
        String packageName = this.extractPackageName(className);
        HashSet<AvailableLoad> killMe = new HashSet<AvailableLoad>();
        for (AvailableLoad availableLoad : this.getAvailableLoadMap().keySet()) {
            XField field = availableLoad.getField();
            String fieldPackageName = this.extractPackageName(field.getClassName());
            if (!packageName.equals(fieldPackageName) || !field.isStatic() || methodName.toLowerCase().indexOf(field.getName().toLowerCase()) < 0) continue;
            killMe.add(availableLoad);
        }
        this.killAvailableLoads(killMe);
    }

    private void killAvailableLoads(HashSet<AvailableLoad> killMe) {
        if (killMe.size() > 0) {
            ValueNumberFrame.removeAllKeys(this.getUpdateableAvailableLoadMap(), killMe);
        }
    }

    private String extractPackageName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    void mergeAvailableLoadSets(ValueNumberFrame other, ValueNumberFactory factory, MergeTree mergeTree) {
        if (REDUNDANT_LOAD_ELIMINATION) {
            String s = "";
            if (RLE_DEBUG) {
                s = "Merging " + this.availableLoadMapAsString() + " and " + other.availableLoadMapAsString();
            }
            boolean changed = false;
            if (other.isBottom()) {
                changed = !this.getAvailableLoadMap().isEmpty();
                this.setAvailableLoadMap(AvailableLoadBiMap.emptyMap());
            } else if (!other.isTop()) {
                for (Map.Entry<AvailableLoad, ValueNumber[]> e : this.getUpdateableAvailableLoadMap().entrySet()) {
                    Object[] otherVN;
                    AvailableLoad load = e.getKey();
                    Object[] myVN = e.getValue();
                    if (Arrays.equals(myVN, otherVN = other.getAvailableLoadMap().get(load))) continue;
                    ValueNumber phi = this.getMergedLoads().get(load);
                    if (phi == null) {
                        int flags = -1;
                        for (Object vn : myVN) {
                            flags = ValueNumber.mergeFlags(flags, ((ValueNumber)vn).getFlags());
                        }
                        if (otherVN != null) {
                            for (Object vn : otherVN) {
                                flags = ValueNumber.mergeFlags(flags, ((ValueNumber)vn).getFlags());
                            }
                        }
                        flags = flags == -1 ? 8 : (flags |= 8);
                        phi = factory.createFreshValue(flags);
                        this.getUpdateableMergedLoads().put(load, phi);
                        for (Object vn : myVN) {
                            mergeTree.mapInputToOutput((ValueNumber)vn, phi);
                        }
                        if (otherVN != null) {
                            for (Object vn : otherVN) {
                                mergeTree.mapInputToOutput((ValueNumber)vn, phi);
                            }
                        }
                        if (RLE_DEBUG) {
                            System.out.println("Creating phi node " + phi + " for " + load + " from " + Arrays.toString(myVN) + " x " + Arrays.toString(otherVN) + " in " + System.identityHashCode(this));
                        }
                        changed = true;
                        e.setValue(new ValueNumber[]{phi});
                        continue;
                    }
                    if (RLE_DEBUG) {
                        System.out.println("Reusing phi node : " + phi + " for " + load + " from " + Arrays.toString(myVN) + " x " + Arrays.toString(otherVN) + " in " + System.identityHashCode(this));
                    }
                    if (myVN.length == 1 && ((ValueNumber)myVN[0]).equals(phi)) continue;
                    e.setValue(new ValueNumber[]{phi});
                }
            }
            Map<ValueNumber, AvailableLoad> previouslyKnownAsOther = other.getPreviouslyKnownAs();
            if (this.getPreviouslyKnownAs() != previouslyKnownAsOther && previouslyKnownAsOther.size() != 0) {
                if (this.getPreviouslyKnownAs().size() == 0) {
                    this.assignPreviouslyKnownAs(other);
                } else {
                    this.getUpdateablePreviouslyKnownAs().putAll(previouslyKnownAsOther);
                }
            }
            if (changed) {
                this.phiNodeForLoads = true;
            }
            if (changed && RLE_DEBUG) {
                System.out.println(s);
                System.out.println("  Result is " + this.availableLoadMapAsString());
                System.out.println(" Set phi for " + System.identityHashCode(this));
            }
        }
    }

    ValueNumber getMergedValue(int slot) {
        return this.mergedValueList.get(slot);
    }

    void setMergedValue(int slot, ValueNumber value) {
        this.mergedValueList.set(slot, value);
    }

    @Override
    public void copyFrom(Frame<ValueNumber> other) {
        if (!(other instanceof ValueNumberFrame)) {
            throw new IllegalArgumentException();
        }
        if (this.mergedValueList == null && other.isValid()) {
            this.mergedValueList = new ArrayList(other.getNumSlots());
            int numSlots = other.getNumSlots();
            for (int i = 0; i < numSlots; ++i) {
                this.mergedValueList.add(null);
            }
        }
        if (REDUNDANT_LOAD_ELIMINATION) {
            this.assignAvailableLoadMap((ValueNumberFrame)other);
            this.assignPreviouslyKnownAs((ValueNumberFrame)other);
        }
        super.copyFrom(other);
    }

    private void assignAvailableLoadMap(ValueNumberFrame other) {
        AvailableLoadBiMap availableLoadMapOther = other.getAvailableLoadMap();
        if (availableLoadMapOther.isModifiable()) {
            availableLoadMapOther = AvailableLoadBiMap.unmodifiableMap(availableLoadMapOther);
            other.setAvailableLoadMap(availableLoadMapOther);
            this.setAvailableLoadMap(availableLoadMapOther);
            ++constructedUnmodifiableMap;
        } else {
            this.setAvailableLoadMap(availableLoadMapOther);
            ++reusedMap;
        }
    }

    private void assignPreviouslyKnownAs(ValueNumberFrame other) {
        Map<ValueNumber, AvailableLoad> previouslyKnownAsOther = other.getPreviouslyKnownAs();
        if (previouslyKnownAsOther instanceof HashMap) {
            previouslyKnownAsOther = Collections.unmodifiableMap(previouslyKnownAsOther);
            other.setPreviouslyKnownAs(previouslyKnownAsOther);
            this.setPreviouslyKnownAs(previouslyKnownAsOther);
            ++constructedUnmodifiableMap;
        } else {
            this.setPreviouslyKnownAs(previouslyKnownAsOther);
            ++reusedMap;
        }
    }

    @Override
    public String toString() {
        String frameValues = super.toString();
        if (RLE_DEBUG) {
            StringBuilder buf = new StringBuilder();
            buf.append(frameValues);
            Iterator<AvailableLoad> i = this.getAvailableLoadMap().keySet().iterator();
            boolean first = true;
            while (i.hasNext()) {
                AvailableLoad key = i.next();
                ValueNumber[] value = this.getAvailableLoadMap().get(key);
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(key + "=" + ValueNumberFrame.valueToString(value));
            }
            buf.append(" #");
            buf.append(System.identityHashCode(this));
            if (this.phiNodeForLoads) {
                buf.append(" phi");
            }
            return buf.toString();
        }
        return frameValues;
    }

    private static String valueToString(ValueNumber[] valueNumberList) {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        boolean first = true;
        for (ValueNumber aValueNumberList : valueNumberList) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(aValueNumberList.getNumber());
        }
        buf.append(']');
        return buf.toString();
    }

    public boolean fuzzyMatch(ValueNumber v1, ValueNumber v2) {
        if (REDUNDANT_LOAD_ELIMINATION) {
            return v1.equals(v2) || this.fromMatchingLoads(v1, v2) || this.haveMatchingFlags(v1, v2);
        }
        return v1.equals(v2);
    }

    public boolean veryFuzzyMatch(ValueNumber v1, ValueNumber v2) {
        if (REDUNDANT_LOAD_ELIMINATION) {
            return v1.equals(v2) || this.fromMatchingFields(v1, v2) || this.haveMatchingFlags(v1, v2);
        }
        return v1.equals(v2);
    }

    public boolean fromMatchingLoads(ValueNumber v1, ValueNumber v2) {
        AvailableLoad load1 = this.getLoad(v1);
        if (load1 == null) {
            load1 = this.getPreviouslyKnownAs().get(v1);
        }
        if (load1 == null) {
            return false;
        }
        AvailableLoad load2 = this.getLoad(v2);
        if (load2 == null) {
            load2 = this.getPreviouslyKnownAs().get(v2);
        }
        if (load2 == null) {
            return false;
        }
        return load1.equals(load2);
    }

    public boolean fromMatchingFields(ValueNumber v1, ValueNumber v2) {
        AvailableLoad load1 = this.getLoad(v1);
        if (load1 == null) {
            load1 = this.getPreviouslyKnownAs().get(v1);
        }
        if (load1 == null) {
            return false;
        }
        AvailableLoad load2 = this.getLoad(v2);
        if (load2 == null) {
            load2 = this.getPreviouslyKnownAs().get(v2);
        }
        if (load2 == null) {
            return false;
        }
        if (load1.equals(load2)) {
            return true;
        }
        if (load1.getField().equals(load2.getField())) {
            ValueNumber source1 = load1.getReference();
            ValueNumber source2 = load2.getReference();
            if (!this.contains(source1)) {
                return true;
            }
            if (!this.contains(source2)) {
                return true;
            }
        }
        return false;
    }

    public boolean haveMatchingFlags(ValueNumber v1, ValueNumber v2) {
        int flag2;
        int flag1 = v1.getFlags();
        return (flag1 & (flag2 = v2.getFlags())) != 0;
    }

    public Collection<ValueNumber> valueNumbersForLoads() {
        HashSet<ValueNumber> result = new HashSet<ValueNumber>();
        if (REDUNDANT_LOAD_ELIMINATION) {
            for (Map.Entry<AvailableLoad, ValueNumber[]> e : this.getAvailableLoadMap().entrySet()) {
                if (e.getValue() == null) continue;
                Collections.addAll(result, e.getValue());
            }
        }
        return result;
    }

    private void setAvailableLoadMap(AvailableLoadBiMap availableLoadMap) {
        this.availableLoadMap = availableLoadMap;
    }

    private AvailableLoadBiMap getAvailableLoadMap() {
        return this.availableLoadMap;
    }

    private AvailableLoadBiMap getUpdateableAvailableLoadMap() {
        if (!this.availableLoadMap.isModifiable()) {
            HashMap<AvailableLoad, ValueNumber[]> tmp = new HashMap<AvailableLoad, ValueNumber[]>(this.availableLoadMap.size() + 4);
            tmp.putAll(this.availableLoadMap.map);
            this.availableLoadMap = new AvailableLoadBiMap(tmp);
        }
        return this.availableLoadMap;
    }

    private void setMergedLoads(Map<AvailableLoad, ValueNumber> mergedLoads) {
        this.mergedLoads = mergedLoads;
    }

    private Map<AvailableLoad, ValueNumber> getMergedLoads() {
        return this.mergedLoads;
    }

    private Map<AvailableLoad, ValueNumber> getUpdateableMergedLoads() {
        if (!(this.mergedLoads instanceof HashMap)) {
            this.mergedLoads = new HashMap<AvailableLoad, ValueNumber>();
        }
        return this.mergedLoads;
    }

    private void setPreviouslyKnownAs(Map<ValueNumber, AvailableLoad> previouslyKnownAs) {
        this.previouslyKnownAs = previouslyKnownAs;
    }

    private Map<ValueNumber, AvailableLoad> getPreviouslyKnownAs() {
        return this.previouslyKnownAs;
    }

    private Map<ValueNumber, AvailableLoad> getUpdateablePreviouslyKnownAs() {
        if (this.previouslyKnownAs.size() == 0) {
            this.previouslyKnownAs = new HashMap<ValueNumber, AvailableLoad>(4);
            ++createdEmptyMap;
        } else if (!(this.previouslyKnownAs instanceof HashMap)) {
            HashMap<ValueNumber, AvailableLoad> tmp = new HashMap<ValueNumber, AvailableLoad>(this.previouslyKnownAs.size() + 4);
            tmp.putAll(this.previouslyKnownAs);
            this.previouslyKnownAs = tmp;
            ++madeImmutableMutable;
        } else {
            ++reusedMutableMap;
        }
        return this.previouslyKnownAs;
    }

    @Override
    public boolean sameAs(Frame<ValueNumber> other) {
        if (!super.sameAs(other)) {
            return false;
        }
        if (this.isTop() && other.isTop() || this.isBottom() && other.isBottom()) {
            return true;
        }
        ValueNumberFrame o = (ValueNumberFrame)other;
        if (this.availableLoadMap.size() != o.availableLoadMap.size()) {
            return false;
        }
        for (Map.Entry<AvailableLoad, ValueNumber[]> entry : this.availableLoadMap.entrySet()) {
            Object[] oValue = o.availableLoadMap.get(entry.getKey());
            if (Arrays.equals(entry.getValue(), oValue)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAvailableLoads() {
        return !this.getAvailableLoadMap().isEmpty();
    }

    static {
        Util.runLogAtShutdown(() -> {
            System.err.println("Getting updatable previously known as:");
            System.err.println("  " + createdEmptyMap + " created empty map");
            System.err.println("  " + madeImmutableMutable + " made immutable map mutable");
            System.err.println("  " + reusedMutableMap + " reused mutable map");
            System.err.println("Copying map:");
            System.err.println("  " + constructedUnmodifiableMap + " made mutable map unmodifiable");
            System.err.println("  " + reusedMap + " reused immutable map");
            System.err.println();
        });
    }

    private static class AvailableLoadBiMap {
        private final Map<AvailableLoad, ValueNumber[]> map;
        private final Map<ValueNumber, AvailableLoad> reverseMap;

        public AvailableLoadBiMap(Map<AvailableLoad, ValueNumber[]> map) {
            this.map = map;
            this.reverseMap = new HashMap<ValueNumber, AvailableLoad>();
            for (Map.Entry<AvailableLoad, ValueNumber[]> entry : map.entrySet()) {
                ValueNumber[] value;
                for (ValueNumber element : value = entry.getValue()) {
                    this.reverseMap.put(element, entry.getKey());
                }
            }
        }

        public AvailableLoadBiMap(Map<AvailableLoad, ValueNumber[]> map, Map<ValueNumber, AvailableLoad> reverseMap) {
            this.map = map;
            this.reverseMap = reverseMap;
        }

        public static AvailableLoadBiMap emptyMap() {
            return new AvailableLoadBiMap(Collections.emptyMap(), Collections.emptyMap());
        }

        public static AvailableLoadBiMap unmodifiableMap(AvailableLoadBiMap other) {
            return new AvailableLoadBiMap(Collections.unmodifiableMap(other.map), Collections.unmodifiableMap(other.reverseMap));
        }

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Set<AvailableLoad> keySet() {
            return this.map.keySet();
        }

        public Set<Map.Entry<AvailableLoad, ValueNumber[]>> entrySet() {
            return this.map.entrySet();
        }

        public ValueNumber[] get(AvailableLoad key) {
            return this.map.get(key);
        }

        public ValueNumber[] put(AvailableLoad key, ValueNumber[] value) {
            ValueNumber[] previous = this.map.put(key, value);
            for (ValueNumber v : value) {
                this.reverseMap.put(v, key);
            }
            return previous;
        }

        public ValueNumber[] remove(AvailableLoad key) {
            ValueNumber[] value;
            for (ValueNumber v : value = this.map.remove(key)) {
                this.reverseMap.remove(v);
            }
            return value;
        }

        public AvailableLoad getLoad(ValueNumber v) {
            return this.reverseMap.get(v);
        }

        public boolean isModifiable() {
            return this.map instanceof HashMap;
        }
    }
}

