/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.ForwardDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.Path;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.obl.InstructionActionCache;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationFactory;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabase;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseAction;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseActionType;
import edu.umd.cs.findbugs.ba.obl.ObligationSet;
import edu.umd.cs.findbugs.ba.obl.State;
import edu.umd.cs.findbugs.ba.obl.StateSet;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.IErrorLogger;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.WillClose;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObligationAnalysis
extends ForwardDataflowAnalysis<StateSet> {
    private static final boolean DEBUG = SystemProperties.getBoolean("oa.debug");
    private static final boolean DEBUG_NULL_CHECK = SystemProperties.getBoolean("oa.debug.nullcheck");
    private final XMethod xmethod;
    private final ObligationFactory factory;
    private final ObligationPolicyDatabase database;
    private final TypeDataflow typeDataflow;
    private final IsNullValueDataflow invDataflow;
    private final IErrorLogger errorLogger;
    private final InstructionActionCache actionCache;
    private StateSet cachedEntryFact;
    static final ClassDescriptor willClose = DescriptorFactory.createClassDescriptor(WillClose.class);
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ObligationAnalysis(DepthFirstSearch dfs, XMethod xmethod, ConstantPoolGen cpg, ObligationFactory factory, ObligationPolicyDatabase database, TypeDataflow typeDataflow, IsNullValueDataflow invDataflow, IErrorLogger errorLogger) {
        super(dfs);
        this.xmethod = xmethod;
        this.factory = factory;
        this.database = database;
        this.typeDataflow = typeDataflow;
        this.invDataflow = invDataflow;
        this.errorLogger = errorLogger;
        this.actionCache = new InstructionActionCache(database, xmethod, cpg, typeDataflow);
    }

    public InstructionActionCache getActionCache() {
        return this.actionCache;
    }

    @Override
    public StateSet createFact() {
        return new StateSet(this.factory);
    }

    @Override
    public boolean isFactValid(StateSet fact) {
        return fact.isValid();
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, StateSet fact) throws DataflowAnalysisException {
        Collection<ObligationPolicyDatabaseAction> actionList = this.actionCache.getActions(basicBlock, handle);
        if (actionList.isEmpty()) {
            return;
        }
        if (DEBUG) {
            System.out.println("Applying actions at " + handle + " to " + fact);
        }
        for (ObligationPolicyDatabaseAction action : actionList) {
            if (DEBUG) {
                System.out.print("  " + action + "...");
            }
            action.apply(fact, basicBlock.getLabel());
            if (!DEBUG) continue;
            System.out.println(fact);
        }
    }

    @Override
    public void transfer(BasicBlock basicBlock, @CheckForNull InstructionHandle end, StateSet start, StateSet result) throws DataflowAnalysisException {
        super.transfer(basicBlock, end, start, result);
        this.endTransfer(basicBlock, end, result);
    }

    private void endTransfer(BasicBlock basicBlock, @CheckForNull InstructionHandle end, StateSet result) {
        Iterator<State> i = result.stateIterator();
        while (i.hasNext()) {
            State state = i.next();
            state.getPath().append(basicBlock.getLabel());
        }
    }

    @Override
    public void edgeTransfer(Edge edge, StateSet fact) throws DataflowAnalysisException {
        Obligation comparedObligation;
        if (edge.isExceptionEdge()) {
            if (!edge.isFlagSet(1)) {
                fact.setTop();
            } else {
                BasicBlock sourceBlock = (BasicBlock)edge.getSource();
                InstructionHandle handle = sourceBlock.getExceptionThrower();
                fact.setOnExceptionPath(true);
                Collection<ObligationPolicyDatabaseAction> actions = this.actionCache.getActions(sourceBlock, handle);
                for (ObligationPolicyDatabaseAction action : actions) {
                    if (action.getActionType() != ObligationPolicyDatabaseActionType.DEL) continue;
                    action.apply(fact, ((BasicBlock)edge.getTarget()).getLabel());
                }
            }
        }
        if (this.isPossibleIfComparison(edge) && (comparedObligation = this.comparesObligationTypeToNull(edge)) != null) {
            if (DEBUG_NULL_CHECK) {
                System.out.println("Deleting " + comparedObligation.toString() + " on edge from comparison " + ((BasicBlock)edge.getSource()).getLastInstruction());
            }
            fact.deleteObligation(comparedObligation, ((BasicBlock)edge.getTarget()).getLabel());
            Obligation statement = this.database.getFactory().getObligationByName("java.sql.Statement");
            if (comparedObligation.equals(statement)) {
                Obligation resultSet = this.database.getFactory().getObligationByName("java.sql.ResultSet");
                fact.deleteObligation(resultSet, ((BasicBlock)edge.getTarget()).getLabel());
                if (DEBUG_NULL_CHECK) {
                    LOG.debug("Deleting {} on edge from comparison {}", (Object)resultSet, (Object)((BasicBlock)edge.getSource()).getLastInstruction());
                }
            }
        }
    }

    private boolean isPossibleIfComparison(Edge edge) {
        return edge.getType() == 1 || edge.getType() == 0;
    }

    private Obligation comparesObligationTypeToNull(Edge edge) throws DataflowAnalysisException {
        BasicBlock sourceBlock = (BasicBlock)edge.getSource();
        InstructionHandle last = sourceBlock.getLastInstruction();
        if (last == null) {
            if (DEBUG_NULL_CHECK) {
                System.out.println("no last instruction in source block of " + edge + " ???");
            }
            return null;
        }
        Type type = null;
        short opcode = last.getInstruction().getOpcode();
        switch (opcode) {
            case 198: 
            case 199: {
                type = this.nullCheck(opcode, edge, last, sourceBlock);
                break;
            }
            case 165: 
            case 166: {
                type = this.acmpNullCheck(opcode, edge, last, sourceBlock);
                break;
            }
        }
        if (!(type instanceof ObjectType)) {
            return null;
        }
        try {
            return this.database.getFactory().getObligationByType((ObjectType)type);
        }
        catch (ClassNotFoundException e) {
            this.errorLogger.reportMissingClass(e);
            throw new MissingClassException(e);
        }
    }

    private Type nullCheck(short opcode, Edge edge, InstructionHandle last, BasicBlock sourceBlock) throws DataflowAnalysisException {
        Location location;
        TypeFrame typeFrame;
        if (DEBUG_NULL_CHECK) {
            System.out.println("checking for nullcheck on edge " + edge);
        }
        Type type = null;
        if ((opcode == 198 && edge.getType() == 1 || opcode == 199 && edge.getType() == 0) && (typeFrame = (TypeFrame)this.typeDataflow.getFactAtLocation(location = new Location(last, sourceBlock))).isValid()) {
            type = (Type)typeFrame.getTopValue();
            if (DEBUG_NULL_CHECK) {
                System.out.println("ifnull comparison of " + type + " to null at " + last);
            }
        }
        return type;
    }

    private Type acmpNullCheck(short opcode, Edge edge, InstructionHandle last, BasicBlock sourceBlock) throws DataflowAnalysisException {
        Type type = null;
        if (opcode == 165 && edge.getType() == 1 || opcode == 166 && edge.getType() == 0) {
            Location location = new Location(last, sourceBlock);
            IsNullValueFrame invFrame = (IsNullValueFrame)this.invDataflow.getFactAtLocation(location);
            TypeFrame typeFrame = (TypeFrame)this.typeDataflow.getFactAtLocation(location);
            if (invFrame.isValid() && typeFrame.isValid()) {
                boolean leftIsNull = ((IsNullValue)invFrame.getStackValue(1)).isDefinitelyNull();
                boolean rightIsNull = ((IsNullValue)invFrame.getStackValue(0)).isDefinitelyNull();
                if (!(!leftIsNull && !rightIsNull || leftIsNull && rightIsNull)) {
                    type = (Type)typeFrame.getStackValue(leftIsNull ? 0 : 1);
                    if (DEBUG_NULL_CHECK) {
                        System.out.println("acmp comparison of " + type + " to null at " + last);
                    }
                }
            }
        }
        return type;
    }

    @Override
    public void copy(StateSet src, StateSet dest) {
        dest.copyFrom(src);
    }

    @Override
    public void initEntryFact(StateSet fact) throws DataflowAnalysisException {
        if (this.cachedEntryFact == null) {
            this.cachedEntryFact = new StateSet(this.factory);
            State state = new State(this.factory);
            Obligation[] paramObligations = this.factory.getParameterObligationTypes(this.xmethod);
            ObligationSet obligationSet = state.getObligationSet();
            for (int i = 0; i < paramObligations.length; ++i) {
                if (paramObligations[i] == null || this.xmethod.getParameterAnnotation(i, willClose) == null) continue;
                obligationSet.add(paramObligations[i]);
            }
            if (!obligationSet.isEmpty()) {
                HashMap<ObligationSet, State> map = new HashMap<ObligationSet, State>();
                map.put(obligationSet, state);
                this.cachedEntryFact.replaceMap(map);
            }
        }
        fact.copyFrom(this.cachedEntryFact);
    }

    @Override
    public void makeFactTop(StateSet fact) {
        fact.setTop();
    }

    @Override
    public boolean isTop(StateSet fact) {
        return fact.isTop();
    }

    @Override
    public boolean same(StateSet a, StateSet b) {
        return a.equals(b);
    }

    @Override
    public void meetInto(StateSet fact, Edge edge, StateSet result) throws DataflowAnalysisException {
        StateSet inputFact = fact;
        if (DEBUG && inputFact.isValid()) {
            Iterator<State> i = inputFact.stateIterator();
            while (i.hasNext()) {
                State state = i.next();
                Path path = state.getPath();
                if (path.getLength() <= 0 || path.getBlockIdAt(path.getLength() - 1) == ((BasicBlock)edge.getSource()).getLabel()) continue;
                throw new IllegalStateException("on edge " + edge + ": state " + state + " missing source label in path");
            }
        }
        if (!inputFact.isTop() && !result.isBottom()) {
            if (inputFact.isBottom() || result.isTop() || result.isEmpty()) {
                this.copy(inputFact, result);
            } else if (inputFact.isOnExceptionPath() && !result.isOnExceptionPath()) {
                if (DEBUG) {
                    System.out.println("Ignoring " + inputFact + " in favor of " + result);
                    BasicBlock from = (BasicBlock)edge.getSource();
                    BasicBlock to = (BasicBlock)edge.getTarget();
                    System.out.printf("  edge %s -> %s%n", from, to);
                }
            } else if (!inputFact.isOnExceptionPath() && !inputFact.isEmpty() && result.isOnExceptionPath()) {
                if (DEBUG) {
                    System.out.println("overwriting " + result + " with " + inputFact);
                }
                this.copy(inputFact, result);
            } else {
                Map<ObligationSet, State> updatedStateMap = result.createEmptyMap();
                HashSet<ObligationSet> allObligationSets = new HashSet<ObligationSet>();
                allObligationSets.addAll(inputFact.getAllObligationSets());
                allObligationSets.addAll(result.getAllObligationSets());
                for (ObligationSet obligationSet : allObligationSets) {
                    State stateToAdd;
                    State stateInInputFact = inputFact.getStateWithObligationSet(obligationSet);
                    State stateInResultFact = result.getStateWithObligationSet(obligationSet);
                    if (stateInInputFact != null && stateInResultFact != null) {
                        Path path = stateInResultFact.getPath();
                        if (stateInInputFact.getPath().getLength() < path.getLength()) {
                            path = stateInInputFact.getPath();
                        }
                        stateToAdd = new State(this.factory);
                        stateToAdd.getObligationSet().copyFrom(obligationSet);
                        stateToAdd.getPath().copyFrom(path);
                    } else {
                        stateToAdd = stateInInputFact != null ? stateInInputFact.duplicate() : stateInResultFact.duplicate();
                    }
                    updatedStateMap.put(stateToAdd.getObligationSet(), stateToAdd);
                }
                result.replaceMap(updatedStateMap);
            }
        }
    }
}

