/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.deref;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AssertionMethods;
import edu.umd.cs.findbugs.ba.BackwardDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefSet;
import edu.umd.cs.findbugs.ba.interproc.ParameterProperty;
import edu.umd.cs.findbugs.ba.npe.IsNullConditionDecision;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.TypeQualifierNullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.AvailableLoad;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.visitclass.Util;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;

public class UnconditionalValueDerefAnalysis
extends BackwardDataflowAnalysis<UnconditionalValueDerefSet> {
    public static final boolean DEBUG = SystemProperties.getBoolean("fnd.derefs.debug");
    public static final boolean ASSUME_NONZERO_TRIP_LOOPS = SystemProperties.getBoolean("fnd.derefs.nonzerotrip");
    public static final boolean IGNORE_DEREF_OF_NCP = SystemProperties.getBoolean("fnd.derefs.ignoreNCP", false);
    public static final boolean CHECK_ANNOTATIONS = SystemProperties.getBoolean("fnd.derefs.checkannotations", true);
    public static final boolean CHECK_CALLS = SystemProperties.getBoolean("fnd.derefs.checkcalls", true);
    public static final boolean DEBUG_CHECK_CALLS = SystemProperties.getBoolean("fnd.derefs.checkcalls.debug");
    private static final int[] NULLCHECK1 = new int[]{89, 183, 191};
    private static final int[] NULLCHECK2 = new int[]{89, 18, 183, 191};
    private final CFG cfg;
    private final Method method;
    private final MethodGen methodGen;
    private final ValueNumberDataflow vnaDataflow;
    private final AssertionMethods assertionMethods;
    private IsNullValueDataflow invDataflow;
    private TypeDataflow typeDataflow;
    public static final boolean VERBOSE_NULLARG_DEBUG = SystemProperties.getBoolean("fnd.debug.nullarg.verbose");

    public UnconditionalValueDerefAnalysis(ReverseDepthFirstSearch rdfs, DepthFirstSearch dfs, CFG cfg, Method method, MethodGen methodGen, ValueNumberDataflow vnaDataflow, AssertionMethods assertionMethods) {
        super(rdfs, dfs);
        this.cfg = cfg;
        this.methodGen = methodGen;
        this.method = method;
        this.vnaDataflow = vnaDataflow;
        this.assertionMethods = assertionMethods;
        if (DEBUG) {
            System.out.println("UnconditionalValueDerefAnalysis analysis " + methodGen.getClassName() + "." + methodGen.getName() + " : " + methodGen.getSignature());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " of " + this.method;
    }

    public void clearDerefsOnNonNullBranches(IsNullValueDataflow invDataflow) {
        this.invDataflow = invDataflow;
    }

    public void setTypeDataflow(TypeDataflow typeDataflow) {
        this.typeDataflow = typeDataflow;
    }

    @Override
    public boolean isFactValid(UnconditionalValueDerefSet fact) {
        return !fact.isTop() && !fact.isBottom();
    }

    private static boolean check(InstructionHandle h, int[] opcodes) {
        for (int opcode : opcodes) {
            block7: {
                short opcode2;
                block6: {
                    if (h == null) {
                        return false;
                    }
                    opcode2 = h.getInstruction().getOpcode();
                    if (opcode != 18) break block6;
                    switch (opcode2) {
                        case 18: 
                        case 25: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: {
                            break block7;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                if (opcode2 != opcode) {
                    return false;
                }
            }
            h = h.getNext();
        }
        return true;
    }

    public static boolean isNullCheck(InstructionHandle h, ConstantPoolGen cpg) {
        if (!(h.getInstruction() instanceof IFNONNULL)) {
            return false;
        }
        Instruction newInstruction = (h = h.getNext()).getInstruction();
        if (!(newInstruction instanceof NEW)) {
            return false;
        }
        ObjectType loadClassType = ((NEW)newInstruction).getLoadClassType(cpg);
        if (!"java.lang.NullPointerException".equals(loadClassType.getClassName())) {
            return false;
        }
        return UnconditionalValueDerefAnalysis.check(h = h.getNext(), NULLCHECK1) || UnconditionalValueDerefAnalysis.check(h, NULLCHECK2);
    }

    private void handleNullCheck(Location location, ValueNumberFrame vnaFrame, UnconditionalValueDerefSet fact) throws DataflowAnalysisException {
        if (UnconditionalValueDerefAnalysis.reportPotentialDereference(location, (IsNullValueFrame)this.invDataflow.getFactAtLocation(location))) {
            ValueNumber vn = (ValueNumber)vnaFrame.getTopValue();
            fact.addDeref(vn, location);
        }
    }

    public static boolean reportPotentialDereference(Location location, IsNullValueFrame invFrame) throws DataflowAnalysisException {
        if (!invFrame.isValid()) {
            return false;
        }
        IsNullValue value = (IsNullValue)invFrame.getTopValue();
        return !value.isDefinitelyNotNull() && !value.isDefinitelyNull();
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, UnconditionalValueDerefSet fact) throws DataflowAnalysisException {
        Instruction instruction = handle.getInstruction();
        if (fact.isTop()) {
            return;
        }
        Location location = new Location(handle, basicBlock);
        if (this.isAssertion(handle)) {
            if (DEBUG) {
                System.out.println("MAKING BOTTOM0 AT: " + location);
            }
            fact.clear();
            return;
        }
        ValueNumberFrame vnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(location);
        if (!vnaFrame.isValid()) {
            if (DEBUG) {
                System.out.println("MAKING TOP1 AT: " + location);
            }
            this.makeFactTop(fact);
            return;
        }
        if (UnconditionalValueDerefAnalysis.isNullCheck(handle, this.methodGen.getConstantPool())) {
            this.handleNullCheck(location, vnaFrame, fact);
        }
        if (CHECK_CALLS && instruction instanceof InvokeInstruction) {
            this.checkUnconditionalDerefDatabase(location, vnaFrame, fact);
        }
        if (CHECK_ANNOTATIONS && instruction instanceof InvokeInstruction) {
            this.checkNonNullParams(location, vnaFrame, fact);
        }
        if (CHECK_ANNOTATIONS && instruction instanceof ARETURN) {
            XMethod thisMethod = XFactory.createXMethod(this.methodGen);
            this.checkNonNullReturnValue(thisMethod, location, vnaFrame, fact);
        }
        if (CHECK_ANNOTATIONS && (instruction instanceof PUTFIELD || instruction instanceof PUTSTATIC)) {
            this.checkNonNullPutField(location, vnaFrame, fact);
        }
        this.checkInstance(location, vnaFrame, fact);
        if (DEBUG && fact.isTop()) {
            System.out.println("MAKING TOP2 At: " + location);
        }
    }

    private void checkUnconditionalDerefDatabase(Location location, ValueNumberFrame vnaFrame, UnconditionalValueDerefSet fact) throws DataflowAnalysisException {
        ConstantPoolGen constantPool = this.methodGen.getConstantPool();
        for (ValueNumber vn : UnconditionalValueDerefAnalysis.checkUnconditionalDerefDatabase(location, vnaFrame, constantPool, (IsNullValueFrame)this.invDataflow.getFactAtLocation(location), this.typeDataflow)) {
            fact.addDeref(vn, location);
        }
    }

    public static Set<ValueNumber> checkUnconditionalDerefDatabase(Location location, ValueNumberFrame vnaFrame, ConstantPoolGen constantPool, @CheckForNull IsNullValueFrame invFrame, TypeDataflow typeDataflow) throws DataflowAnalysisException {
        if (invFrame != null && !invFrame.isValid()) {
            return Collections.emptySet();
        }
        InvokeInstruction inv = (InvokeInstruction)location.getHandle().getInstruction();
        SignatureParser sigParser = new SignatureParser(inv.getSignature(constantPool));
        int numParams = sigParser.getNumParameters();
        if (numParams == 0 || !sigParser.hasReferenceParameters()) {
            return Collections.emptySet();
        }
        ParameterNullnessPropertyDatabase database = AnalysisContext.currentAnalysisContext().getUnconditionalDerefParamDatabase();
        if (database == null) {
            if (DEBUG_CHECK_CALLS) {
                System.out.println("no database!");
            }
            return Collections.emptySet();
        }
        TypeFrame typeFrame = (TypeFrame)typeDataflow.getFactAtLocation(location);
        if (!typeFrame.isValid()) {
            if (DEBUG_CHECK_CALLS) {
                System.out.println("invalid type frame!");
            }
            return Collections.emptySet();
        }
        try {
            Set<XMethod> targetSet = Hierarchy2.resolveMethodCallTargets(inv, typeFrame, constantPool);
            if (targetSet.isEmpty()) {
                return Collections.emptySet();
            }
            if (DEBUG_CHECK_CALLS) {
                System.out.println("target set size: " + targetSet.size());
            }
            ParameterProperty derefParamSet = null;
            for (XMethod target : targetSet) {
                ParameterProperty targetDerefParamSet;
                if (target.isStub()) continue;
                if (DEBUG_CHECK_CALLS) {
                    System.out.print("Checking: " + target + ": ");
                }
                if ((targetDerefParamSet = (ParameterProperty)database.getProperty(target.getMethodDescriptor())) == null) {
                    if (DEBUG_CHECK_CALLS) {
                        System.out.println("==> no information, assume no guaranteed dereferences");
                    }
                    return Collections.emptySet();
                }
                if (DEBUG_CHECK_CALLS) {
                    System.out.println("==> " + targetDerefParamSet);
                }
                if (derefParamSet == null) {
                    derefParamSet = new ParameterProperty();
                    derefParamSet.copyFrom(targetDerefParamSet);
                    continue;
                }
                derefParamSet.intersectWith(targetDerefParamSet);
            }
            if (derefParamSet == null || derefParamSet.isEmpty()) {
                if (DEBUG) {
                    System.out.println("** Nothing");
                }
                return Collections.emptySet();
            }
            if (DEBUG_CHECK_CALLS) {
                System.out.println("** Summary of call @ " + location.getHandle().getPosition() + ": " + derefParamSet);
            }
            HashSet<ValueNumber> requiredToBeNonnull = new HashSet<ValueNumber>();
            for (int i = 0; i < numParams; ++i) {
                if (!derefParamSet.hasProperty(i)) continue;
                int argSlot = vnaFrame.getStackLocation(sigParser.getSlotsFromTopOfStackForParameter(i));
                if (invFrame != null && !UnconditionalValueDerefAnalysis.reportDereference(invFrame, argSlot)) continue;
                if (DEBUG_CHECK_CALLS) {
                    System.out.println("  dereference @ " + location.getHandle().getPosition() + " of parameter " + i);
                }
                requiredToBeNonnull.add((ValueNumber)vnaFrame.getValue(argSlot));
            }
            return requiredToBeNonnull;
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return Collections.emptySet();
        }
    }

    private void checkNonNullReturnValue(XMethod thisMethod, Location location, ValueNumberFrame vnaFrame, UnconditionalValueDerefSet fact) throws DataflowAnalysisException {
        TypeQualifierNullnessAnnotationDatabase database = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase();
        if (database.getResolvedAnnotation(thisMethod, true) != NullnessAnnotation.NONNULL) {
            return;
        }
        if (UnconditionalValueDerefAnalysis.reportPotentialDereference(location, (IsNullValueFrame)this.invDataflow.getFactAtLocation(location))) {
            ValueNumber vn = (ValueNumber)vnaFrame.getTopValue();
            fact.addDeref(vn, location);
        }
    }

    private void checkNonNullPutField(Location location, ValueNumberFrame vnaFrame, UnconditionalValueDerefSet fact) throws DataflowAnalysisException {
        TypeQualifierNullnessAnnotationDatabase database = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase();
        FieldInstruction fieldIns = (FieldInstruction)location.getHandle().getInstruction();
        XField field = XFactory.createXField(fieldIns, this.methodGen.getConstantPool());
        char firstChar = field.getSignature().charAt(0);
        if (firstChar != 'L' && firstChar != '[') {
            return;
        }
        NullnessAnnotation resolvedAnnotation = database.getResolvedAnnotation(field, true);
        if (resolvedAnnotation == NullnessAnnotation.NONNULL) {
            IsNullValueFrame invFrame = (IsNullValueFrame)this.invDataflow.getFactAtLocation(location);
            if (!invFrame.isValid()) {
                return;
            }
            IsNullValue value = (IsNullValue)invFrame.getTopValue();
            if (UnconditionalValueDerefAnalysis.reportDereference(value)) {
                ValueNumber vn = (ValueNumber)vnaFrame.getTopValue();
                fact.addDeref(vn, location);
            }
        }
    }

    private void checkNonNullParams(Location location, ValueNumberFrame vnaFrame, UnconditionalValueDerefSet fact) throws DataflowAnalysisException {
        ConstantPoolGen constantPool = this.methodGen.getConstantPool();
        Set<ValueNumber> nonNullParams = UnconditionalValueDerefAnalysis.checkNonNullParams(location, vnaFrame, constantPool, this.method, (IsNullValueFrame)this.invDataflow.getFactAtLocation(location));
        for (ValueNumber vn : nonNullParams) {
            fact.addDeref(vn, location);
        }
    }

    public static Set<ValueNumber> checkAllNonNullParams(Location location, ValueNumberFrame vnaFrame, ConstantPoolGen constantPool, @CheckForNull Method method, @CheckForNull IsNullValueDataflow invDataflow, TypeDataflow typeDataflow) throws DataflowAnalysisException {
        IsNullValueFrame invFrame = null;
        if (invDataflow != null) {
            invFrame = (IsNullValueFrame)invDataflow.getFactAtLocation(location);
        }
        Set<ValueNumber> result1 = UnconditionalValueDerefAnalysis.checkNonNullParams(location, vnaFrame, constantPool, method, invFrame);
        Set<ValueNumber> result2 = UnconditionalValueDerefAnalysis.checkUnconditionalDerefDatabase(location, vnaFrame, constantPool, invFrame, typeDataflow);
        if (result1.isEmpty()) {
            return result2;
        }
        if (result2.isEmpty()) {
            return result1;
        }
        result1.addAll(result2);
        return result1;
    }

    public static Set<ValueNumber> checkNonNullParams(Location location, ValueNumberFrame vnaFrame, ConstantPoolGen constantPool, @CheckForNull Method method, @CheckForNull IsNullValueFrame invFrame) throws DataflowAnalysisException {
        if (invFrame != null && !invFrame.isValid()) {
            return Collections.emptySet();
        }
        TypeQualifierNullnessAnnotationDatabase database = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase();
        InvokeInstruction inv = (InvokeInstruction)location.getHandle().getInstruction();
        if (inv instanceof INVOKEDYNAMIC) {
            return Collections.emptySet();
        }
        XMethod called = XFactory.createXMethod(inv, constantPool);
        SignatureParser sigParser = new SignatureParser(called.getSignature());
        int numParams = sigParser.getNumParameters();
        HashSet<ValueNumber> result = new HashSet<ValueNumber>();
        Iterator<String> parameterIterator = sigParser.parameterSignatureIterator();
        for (int i = 0; i < numParams; ++i) {
            int slot;
            String parameterSignature = parameterIterator.next();
            char firstChar = parameterSignature.charAt(0);
            if (firstChar != 'L' && firstChar != '[') continue;
            int offset = sigParser.getSlotsFromTopOfStackForParameter(i);
            if (invFrame != null && !UnconditionalValueDerefAnalysis.reportDereference(invFrame, slot = invFrame.getStackLocation(offset)) || !database.parameterMustBeNonNull(called, i)) continue;
            int catchSizeNPE = Util.getSizeOfSurroundingTryBlock(method, "java/lang/NullPointerException", location.getHandle().getPosition());
            int catchSizeNFE = Util.getSizeOfSurroundingTryBlock(method, "java/lang/NumberFormatException", location.getHandle().getPosition());
            if (catchSizeNPE != Integer.MAX_VALUE || "java.lang.Integer".equals(called.getClassName()) && catchSizeNFE != Integer.MAX_VALUE) continue;
            ValueNumber vn = (ValueNumber)vnaFrame.getArgument(inv, constantPool, i, sigParser);
            result.add(vn);
        }
        return result;
    }

    private void checkInstance(Location location, ValueNumberFrame vnaFrame, UnconditionalValueDerefSet fact) throws DataflowAnalysisException {
        ValueNumber v;
        if (!location.isFirstInstructionInBasicBlock()) {
            return;
        }
        if (this.invDataflow == null) {
            return;
        }
        BasicBlock fallThroughPredecessor = this.cfg.getPredecessorWithEdgeType(location.getBasicBlock(), 0);
        if (fallThroughPredecessor == null || !fallThroughPredecessor.isNullCheck()) {
            return;
        }
        ValueNumber vn = (ValueNumber)vnaFrame.getInstance(location.getHandle().getInstruction(), this.methodGen.getConstantPool());
        if (!this.methodGen.isStatic() && (v = (ValueNumber)vnaFrame.getValue(0)).equals(vn)) {
            return;
        }
        if (vn.hasFlag(4)) {
            return;
        }
        IsNullValueFrame startFact = null;
        startFact = (IsNullValueFrame)this.invDataflow.getStartFact(fallThroughPredecessor);
        if (!startFact.isValid()) {
            return;
        }
        int slot = startFact.getInstanceSlot(location.getHandle().getInstruction(), this.methodGen.getConstantPool());
        if (!UnconditionalValueDerefAnalysis.reportDereference(startFact, slot)) {
            return;
        }
        if (DEBUG) {
            System.out.println("FOUND GUARANTEED DEREFERENCE");
            System.out.println("Load: " + vnaFrame.getLoad(vn));
            System.out.println("Pred: " + fallThroughPredecessor);
            System.out.println("startFact: " + startFact);
            System.out.println("Location: " + location);
            System.out.println("Value number frame: " + vnaFrame);
            System.out.println("Dereferenced valueNumber: " + vn);
            System.out.println("invDataflow: " + startFact);
            System.out.println("IGNORE_DEREF_OF_NCP: " + IGNORE_DEREF_OF_NCP);
        }
        fact.addDeref(vn, location);
    }

    private static boolean reportDereference(IsNullValueFrame invFrameAtNullCheck, int instance) {
        return UnconditionalValueDerefAnalysis.reportDereference((IsNullValue)invFrameAtNullCheck.getValue(instance));
    }

    private static boolean reportDereference(IsNullValue value) {
        return !value.isDefinitelyNotNull() && !value.isDefinitelyNull() && (!IGNORE_DEREF_OF_NCP || !value.isNullOnComplicatedPath());
    }

    private boolean isAssertion(InstructionHandle handle) {
        return this.assertionMethods.isAssertionHandle(handle, this.methodGen.getConstantPool());
    }

    @Override
    public void copy(UnconditionalValueDerefSet source, UnconditionalValueDerefSet dest) {
        dest.makeSameAs(source);
    }

    @Override
    public UnconditionalValueDerefSet createFact() {
        return new UnconditionalValueDerefSet(((ValueNumberAnalysis)this.vnaDataflow.getAnalysis()).getNumValuesAllocated());
    }

    @Override
    public void initEntryFact(UnconditionalValueDerefSet result) throws DataflowAnalysisException {
        result.clear();
    }

    @Override
    public void makeFactTop(UnconditionalValueDerefSet fact) {
        fact.setIsTop();
    }

    @Override
    public boolean isTop(UnconditionalValueDerefSet fact) {
        return fact.isTop();
    }

    @Override
    public void meetInto(UnconditionalValueDerefSet fact, Edge edge, UnconditionalValueDerefSet result) throws DataflowAnalysisException {
        this.meetInto(fact, edge, result, false);
    }

    public void meetInto(UnconditionalValueDerefSet fact, Edge edge, UnconditionalValueDerefSet result, boolean onlyEdge) {
        if (this.isExceptionEdge(edge) && !onlyEdge) {
            if (DEBUG) {
                System.out.println("Skipping exception edge");
            }
            return;
        }
        ValueNumber knownNonnullOnBranch = null;
        if (this.isFactValid(fact)) {
            fact = this.propagateDerefSetsToMergeInputValues(fact, edge);
            if (this.invDataflow != null && (knownNonnullOnBranch = this.findValueKnownNonnullOnBranch(fact, edge)) != null) {
                fact = this.duplicateFact(fact);
                fact.clearDerefSet(knownNonnullOnBranch);
            }
        }
        boolean isBackEdge = edge.isBackwardInBytecode();
        Set<Integer> loopExitBranches = ClassContext.getLoopExitBranches(this.method, this.methodGen);
        assert (loopExitBranches != null);
        boolean sourceIsTopOfLoop = edge.sourceIsTopOfLoop(loopExitBranches);
        if (sourceIsTopOfLoop && edge.getType() == 0) {
            isBackEdge = true;
        }
        if (result.isTop() || fact.isBottom()) {
            this.copy(fact, result);
            if (ASSUME_NONZERO_TRIP_LOOPS && isBackEdge && !fact.isTop()) {
                result.resultsFromBackEdge = true;
            }
        } else if (ASSUME_NONZERO_TRIP_LOOPS && isBackEdge && !fact.isTop()) {
            result.unionWith(fact, ((ValueNumberAnalysis)this.vnaDataflow.getAnalysis()).getFactory());
            result.resultsFromBackEdge = true;
            if (DEBUG) {
                System.out.println("\n Forcing union of " + System.identityHashCode(result) + " due to backedge info");
                System.out.println("  result: " + result);
            }
        } else if (!result.isBottom() && !fact.isTop()) {
            if (ASSUME_NONZERO_TRIP_LOOPS && result.resultsFromBackEdge) {
                ++result.backEdgeUpdateCount;
                if (result.backEdgeUpdateCount < 10) {
                    if (DEBUG) {
                        System.out.println("\n Union update of " + System.identityHashCode(result) + " due to backedge info");
                    }
                    result.unionWith(fact, ((ValueNumberAnalysis)this.vnaDataflow.getAnalysis()).getFactory());
                    return;
                }
            }
            result.mergeWith(fact, knownNonnullOnBranch, ((ValueNumberAnalysis)this.vnaDataflow.getAnalysis()).getFactory());
            if (DEBUG) {
                System.out.println("  updated: " + System.identityHashCode(result));
                System.out.println("  result: " + result);
            }
        }
        if (DEBUG && isBackEdge && edge.getType() == 1) {
            System.out.println("  result: " + result);
        }
    }

    private UnconditionalValueDerefSet propagateDerefSetsToMergeInputValues(UnconditionalValueDerefSet fact, Edge edge) {
        ValueNumberFrame blockValueNumberFrame = (ValueNumberFrame)this.vnaDataflow.getResultFact((BasicBlock)edge.getSource());
        ValueNumberFrame targetValueNumberFrame = (ValueNumberFrame)this.vnaDataflow.getStartFact((BasicBlock)edge.getTarget());
        UnconditionalValueDerefSet originalFact = fact;
        fact = this.duplicateFact(fact);
        if (blockValueNumberFrame.isValid() && targetValueNumberFrame.isValid()) {
            int slots = 0;
            if (targetValueNumberFrame.getNumSlots() == blockValueNumberFrame.getNumSlots()) {
                slots = targetValueNumberFrame.getNumSlots();
            } else if (targetValueNumberFrame.getNumLocals() == blockValueNumberFrame.getNumLocals()) {
                slots = targetValueNumberFrame.getNumLocals();
            }
            if (slots > 0) {
                if (DEBUG) {
                    System.out.println("** Valid VNA frames for " + edge);
                    System.out.println("** Block : " + blockValueNumberFrame);
                    System.out.println("** Target: " + targetValueNumberFrame);
                }
                for (int i = 0; i < slots; ++i) {
                    ValueNumber targetVN;
                    ValueNumber blockVN = (ValueNumber)blockValueNumberFrame.getValue(i);
                    if (blockVN.equals(targetVN = (ValueNumber)targetValueNumberFrame.getValue(i))) continue;
                    fact.clearDerefSet(blockVN);
                    if (!originalFact.isUnconditionallyDereferenced(targetVN)) continue;
                    fact.setDerefSet(blockVN, originalFact.getUnconditionalDerefLocationSet(targetVN));
                }
                for (ValueNumber blockVN : blockValueNumberFrame.valueNumbersForLoads()) {
                    ValueNumber[] targetVNs;
                    AvailableLoad load = blockValueNumberFrame.getLoad(blockVN);
                    if (load == null || (targetVNs = targetValueNumberFrame.getAvailableLoad(load)) == null) continue;
                    for (ValueNumber targetVN : targetVNs) {
                        AvailableLoad targetLoad;
                        if (!targetVN.hasFlag(8) || !fact.isUnconditionallyDereferenced(targetVN) || fact.isUnconditionallyDereferenced(blockVN) || !load.equals(targetLoad = targetValueNumberFrame.getLoad(targetVN))) continue;
                        if (DEBUG) {
                            System.out.println("** Copy vn derefs for " + load + " from " + targetVN + " --> " + blockVN);
                            System.out.println("** block phi for " + System.identityHashCode(blockValueNumberFrame) + " is " + blockValueNumberFrame.phiNodeForLoads);
                            System.out.println("** target phi for " + System.identityHashCode(targetValueNumberFrame) + " is " + targetValueNumberFrame.phiNodeForLoads);
                        }
                        fact.setDerefSet(blockVN, fact.getUnconditionalDerefLocationSet(targetVN));
                    }
                }
            }
        }
        if (DEBUG) {
            System.out.println("Target VNF: " + targetValueNumberFrame);
            System.out.println("Block VNF: " + blockValueNumberFrame);
            System.out.println("fact: " + fact);
        }
        fact.cleanDerefSet(null, blockValueNumberFrame);
        return fact;
    }

    private UnconditionalValueDerefSet duplicateFact(UnconditionalValueDerefSet fact) {
        UnconditionalValueDerefSet copyOfFact = this.createFact();
        this.copy(fact, copyOfFact);
        fact = copyOfFact;
        return fact;
    }

    @CheckForNull
    private ValueNumber findValueKnownNonnullOnBranch(UnconditionalValueDerefSet fact, Edge edge) {
        IsNullValueFrame invFrame = (IsNullValueFrame)this.invDataflow.getResultFact((BasicBlock)edge.getSource());
        if (!invFrame.isValid()) {
            return null;
        }
        IsNullConditionDecision decision = invFrame.getDecision();
        if (decision == null) {
            return null;
        }
        IsNullValue inv = decision.getDecision(edge.getType());
        if (inv == null || !inv.isDefinitelyNotNull()) {
            return null;
        }
        ValueNumber value = decision.getValue();
        if (DEBUG) {
            System.out.println("Value number " + value + " is known nonnull on " + edge);
        }
        return value;
    }

    private boolean isExceptionEdge(Edge edge) {
        boolean isExceptionEdge = edge.isExceptionEdge();
        if (isExceptionEdge) {
            if (DEBUG) {
                System.out.println("NOT Ignoring " + edge);
            }
            return true;
        }
        if (edge.getType() != 0) {
            return false;
        }
        InstructionHandle h = ((BasicBlock)edge.getSource()).getLastInstruction();
        return h != null && h.getInstruction() instanceof IFNONNULL && UnconditionalValueDerefAnalysis.isNullCheck(h, this.methodGen.getConstantPool());
    }

    @Override
    public boolean same(UnconditionalValueDerefSet fact1, UnconditionalValueDerefSet fact2) {
        return fact1.resultsFromBackEdge || fact1.isSameAs(fact2);
    }

    @Override
    public void startIteration() {
    }

    @Override
    public int getLastUpdateTimestamp(UnconditionalValueDerefSet fact) {
        return fact.getLastUpdateTimestamp();
    }

    @Override
    public void setLastUpdateTimestamp(UnconditionalValueDerefSet fact, int lastUpdate) {
        fact.setLastUpdateTimestamp(lastUpdate);
    }
}

