/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.annotations.Confidence;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnnotationDatabase;
import edu.umd.cs.findbugs.ba.CheckReturnValueAnnotation;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.meta.When;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.JavaClass;

public class CheckReturnAnnotationDatabase
extends AnnotationDatabase<CheckReturnValueAnnotation> {
    private static final String JAVA_MATH_BIG_INTEGER = "java.math.BigInteger";
    private static final String SUBMIT = "submit";
    private static final String REDIRECT_ERROR_STREAM = "redirectErrorStream";
    private static final String JAVA_LANG_PROCESS_BUILDER = "java.lang.ProcessBuilder";
    private static final String JAVA_NET_INET_ADDRESS = "java.net.InetAddress";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String LJAVA_LANG_STRING_V = "(Ljava/lang/String;)V";
    private static final String JAVA_MATH_BIG_DECIMAL = "java.math.BigDecimal";
    private static final String LJAVA_LANG_OBJECT_Z = "(Ljava/lang/Object;)Z";
    private static final String JAVA_UTIL_CONCURRENT_BLOCKING_QUEUE = "java.util.concurrent.BlockingQueue";
    private static final String OFFER = "offer";
    private static final String JAVA_UTIL_CONCURRENT_LOCKS_LOCK = "java.util.concurrent.locks.Lock";
    private static final String J_LJAVA_UTIL_CONCURRENT_TIME_UNIT_Z = "(JLjava/util/concurrent/TimeUnit;)Z";
    private static final String JAVA_UTIL_CONCURRENT_LOCKS_CONDITION = "java.util.concurrent.locks.Condition";
    private static final String JAVA_IO_FILE = "java.io.File";
    private JavaClass throwableClass;
    private JavaClass threadClass;
    @SlashedClassName
    private static final String NAME_OF_CHECK_RETURN_NULL_SPOTBUGS = "edu/umd/cs/findbugs/annotations/CheckReturnValue";
    @SlashedClassName
    private static final String NAME_OF_CHECK_RETURN_NULL_JSR305 = "javax/annotation/CheckReturnValue";
    @SlashedClassName
    private static final String NAME_OF_CHECK_RETURN_NULL_ERRORPRONE = "com/google/errorprone/annotations/CheckReturnValue";
    @SlashedClassName
    private static final String NAME_OF_CAN_IGNORE_RETURN_VALUE = "com/google/errorprone/annotations/CanIgnoreReturnValue";
    private final Map<String, CheckReturnValueAnnotation> packageInfoCache = new HashMap<String, CheckReturnValueAnnotation>();

    public CheckReturnAnnotationDatabase() {
        this.setAddClassOnly(true);
        this.loadAuxiliaryAnnotations();
        this.setAddClassOnly(false);
    }

    @Override
    public void loadAuxiliaryAnnotations() {
        if (IGNORE_BUILTIN_ANNOTATIONS) {
            return;
        }
        boolean missingClassWarningsSuppressed = AnalysisContext.currentAnalysisContext().setMissingClassWarningsSuppressed(true);
        this.addMethodAnnotation("java.util.Iterator", "hasNext", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW);
        this.addMethodAnnotation(JAVA_IO_FILE, "createNewFile", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation(JAVA_IO_FILE, "delete", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation(JAVA_IO_FILE, "mkdir", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation(JAVA_IO_FILE, "mkdirs", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation(JAVA_IO_FILE, "renameTo", "(Ljava/io/File;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation(JAVA_IO_FILE, "setLastModified", "(J)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation(JAVA_IO_FILE, "setReadOnly", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation(JAVA_IO_FILE, "setWritable", "(ZZ)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.Enumeration", "hasMoreElements", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation("java.security.MessageDigest", "digest", "([B)[B", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation("java.util.concurrent.locks.ReadWriteLock", "readLock", "()Ljava/util/concurrent/locks/Lock;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation("java.util.concurrent.locks.ReadWriteLock", "writeLock", "()Ljava/util/concurrent/locks/Lock;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation(JAVA_UTIL_CONCURRENT_LOCKS_CONDITION, "await", J_LJAVA_UTIL_CONCURRENT_TIME_UNIT_Z, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.concurrent.CountDownLatch", "await", J_LJAVA_UTIL_CONCURRENT_TIME_UNIT_Z, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation(JAVA_UTIL_CONCURRENT_LOCKS_CONDITION, "awaitUntil", "(Ljava/util/Date;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation(JAVA_UTIL_CONCURRENT_LOCKS_CONDITION, "awaitNanos", "(J)J", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.concurrent.Semaphore", "tryAcquire", J_LJAVA_UTIL_CONCURRENT_TIME_UNIT_Z, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation("java.util.concurrent.Semaphore", "tryAcquire", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation(JAVA_UTIL_CONCURRENT_LOCKS_LOCK, "tryLock", J_LJAVA_UTIL_CONCURRENT_TIME_UNIT_Z, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation(JAVA_UTIL_CONCURRENT_LOCKS_LOCK, "newCondition", "()Ljava/util/concurrent/locks/Condition;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation(JAVA_UTIL_CONCURRENT_LOCKS_LOCK, "tryLock", "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation(JAVA_UTIL_CONCURRENT_BLOCKING_QUEUE, OFFER, "(Ljava/lang/Object;JLjava/util/concurrent/TimeUnit;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation(JAVA_UTIL_CONCURRENT_BLOCKING_QUEUE, OFFER, LJAVA_LANG_OBJECT_Z, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.concurrent.ConcurrentLinkedQueue", OFFER, LJAVA_LANG_OBJECT_Z, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation("java.util.concurrent.DelayQueue", OFFER, LJAVA_LANG_OBJECT_Z, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation("java.util.concurrent.LinkedBlockingQueue", OFFER, LJAVA_LANG_OBJECT_Z, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.LinkedList", OFFER, LJAVA_LANG_OBJECT_Z, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation("java.util.Queue", OFFER, LJAVA_LANG_OBJECT_Z, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.concurrent.ArrayBlockingQueue", OFFER, LJAVA_LANG_OBJECT_Z, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.concurrent.SynchronousQueue", OFFER, LJAVA_LANG_OBJECT_Z, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation("java.util.PriorityQueue", OFFER, LJAVA_LANG_OBJECT_Z, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation("java.util.concurrent.PriorityBlockingQueue", OFFER, LJAVA_LANG_OBJECT_Z, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addWarningAboutSubmit(ExecutorService.class);
        this.addWarningAboutSubmit(ThreadPoolExecutor.class);
        this.addWarningAboutSubmit(ScheduledThreadPoolExecutor.class);
        this.addWarningAboutSubmit(AbstractExecutorService.class);
        this.addMethodAnnotation(JAVA_UTIL_CONCURRENT_BLOCKING_QUEUE, "poll", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation("java.util.Queue", "poll", "()Ljava/lang/Object;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW);
        this.addDefaultMethodAnnotation(JAVA_LANG_STRING, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation(JAVA_LANG_STRING, "getBytes", "(Ljava/lang/String;)[B", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation(JAVA_LANG_STRING, "charAt", "(I)C", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW);
        this.addMethodAnnotation(JAVA_LANG_STRING, "toString", "()Ljava/lang/String;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW);
        this.addMethodAnnotation(JAVA_LANG_STRING, "length", "()I", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW);
        this.addMethodAnnotation(JAVA_LANG_STRING, "matches", "(Ljava/lang/String;)Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW);
        this.addMethodAnnotation(JAVA_LANG_STRING, "intern", "()Ljava/lang/String;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation(JAVA_LANG_STRING, "<init>", "([BLjava/lang/String;)V", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation(JAVA_LANG_STRING, "<init>", LJAVA_LANG_STRING_V, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW);
        this.addMethodAnnotation(JAVA_LANG_STRING, "<init>", "()V", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW);
        this.addDefaultMethodAnnotation(JAVA_MATH_BIG_DECIMAL, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation(JAVA_MATH_BIG_DECIMAL, "inflate", "()Ljava/math/BigInteger;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation(JAVA_MATH_BIG_DECIMAL, "precision", "()I", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation(JAVA_MATH_BIG_DECIMAL, "toBigIntegerExact", "()Ljava/math/BigInteger;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation(JAVA_MATH_BIG_DECIMAL, "longValueExact", "()J", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation(JAVA_MATH_BIG_DECIMAL, "intValueExact", "()I", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation(JAVA_MATH_BIG_DECIMAL, "shortValueExact", "()S", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation(JAVA_MATH_BIG_DECIMAL, "byteValueExact", "()B", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation(JAVA_MATH_BIG_DECIMAL, "<init>", LJAVA_LANG_STRING_V, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation(JAVA_MATH_BIG_DECIMAL, "intValue", "()I", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation(JAVA_MATH_BIG_DECIMAL, "stripZerosToMatchScale", "(J)Ljava/math/BigDecimal;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addDefaultMethodAnnotation(JAVA_MATH_BIG_INTEGER, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH);
        this.addMethodAnnotation(JAVA_MATH_BIG_INTEGER, "addOne", "([IIII)I", true, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation(JAVA_MATH_BIG_INTEGER, "subN", "([I[II)I", true, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation(JAVA_MATH_BIG_INTEGER, "<init>", LJAVA_LANG_STRING_V, false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addDefaultMethodAnnotation("java.sql.Connection", CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addDefaultMethodAnnotation(JAVA_NET_INET_ADDRESS, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation(JAVA_NET_INET_ADDRESS, "getByName", "(Ljava/lang/String;)Ljava/net/InetAddress;", true, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation(JAVA_NET_INET_ADDRESS, "getAllByName", "(Ljava/lang/String;)[Ljava/net/InetAddress;", true, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addMethodAnnotation(JAVA_LANG_PROCESS_BUILDER, REDIRECT_ERROR_STREAM, "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation(JAVA_LANG_PROCESS_BUILDER, REDIRECT_ERROR_STREAM, "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation(JAVA_LANG_PROCESS_BUILDER, REDIRECT_ERROR_STREAM, "()Z", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation("com.google.common.base.Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;", true, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE);
        this.addDefaultMethodAnnotation("jsr166z.forkjoin.ParallelArray", CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addDefaultMethodAnnotation("jsr166z.forkjoin.ParallelLongArray", CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addDefaultMethodAnnotation("jsr166z.forkjoin.ParallelDoubleArray", CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation(Statement.class, "executeQuery", "(Ljava/lang/String;)Ljava/sql/ResultSet;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        this.addMethodAnnotation(PreparedStatement.class, "executeQuery", "()Ljava/sql/ResultSet;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM);
        AnalysisContext.currentAnalysisContext().setMissingClassWarningsSuppressed(missingClassWarningsSuppressed);
        try {
            this.throwableClass = Repository.lookupClass((String)"java.lang.Throwable");
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        try {
            this.threadClass = Repository.lookupClass((String)"java.lang.Thread");
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
    }

    private void addWarningAboutSubmit(Class<? extends ExecutorService> c) {
        this.addMethodAnnotation(c.getName(), SUBMIT, "(Ljava/util/concurrent/Callable;)Ljava/util/concurrent/Future;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
        this.addMethodAnnotation(c.getName(), SUBMIT, "(Ljava/lang/Runnable;)Ljava/util/concurrent/Future;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW_BAD_PRACTICE);
        this.addMethodAnnotation(c.getName(), SUBMIT, "(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;", false, CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE);
    }

    @Nullable
    private CheckReturnValueAnnotation getResolvedAnnotationOnConstructor(XMethod m) {
        try {
            if (this.throwableClass != null && Repository.instanceOf((String)m.getClassName(), (JavaClass)this.throwableClass)) {
                return CheckReturnValueAnnotation.CHECK_RETURN_VALUE_VERY_HIGH;
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        if ("java.lang.Thread".equals(m.getClassName())) {
            return CheckReturnValueAnnotation.CHECK_RETURN_VALUE_VERY_HIGH;
        }
        try {
            if (this.threadClass != null && Repository.instanceOf((String)m.getClassName(), (JavaClass)this.threadClass)) {
                return CheckReturnValueAnnotation.CHECK_RETURN_VALUE_LOW;
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        return null;
    }

    @Override
    public CheckReturnValueAnnotation getResolvedAnnotation(Object o, boolean getMinimal) {
        CheckReturnValueAnnotation annotationOnMethod;
        if (!(o instanceof XMethod)) {
            return null;
        }
        XMethod m = (XMethod)o;
        if (m.getName().startsWith("access$")) {
            return null;
        }
        if ("<init>".equals(m.getName())) {
            CheckReturnValueAnnotation a = this.getResolvedAnnotationOnConstructor(m);
            if (a != null) {
                return a;
            }
        } else {
            if ("equals".equals(m.getName()) && LJAVA_LANG_OBJECT_Z.equals(m.getSignature()) && !m.isStatic()) {
                return CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM;
            }
            if (m.getSignature().endsWith(")Ljava/lang/String;") && ("java.lang.StringBuffer".equals(m.getClassName()) || "java.lang.StringBuilder".equals(m.getClassName()))) {
                return CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM;
            }
        }
        if ((annotationOnMethod = (CheckReturnValueAnnotation)super.getResolvedAnnotation(o, getMinimal)) == null) {
            return this.packageInfoCache.computeIfAbsent(m.getPackageName(), this::parsePackage);
        }
        return annotationOnMethod;
    }

    @CheckForNull
    private CheckReturnValueAnnotation parsePackage(@DottedClassName String packageName) {
        JavaClass clazz;
        String className = ClassName.toSlashedClassName(packageName) + "/package-info";
        ClassDescriptor descriptor = DescriptorFactory.createClassDescriptor(className);
        try {
            clazz = AnalysisContext.currentAnalysisContext().lookupClass(descriptor);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        for (AnnotationEntry entry : clazz.getAnnotationEntries()) {
            String type;
            switch (type = entry.getAnnotationType()) {
                case "edu/umd/cs/findbugs/annotations/CheckReturnValue": {
                    return this.createSpotBugsAnnotation(entry);
                }
                case "javax/annotation/CheckReturnValue": {
                    return this.createJSR305Annotation(entry);
                }
                case "com/google/errorprone/annotations/CheckReturnValue": {
                    return CheckReturnValueAnnotation.createFor(When.ALWAYS);
                }
                case "com/google/errorprone/annotations/CanIgnoreReturnValue": {
                    return CheckReturnValueAnnotation.createFor(When.NEVER);
                }
            }
        }
        return null;
    }

    private CheckReturnValueAnnotation createJSR305Annotation(AnnotationEntry entry) {
        for (ElementValuePair pair : entry.getElementValuePairs()) {
            if (!pair.getNameString().equals("when")) continue;
            return CheckReturnValueAnnotation.createFor(When.valueOf((String)pair.getValue().stringifyValue()));
        }
        return CheckReturnValueAnnotation.createFor(When.ALWAYS);
    }

    private CheckReturnValueAnnotation createSpotBugsAnnotation(AnnotationEntry entry) {
        for (ElementValuePair pair : entry.getElementValuePairs()) {
            if (!pair.getNameString().equals("confidence")) continue;
            return CheckReturnValueAnnotation.parse(pair.getValue().stringifyValue());
        }
        return CheckReturnValueAnnotation.parse(Confidence.MEDIUM.name());
    }
}

