/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pmtiles.gui.layers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.apache.commons.jcs3.access.behavior.ICacheAccess;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderJob;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.data.imagery.TileJobOptions;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public abstract class JCSCachedTileLoaderJob<K, V extends CacheEntry>
implements ICachedLoaderJob<K> {
    protected static final long DEFAULT_EXPIRE_TIME = TimeUnit.DAYS.toMillis(7L);
    protected static final long EXPIRE_TIME_SERVER_LIMIT = TimeUnit.DAYS.toMillis(28L);
    protected static final long ABSOLUTE_EXPIRE_TIME_LIMIT = TimeUnit.DAYS.toMillis(365L);
    public static final IntegerProperty THREAD_LIMIT = new IntegerProperty("cache.jcs.max_threads", 10);
    private static final ThreadPoolExecutor DEFAULT_DOWNLOAD_JOB_DISPATCHER = new ThreadPoolExecutor(1, (int)THREAD_LIMIT.get(), 30L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), Utils.newThreadFactory((String)"JCS-downloader-%d", (int)5));
    private static final ConcurrentMap<String, Set<ICachedLoaderListener>> inProgress = new ConcurrentHashMap<String, Set<ICachedLoaderListener>>();
    private static final ConcurrentMap<String, Boolean> useHead = new ConcurrentHashMap<String, Boolean>();
    protected final long now;
    @ModifiedFromJosm(value="Visibility")
    protected final ICacheAccess<K, V> cache;
    private ICacheElement<K, V> cacheElement;
    protected V cacheData;
    protected CacheEntryAttributes attributes;
    private final int connectTimeout;
    private final int readTimeout;
    private final Map<String, String> headers;
    private final ThreadPoolExecutor downloadJobExecutor;
    private Runnable finishTask;
    private boolean force;
    private final long minimumExpiryTime;

    protected JCSCachedTileLoaderJob(ICacheAccess<K, V> cache, TileJobOptions options, ThreadPoolExecutor downloadJobExecutor) {
        CheckParameterUtil.ensureParameterNotNull(cache, (String)"cache");
        this.cache = cache;
        this.now = System.currentTimeMillis();
        this.connectTimeout = options.getConnectionTimeout();
        this.readTimeout = options.getReadTimeout();
        this.headers = options.getHeaders();
        this.downloadJobExecutor = downloadJobExecutor;
        this.minimumExpiryTime = TimeUnit.SECONDS.toMillis(options.getMinimumExpiryTime());
    }

    protected JCSCachedTileLoaderJob(ICacheAccess<K, V> cache, TileJobOptions options) {
        this(cache, options, DEFAULT_DOWNLOAD_JOB_DISPATCHER);
    }

    private void ensureCacheElement() {
        if (this.cacheElement == null && this.getCacheKey() != null) {
            this.cacheElement = this.cache.getCacheElement(this.getCacheKey());
            if (this.cacheElement != null) {
                this.attributes = (CacheEntryAttributes)this.cacheElement.getElementAttributes();
                this.cacheData = (CacheEntry)this.cacheElement.getVal();
            }
        }
    }

    public V get() {
        this.ensureCacheElement();
        return this.cacheData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(ICachedLoaderListener listener, boolean force) throws IOException {
        this.force = force;
        boolean first = false;
        URL url = this.getUrl();
        String deduplicationKey = null;
        if (url != null) {
            deduplicationKey = url.toString();
        }
        if (deduplicationKey == null) {
            Logging.warn((String)"No url returned for: {0}, skipping", (Object[])new Object[]{this.getCacheKey()});
            throw new IllegalArgumentException("No url returned");
        }
        JCSCachedTileLoaderJob jCSCachedTileLoaderJob = this;
        synchronized (jCSCachedTileLoaderJob) {
            first = !inProgress.containsKey(deduplicationKey);
        }
        inProgress.computeIfAbsent(deduplicationKey, k -> ConcurrentHashMap.newKeySet()).add(listener);
        if (first || force) {
            Logging.debug((String)"JCS - Submitting job for execution for url: {0}", (Object[])new Object[]{this.getUrlNoException()});
            this.downloadJobExecutor.execute((Runnable)((Object)this));
        }
    }

    protected void executionFinished() {
        if (this.finishTask != null) {
            this.finishTask.run();
        }
    }

    protected boolean isObjectLoadable() {
        if (this.cacheData == null) {
            return false;
        }
        return this.cacheData.getContent().length > 0;
    }

    protected boolean cacheAsEmpty(Map<String, List<String>> headerFields, int responseCode) {
        return this.attributes.getResponseCode() < 500;
    }

    protected String getServerKey() {
        try {
            return this.getUrl().getHost();
        }
        catch (IOException e) {
            Logging.trace((Throwable)e);
            return null;
        }
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        String oldName = currentThread.getName();
        currentThread.setName("JCS Downloading: " + this.getUrlNoException());
        Logging.debug((String)"JCS - starting fetch of url: {0} ", (Object[])new Object[]{this.getUrlNoException()});
        this.ensureCacheElement();
        try {
            if (!this.force && this.cacheElement != null && this.isCacheElementValid() && this.isObjectLoadable()) {
                Logging.debug((String)"JCS - Returning object from cache: {0}", (Object[])new Object[]{this.getCacheKey()});
                this.finishLoading(ICachedLoaderListener.LoadResult.SUCCESS);
                return;
            }
            if (this.loadObject()) {
                this.finishLoading(ICachedLoaderListener.LoadResult.SUCCESS);
            } else if (this.isObjectLoadable()) {
                this.finishLoading(ICachedLoaderListener.LoadResult.SUCCESS);
                Logging.debug((String)"JCS - found stale object in cache: {0}", (Object[])new Object[]{this.getUrlNoException()});
            } else {
                this.finishLoading(ICachedLoaderListener.LoadResult.FAILURE);
            }
        }
        finally {
            this.executionFinished();
            currentThread.setName(oldName);
        }
    }

    private void finishLoading(ICachedLoaderListener.LoadResult result) {
        Set listeners;
        try {
            listeners = (Set)inProgress.remove(this.getUrl().toString());
        }
        catch (IOException e) {
            listeners = null;
            Logging.trace((Throwable)e);
        }
        if (listeners == null) {
            Logging.warn((String)"Listener not found for URL: {0}. Listener not notified!", (Object[])new Object[]{this.getUrlNoException()});
            return;
        }
        for (ICachedLoaderListener l : listeners) {
            l.loadingFinished(this.cacheData, this.attributes, result);
        }
    }

    protected boolean isCacheElementValid() {
        long expires = this.attributes.getExpirationTime();
        if (expires != 0L) {
            if (this.now > (expires = Math.min(expires, this.attributes.getCreateTime() + Math.max(EXPIRE_TIME_SERVER_LIMIT, this.minimumExpiryTime)))) {
                Logging.debug((String)"JCS - Object {0} has expired -> valid to {1}, now is: {2}", (Object[])new Object[]{this.getUrlNoException(), Long.toString(expires), Long.toString(this.now)});
                return false;
            }
        } else {
            if (this.attributes.getLastModification() > 0L && this.now - this.attributes.getLastModification() > Math.max(DEFAULT_EXPIRE_TIME, this.minimumExpiryTime)) {
                Logging.debug((String)"JCS - Object has expired, maximum file age reached {0}", (Object[])new Object[]{this.getUrlNoException()});
                return false;
            }
            if (this.now - this.attributes.getCreateTime() > Math.max(DEFAULT_EXPIRE_TIME, this.minimumExpiryTime)) {
                Logging.debug((String)"JCS - Object has expired, maximum time since object creation reached {0}", (Object[])new Object[]{this.getUrlNoException()});
                return false;
            }
        }
        return true;
    }

    @ModifiedFromJosm(value="visibility")
    protected boolean loadObject() {
        URL url;
        if (this.attributes == null) {
            this.attributes = new CacheEntryAttributes();
        }
        if ((url = this.getUrlNoException()) == null) {
            return false;
        }
        if (url.getProtocol().contains("http")) {
            return this.loadObjectHttp();
        }
        if (url.getProtocol().contains("file")) {
            return this.loadObjectFile(url);
        }
        return false;
    }

    private boolean loadObjectFile(URL url) {
        boolean bl;
        block9: {
            String fileName = url.toExternalForm();
            File file = new File(fileName.substring("file:/".length() - 1));
            if (!file.exists()) {
                file = new File(fileName.substring("file://".length() - 1));
            }
            InputStream fileInputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                this.cacheData = this.createCacheEntry(Utils.readBytesFromStream((InputStream)fileInputStream));
                this.cache.put(this.getCacheKey(), this.cacheData, (IElementAttributes)this.attributes);
                bl = true;
                if (fileInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logging.error((Throwable)e);
                    this.attributes.setError((Exception)e);
                    this.attributes.setException((Exception)e);
                    return false;
                }
            }
            fileInputStream.close();
        }
        return bl;
    }

    private boolean loadObjectHttp() {
        try {
            HttpClient.Response urlConn;
            if (this.isObjectLoadable() && Boolean.TRUE.equals(useHead.get(this.getServerKey())) && this.isCacheValidUsingHead()) {
                Logging.debug((String)"JCS - cache entry verified using HEAD request: {0}", (Object[])new Object[]{this.getUrl()});
                return true;
            }
            Logging.debug((String)"JCS - starting HttpClient GET request for URL: {0}", (Object[])new Object[]{this.getUrl()});
            HttpClient request = this.getRequest("GET");
            if (this.isObjectLoadable() && this.now - this.attributes.getLastModification() <= ABSOLUTE_EXPIRE_TIME_LIMIT) {
                request.setIfModifiedSince(this.attributes.getLastModification());
            }
            if (this.isObjectLoadable() && this.attributes.getEtag() != null) {
                request.setHeader("If-None-Match", this.attributes.getEtag());
            }
            if ((urlConn = request.connect()).getResponseCode() == 304) {
                Logging.debug((String)"JCS - If-Modified-Since/ETag test: local version is up to date: {0}", (Object[])new Object[]{this.getUrl()});
                this.attributes = this.parseHeaders(urlConn);
                this.cache.put(this.getCacheKey(), this.cacheData, (IElementAttributes)this.attributes);
                return true;
            }
            if (this.isObjectLoadable() && (this.attributes.getEtag() != null && this.attributes.getEtag().equals(urlConn.getHeaderField("ETag")) || this.attributes.getLastModification() == urlConn.getLastModified())) {
                String serverKey = this.getServerKey();
                Logging.info((String)"JCS - Host: {0} found not to return 304 codes for If-Modified-Since or If-None-Match headers", (Object[])new Object[]{serverKey});
                useHead.put(serverKey, Boolean.TRUE);
            }
            this.attributes = this.parseHeaders(urlConn);
            for (int i = 0; i < 5; ++i) {
                if (urlConn.getResponseCode() != 503) {
                    byte[] raw;
                    this.attributes.setResponseCode(urlConn.getResponseCode());
                    if (urlConn.getResponseCode() == 200) {
                        raw = Utils.readBytesFromStream((InputStream)urlConn.getContent());
                    } else {
                        raw = new byte[]{};
                        try {
                            String detectErrorMessage;
                            String data = urlConn.fetchContent();
                            if (!data.isEmpty() && (detectErrorMessage = this.detectErrorMessage(data)) != null) {
                                this.attributes.setErrorMessage(detectErrorMessage);
                            }
                        }
                        catch (IOException e) {
                            Logging.warn((Throwable)e);
                        }
                    }
                    if (this.isResponseLoadable(urlConn.getHeaderFields(), urlConn.getResponseCode(), raw)) {
                        this.cacheData = this.createCacheEntry(raw);
                        this.cache.put(this.getCacheKey(), this.cacheData, (IElementAttributes)this.attributes);
                        Logging.debug((String)"JCS - downloaded key: {0}, length: {1}, url: {2}", (Object[])new Object[]{this.getCacheKey(), raw.length, this.getUrl()});
                        return true;
                    }
                    if (this.cacheAsEmpty(urlConn.getHeaderFields(), urlConn.getResponseCode())) {
                        this.cacheData = this.createCacheEntry(new byte[0]);
                        this.cache.put(this.getCacheKey(), this.cacheData, (IElementAttributes)this.attributes);
                        Logging.debug((String)"JCS - Caching empty object {0}", (Object[])new Object[]{this.getUrl()});
                        return true;
                    }
                    Logging.debug((String)"JCS - failure during load - response is not loadable nor cached as empty");
                    return false;
                }
                Thread.sleep(5000L + (long)new SecureRandom().nextInt(5000));
            }
        }
        catch (FileNotFoundException e) {
            boolean doCache;
            Logging.debug((String)"JCS - Caching empty object as server returned 404 for: {0}", (Object[])new Object[]{this.getUrlNoException()});
            this.attributes.setResponseCode(404);
            this.attributes.setError((Exception)e);
            this.attributes.setException((Exception)e);
            boolean bl = doCache = this.isResponseLoadable(null, 404, null) || this.cacheAsEmpty(Collections.emptyMap(), 404);
            if (doCache) {
                this.cacheData = this.createCacheEntry(new byte[0]);
                this.cache.put(this.getCacheKey(), this.cacheData, (IElementAttributes)this.attributes);
            }
            return doCache;
        }
        catch (IOException e) {
            Logging.debug((String)"JCS - IOException during communication with server for: {0}", (Object[])new Object[]{this.getUrlNoException()});
            if (this.isObjectLoadable()) {
                return true;
            }
            this.attributes.setError((Exception)e);
            this.attributes.setException((Exception)e);
            this.attributes.setResponseCode(599);
            return false;
        }
        catch (InterruptedException e) {
            this.attributes.setError((Exception)e);
            this.attributes.setException((Exception)e);
            Logging.logWithStackTrace((Level)Logging.LEVEL_WARN, (Throwable)e, (String)"JCS - Exception during download {0}", (Object[])new Object[]{this.getUrlNoException()});
            Thread.currentThread().interrupt();
        }
        Logging.warn((String)"JCS - Silent failure during download: {0}", (Object[])new Object[]{this.getUrlNoException()});
        return false;
    }

    public String detectErrorMessage(String data) {
        Matcher m = HttpClient.getTomcatErrorMatcher((String)data);
        return m.matches() ? m.group(1).replace("'", "''") : null;
    }

    protected boolean isResponseLoadable(Map<String, List<String>> headerFields, int responseCode, byte[] raw) {
        return raw != null && raw.length != 0 && responseCode < 400;
    }

    protected abstract V createCacheEntry(byte[] var1);

    protected CacheEntryAttributes parseHeaders(HttpClient.Response urlConn) {
        CacheEntryAttributes ret = new CacheEntryAttributes();
        Long expiration = 0L;
        String cacheControl = urlConn.getHeaderField("Cache-Control");
        if (cacheControl != null) {
            for (String token : cacheControl.split(",", -1)) {
                try {
                    if (token.startsWith("max-age=")) {
                        expiration = Math.max(expiration, TimeUnit.SECONDS.toMillis(Long.parseLong(token.substring("max-age=".length()))) + System.currentTimeMillis());
                    }
                    if (!token.startsWith("s-max-age=")) continue;
                    expiration = Math.max(expiration, TimeUnit.SECONDS.toMillis(Long.parseLong(token.substring("s-max-age=".length()))) + System.currentTimeMillis());
                }
                catch (NumberFormatException e) {
                    Logging.trace((Throwable)e);
                }
            }
        }
        if (expiration.equals(0L)) {
            expiration = urlConn.getExpiration();
        }
        if (expiration.equals(0L)) {
            expiration = System.currentTimeMillis() + DEFAULT_EXPIRE_TIME;
        }
        ret.setExpirationTime(Math.max(this.minimumExpiryTime + System.currentTimeMillis(), expiration));
        ret.setLastModification(this.now);
        ret.setEtag(urlConn.getHeaderField("ETag"));
        return ret;
    }

    private HttpClient getRequest(String requestMethod) throws IOException {
        HttpClient urlConn = HttpClient.create((URL)this.getUrl(), (String)requestMethod);
        urlConn.setAccept("text/html, image/png, image/jpeg, image/gif, */*");
        urlConn.setReadTimeout(this.readTimeout);
        urlConn.setConnectTimeout(this.connectTimeout);
        if (this.headers != null) {
            urlConn.setHeaders(this.headers);
        }
        boolean noCache = this.force || Utils.getJavaVersion() == 8 && Utils.isRunningJavaWebStart();
        urlConn.useCache(!noCache);
        return urlConn;
    }

    private boolean isCacheValidUsingHead() throws IOException {
        boolean ret;
        HttpClient.Response urlConn = this.getRequest("HEAD").connect();
        long lastModified = urlConn.getLastModified();
        boolean bl = ret = this.attributes.getEtag() != null && this.attributes.getEtag().equals(urlConn.getHeaderField("ETag")) || lastModified != 0L && lastModified <= this.attributes.getLastModification();
        if (ret) {
            this.attributes = this.parseHeaders(urlConn);
            this.cache.put(this.getCacheKey(), this.cacheData, (IElementAttributes)this.attributes);
        }
        return ret;
    }

    public void cancelOutstandingTasks() {
        for (Runnable r : this.downloadJobExecutor.getQueue()) {
            if (!this.downloadJobExecutor.remove(r) || !(r instanceof org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob)) continue;
            ((org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob)r).handleJobCancellation();
        }
    }

    public void setFinishedTask(Runnable runnable) {
        this.finishTask = runnable;
    }

    public void handleJobCancellation() {
        this.finishLoading(ICachedLoaderListener.LoadResult.CANCELED);
    }

    private URL getUrlNoException() {
        try {
            return this.getUrl();
        }
        catch (IOException e) {
            Logging.trace((Throwable)e);
            return null;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.FIELD})
    static @interface ModifiedFromJosm {
        public String value() default "";
    }
}

