/*
 * Decompiled with CFR 0.152.
 */
package relcontext.relationfix;

import java.util.ArrayList;
import java.util.HashSet;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import relcontext.relationfix.RelationFixer;

public class MultipolygonFixer
extends RelationFixer {
    public MultipolygonFixer() {
        super("multipolygon");
    }

    protected MultipolygonFixer(String ... types) {
        super(types);
    }

    @Override
    public boolean isRelationGood(Relation rel) {
        for (RelationMember m : rel.getMembers()) {
            if (!m.getType().equals((Object)OsmPrimitiveType.WAY) || "outer".equals(m.getRole()) || "inner".equals(m.getRole())) continue;
            this.setWarningMessage(I18n.tr((String)"Way without ''inner'' or ''outer'' role found", (Object[])new Object[0]));
            return false;
        }
        this.clearWarningMessage();
        return true;
    }

    @Override
    public Command fixRelation(Relation rel) {
        Relation rr = this.fixMultipolygonRoles(rel);
        if (rr != null) {
            DataSet ds = (DataSet)Utils.firstNonNull((Object[])new DataSet[]{rel.getDataSet(), MainApplication.getLayerManager().getEditDataSet()});
            return new ChangeCommand(ds, (OsmPrimitive)rel, (OsmPrimitive)rr);
        }
        return null;
    }

    protected Relation fixMultipolygonRoles(Relation source) {
        MultipolygonBuilder mpc = new MultipolygonBuilder();
        ArrayList ways = new ArrayList(source.getMemberPrimitives(Way.class));
        String error = mpc.makeFromWays(ways);
        if (error != null) {
            return null;
        }
        Relation r = new Relation(source);
        boolean fixed = false;
        HashSet outerWays = new HashSet();
        for (Object poly : mpc.outerWays) {
            outerWays.addAll(((MultipolygonBuilder.JoinedPolygon)poly).ways);
        }
        HashSet innerWays = new HashSet();
        for (MultipolygonBuilder.JoinedPolygon poly : mpc.innerWays) {
            innerWays.addAll(poly.ways);
        }
        for (int i = 0; i < r.getMembersCount(); ++i) {
            RelationMember m = r.getMember(i);
            if (!m.isWay()) continue;
            Way way = m.getWay();
            String role = null;
            if (outerWays.contains(way)) {
                role = "outer";
            } else if (innerWays.contains(way)) {
                role = "inner";
            }
            if (role == null || role.equals(m.getRole())) continue;
            r.setMember(i, new RelationMember(role, (OsmPrimitive)way));
            fixed = true;
        }
        return fixed ? r : null;
    }
}

