/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.imageinfo;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddTagToPrimitiveAction
extends AbstractAction {
    private static final long serialVersionUID = -2134831346322019333L;
    private Tag tag;
    private AbstractPrimitive target;

    public AddTagToPrimitiveAction(String name) {
        super(name, ImageProvider.get((String)"dialogs/add", (ImageProvider.ImageSizes)ImageProvider.ImageSizes.SMALLICON));
    }

    public void setTag(Tag tag) {
        this.tag = tag;
        this.updateEnabled();
    }

    public void setTarget(AbstractPrimitive target) {
        this.target = target;
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.setEnabled(this.tag != null && this.target != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.target != null && this.tag != null) {
            int conflictResolution = 0;
            if (this.target.hasKey(this.tag.getKey()) && !this.target.hasTag(this.tag.getKey(), this.tag.getValue())) {
                conflictResolution = JOptionPane.showConfirmDialog((Component)MainApplication.getMainFrame(), "<html>" + I18n.tr((String)"A tag with key <i>{0}</i> is already present on the selected OSM object.", (Object[])new Object[]{this.tag.getKey()}) + "<br>" + I18n.tr((String)"Do you really want to replace the current value <i>{0}</i> with the new value <i>{1}</i>?", (Object[])new Object[]{this.target.get(this.tag.getKey()), this.tag.getValue()}) + "</html>", I18n.tr((String)"Tag conflict", (Object[])new Object[0]), 0, 2);
            }
            if (0 == conflictResolution) {
                this.target.put(this.tag);
                this.target.setModified(true);
            }
        }
    }
}

