/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cache;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.plugins.streetside.model.UserProfile;
import org.openstreetmap.josm.tools.Logging;

public final class Caches {
    static final Logger logger = Logger.getLogger(Caches.class);

    private Caches() {
    }

    public static File getCacheDirectory() {
        File f = new File(Preferences.main().getPluginsDirectory().getPath() + "/MicrosoftStreetside/cache");
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public static class UserProfileCache
    extends CacheProxy<String, UserProfile> {
        private static CacheProxy<String, UserProfile> instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CacheProxy<String, UserProfile> getInstance() {
            Class<UserProfileCache> clazz = UserProfileCache.class;
            synchronized (UserProfileCache.class) {
                if (instance == null) {
                    instance = new UserProfileCache();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        protected CacheAccess<String, UserProfile> createNewCache() throws IOException {
            CacheAccess cache = JCSCacheManager.getCache((String)"userProfile", (int)100, (int)1000, (String)Caches.getCacheDirectory().getPath());
            IElementAttributes atts = cache.getDefaultElementAttributes();
            atts.setMaxLife(604800000L);
            cache.setDefaultElementAttributes(atts);
            return cache;
        }
    }

    public static class MapObjectIconCache
    extends CacheProxy<String, ImageIcon> {
        private static CacheProxy<String, ImageIcon> instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CacheProxy<String, ImageIcon> getInstance() {
            Class<MapObjectIconCache> clazz = MapObjectIconCache.class;
            synchronized (MapObjectIconCache.class) {
                if (instance == null) {
                    instance = new MapObjectIconCache();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        protected CacheAccess<String, ImageIcon> createNewCache() throws IOException {
            return JCSCacheManager.getCache((String)"streetsideObjectIcons", (int)100, (int)1000, (String)Caches.getCacheDirectory().getPath());
        }
    }

    public static class CubemapCache {
        private static CubemapCache instance;
        private final CacheAccess<String, BufferedImageCacheEntry> cache;

        public CubemapCache() {
            CacheAccess c;
            try {
                c = JCSCacheManager.getCache((String)"streetside", (int)10, (int)10000, (String)Caches.getCacheDirectory().getPath());
            }
            catch (Exception e) {
                logger.warn((Object)"Could not initialize the Streetside cubemap cache.", (Throwable)e);
                c = null;
            }
            this.cache = c;
        }

        public CacheAccess<String, BufferedImageCacheEntry> getCache() {
            return this.cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CubemapCache getInstance() {
            Class<CubemapCache> clazz = CubemapCache.class;
            synchronized (CubemapCache.class) {
                if (instance == null) {
                    instance = new CubemapCache();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }
    }

    public static class ImageCache {
        private static ImageCache instance;
        private final CacheAccess<String, BufferedImageCacheEntry> cache;

        public ImageCache() {
            CacheAccess c;
            try {
                c = JCSCacheManager.getCache((String)"streetside", (int)10, (int)10000, (String)Caches.getCacheDirectory().getPath());
            }
            catch (Exception e) {
                Logging.log((Level)Logging.LEVEL_WARN, (String)"Could not initialize the Streetside image cache.", (Throwable)e);
                c = null;
            }
            this.cache = c;
        }

        public CacheAccess<String, BufferedImageCacheEntry> getCache() {
            return this.cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ImageCache getInstance() {
            Class<ImageCache> clazz = ImageCache.class;
            synchronized (ImageCache.class) {
                if (instance == null) {
                    instance = new ImageCache();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }
    }

    public static abstract class CacheProxy<K, V extends Serializable> {
        private final CacheAccess<K, V> cache;

        public CacheProxy() {
            CacheAccess<K, V> c;
            try {
                c = this.createNewCache();
            }
            catch (IOException e) {
                logger.warn((Object)("Could not initialize cache for " + this.getClass().getName()), (Throwable)e);
                c = null;
            }
            this.cache = c;
        }

        protected abstract CacheAccess<K, V> createNewCache() throws IOException;

        public V get(K key) {
            return (V)(this.cache == null ? null : (Serializable)this.cache.get(key));
        }

        public void put(K key, V value) {
            if (this.cache != null) {
                this.cache.put(key, value);
            }
        }
    }
}

