/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside;

import java.awt.Component;
import javax.swing.JMenu;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.actions.StreetsideDownloadAction;
import org.openstreetmap.josm.plugins.streetside.actions.StreetsideDownloadViewAction;
import org.openstreetmap.josm.plugins.streetside.actions.StreetsideExportAction;
import org.openstreetmap.josm.plugins.streetside.actions.StreetsideWalkAction;
import org.openstreetmap.josm.plugins.streetside.actions.StreetsideZoomAction;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBuilder;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideMainDialog;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsidePreferenceSetting;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideViewerDialog;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.ImageInfoHelpPopup;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.ImageInfoPanel;
import org.openstreetmap.josm.plugins.streetside.oauth.StreetsideUser;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.ImageProvider;

public class StreetsidePlugin
extends Plugin {
    public static final ImageProvider LOGO = new ImageProvider("streetside-logo");
    private static final StreetsideZoomAction ZOOM_ACTION = new StreetsideZoomAction();
    private static final StreetsideWalkAction WALK_ACTION = new StreetsideWalkAction();

    public StreetsidePlugin(PluginInformation info) {
        super(info);
        if (StreetsideProperties.ACCESS_TOKEN.get() == null) {
            StreetsideUser.setTokenValid(false);
        }
        MainMenu.add((JMenu)MainApplication.getMenu().fileMenu, (JosmAction)new StreetsideExportAction(), (boolean)false, (Integer)14);
        MainMenu.add((JMenu)MainApplication.getMenu().imagerySubMenu, (JosmAction)new StreetsideDownloadAction(), (boolean)false);
        MainMenu.add((JMenu)MainApplication.getMenu().viewMenu, (JosmAction)ZOOM_ACTION, (boolean)false, (Integer)15);
        MainMenu.add((JMenu)MainApplication.getMenu().fileMenu, (JosmAction)new StreetsideDownloadViewAction(), (boolean)false, (Integer)14);
        MainMenu.add((JMenu)MainApplication.getMenu().moreToolsMenu, (JosmAction)WALK_ACTION, (boolean)false);
    }

    static StreetsideDataListener[] getStreetsideDataListeners() {
        return new StreetsideDataListener[]{WALK_ACTION, ZOOM_ACTION, CubemapBuilder.getInstance()};
    }

    public static StreetsideWalkAction getStreetsideWalkAction() {
        return WALK_ACTION;
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            MainApplication.getMap().addToggleDialog((ToggleDialog)StreetsideMainDialog.getInstance(), false);
            StreetsideMainDialog.getInstance().setImageInfoHelp(new ImageInfoHelpPopup((Component)MainApplication.getMap().addToggleDialog((ToggleDialog)ImageInfoPanel.getInstance(), false)));
            MainApplication.getMap().addToggleDialog((ToggleDialog)StreetsideViewerDialog.getInstance(), false);
        }
        if (oldFrame != null && newFrame == null) {
            StreetsideMainDialog.destroyInstance();
            ImageInfoPanel.destroyInstance();
            CubemapBuilder.destroyInstance();
            StreetsideViewerDialog.destroyInstance();
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new StreetsidePreferenceSetting();
    }

    public static MapView getMapView() {
        MapFrame mf = MainApplication.getMap();
        if (mf != null) {
            return mf.mapView;
        }
        return null;
    }
}

