/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.jrt.core;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.tools.Logging;

public class RoutingProfile {
    private boolean useOneway;
    private boolean useRestrictions;
    private boolean useMaxAllowedSpeed;
    private String name;
    private Map<String, Double> waySpeeds;
    private Map<String, Boolean> allowedModes;

    public RoutingProfile(String name) {
        Logging.trace((String)"Init RoutingProfile with name: {0}", (Object[])new Object[]{name});
        this.name = name;
        this.waySpeeds = new HashMap<String, Double>();
        Map prefs = Preferences.main().getAllPrefix("routing.profile." + name + ".speed");
        for (Map.Entry entry : prefs.entrySet()) {
            this.waySpeeds.put(((String)entry.getKey()).split("\\.")[4], Double.valueOf((String)entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : this.waySpeeds.entrySet()) {
            Logging.trace((String)"{0}-- speed: {1}", (Object[])new Object[]{entry.getKey(), entry.getValue()});
        }
        Logging.trace((String)"End init RoutingProfile with name: {0}", (Object[])new Object[]{name});
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setOnewayUse(boolean useOneway) {
        this.useOneway = useOneway;
    }

    public boolean isOnewayUsed() {
        return this.useOneway;
    }

    public void setRestrictionsUse(boolean useRestrictions) {
        this.useRestrictions = useRestrictions;
    }

    public boolean isRestrictionsUsed() {
        return this.useRestrictions;
    }

    public void setMaxAllowedSpeedUse(boolean useMaxAllowedSpeed) {
        this.useMaxAllowedSpeed = useMaxAllowedSpeed;
    }

    public boolean isMaxAllowedSpeedUsed() {
        return this.useMaxAllowedSpeed;
    }

    public void setWayTypeSpeed(String type, double speed) {
        this.waySpeeds.put(type, speed);
    }

    public void setTransportModePermission(String mode, boolean permission) {
        this.allowedModes.put(mode, permission);
    }

    public boolean isWayTypeAllowed(String type) {
        return this.waySpeeds.get(type) != 0.0;
    }

    public boolean isTransportModeAllowed(String mode) {
        return this.allowedModes.get(mode);
    }

    public double getSpeed(String key) {
        if (!this.waySpeeds.containsKey(key)) {
            return 0.0;
        }
        return this.waySpeeds.get(key);
    }

    public Map<String, Double> getWaySpeeds() {
        return this.waySpeeds;
    }

    public void setWaySpeeds(Map<String, Double> waySpeeds) {
        this.waySpeeds = waySpeeds;
    }
}

