/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.openvisible;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OsmGpxBounds
extends DefaultHandler {
    private double minLat = 180.0;
    private double maxLat = -180.0;
    private double minLon = 90.0;
    private double maxLon = -90.0;

    public void parse(InputStream in) throws IOException, SAXException {
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(in, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
            throw new SAXException(e1);
        }
    }

    @Override
    public void startElement(String ns, String lname, String qname, Attributes a) {
        if (qname.equals("node") || qname.equals("trkpt")) {
            double lat = Double.parseDouble(a.getValue("lat"));
            double lon = Double.parseDouble(a.getValue("lon"));
            this.minLat = Math.min(this.minLat, lat);
            this.minLon = Math.min(this.minLon, lon);
            this.maxLat = Math.max(this.maxLat, lat);
            this.maxLon = Math.max(this.maxLon, lon);
        }
    }

    public boolean intersects(double minLat, double maxLat, double minLon, double maxLon) {
        double lat1 = Math.max(this.minLat, minLat);
        double lon1 = Math.max(this.minLon, minLon);
        double lat2 = Math.min(this.maxLat, maxLat);
        double lon2 = Math.min(this.maxLon, maxLon);
        return lat2 - lat1 > 0.0 && lon2 - lon1 > 0.0;
    }
}

