/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnrestrictions.editor;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.NavigationControler;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionComboBox;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionComboBoxModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionEditorModel;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionLegEditor;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.TurnRestrictionLegRole;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.VehicleExceptionEditor;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.ViaList;
import org.openstreetmap.josm.plugins.turnrestrictions.editor.ViaListModel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class BasicEditorPanel
extends VerticallyScrollablePanel {
    private TurnRestrictionEditorModel model;
    private TurnRestrictionLegEditor fromEditor;
    private TurnRestrictionLegEditor toEditor;
    private ViaList lstVias;
    private JLabel lblVias;
    private JScrollPane spVias;
    private TurnRestrictionComboBox cbTurnRestrictions;
    private VehicleExceptionEditor vehicleExceptionsEditor;

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 5, 5);
        this.add(new JLabel(I18n.tr((String)"Type:", (Object[])new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.cbTurnRestrictions = new TurnRestrictionComboBox(new TurnRestrictionComboBoxModel(this.model));
        this.add(this.cbTurnRestrictions, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 0.0;
        this.add(new JLabel(I18n.tr((String)"From:", (Object[])new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.fromEditor = new TurnRestrictionLegEditor(this.model, TurnRestrictionLegRole.FROM);
        this.add(this.fromEditor, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 5, 5);
        this.add(new JLabel(I18n.tr((String)"To:", (Object[])new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.toEditor = new TurnRestrictionLegEditor(this.model, TurnRestrictionLegRole.TO);
        this.add(this.toEditor, gc);
        gc.gridx = 0;
        gc.gridy = 3;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 5, 5);
        this.lblVias = new JLabel(I18n.tr((String)"Vias:", (Object[])new Object[0]));
        this.add(this.lblVias, gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.lstVias = new ViaList(new ViaListModel(this.model, selectionModel), selectionModel);
        this.spVias = new JScrollPane(this.lstVias){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 80);
            }
        };
        this.add(this.spVias, gc);
        if (!Config.getPref().getBoolean("turnrestrictions.show-vias-in-basic-editor", false)) {
            this.lblVias.setVisible(false);
            this.spVias.setVisible(false);
        }
        this.vehicleExceptionsEditor = new VehicleExceptionEditor(this.model);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.gridwidth = 2;
        gc.insets = new Insets(0, 0, 5, 5);
        this.add(this.vehicleExceptionsEditor, gc);
        gc.gridx = 0;
        gc.gridy = 5;
        gc.gridwidth = 2;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add(new JPanel(), gc);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public BasicEditorPanel(TurnRestrictionEditorModel model) {
        CheckParameterUtil.ensureParameterNotNull((Object)model, (String)"model");
        this.model = model;
        this.build();
        HelpUtil.setHelpContext((JComponent)((Object)this), (String)HelpUtil.ht((String)"/Plugin/TurnRestrictions#BasicEditor"));
    }

    public void requestFocusfor(NavigationControler.BasicEditorFokusTargets focusTarget) {
        if (focusTarget == null) {
            return;
        }
        switch (focusTarget) {
            case RESTRICION_TYPE: {
                this.cbTurnRestrictions.requestFocusInWindow();
                break;
            }
            case FROM: {
                this.fromEditor.requestFocusInWindow();
                break;
            }
            case TO: {
                this.toEditor.requestFocusInWindow();
                break;
            }
            case VIA: {
                this.lstVias.requestFocusInWindow();
            }
        }
    }

    public void initIconSetFromPreferences(IPreferences prefs) {
        this.cbTurnRestrictions.initIconSetFromPreferences(prefs);
    }

    public void initViasVisibilityFromPreferences(IPreferences prefs) {
        boolean value = prefs.getBoolean("turnrestrictions.show-vias-in-basic-editor", false);
        if (value != this.lblVias.isVisible()) {
            this.lblVias.setVisible(value);
            this.spVias.setVisible(value);
        }
    }
}

