/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imageio;

import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginClassLoader;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.imageio.ImageIOPreferenceSetting;
import org.openstreetmap.josm.plugins.imageio.NexusDownloader;
import org.openstreetmap.josm.spi.preferences.Config;

public final class ImageIOPlugin
extends Plugin {
    private static boolean initialized;

    public ImageIOPlugin(PluginInformation info) {
        super(info);
        this.initialize(false);
        MainApplication.worker.submit(() -> NexusDownloader.setDownloadDirectory(this.getPluginDirs().getCacheDirectory(true)));
    }

    public PreferenceSetting getPreferenceSetting() {
        this.initialize(false);
        return new ImageIOPreferenceSetting(() -> this.initialize(true));
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        this.initialize(false);
        super.mapFrameInitialized(oldFrame, newFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void initialize(boolean force) {
        PluginClassLoader pluginLoader = PluginHandler.getPluginClassLoader((String)this.getPluginInformation().getName());
        if (!(initialized && !force || pluginLoader == null || Config.getPref().getList("imageio.classpath").isEmpty())) {
            List<URL> urlList = Arrays.asList(pluginLoader.getURLs());
            TreeSet loaded = new TreeSet(Config.getPref().getList("imageio.classpath"));
            TreeSet<String> missing = new TreeSet<String>();
            for (String classPath : loaded) {
                Path path = Path.of(classPath, new String[0]);
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    missing.add(classPath);
                    continue;
                }
                try {
                    URL url = path.toUri().toURL();
                    if (urlList.contains(url)) continue;
                    pluginLoader.addURL(url);
                }
                catch (MalformedURLException e) {
                    Config.getPref().put("imageio.classpath", null);
                    throw new UncheckedIOException(e);
                }
            }
            if (!missing.isEmpty()) {
                loaded.removeAll(missing);
                Config.getPref().putList("imageio.classpath", new ArrayList(loaded));
            }
            ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)pluginLoader);
                ImageIO.scanForPlugins();
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentLoader);
            }
            initialized = true;
        }
    }
}

