/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.ss.util.CellRangeAddressBase;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.LittleEndianOutput;

public class CellRangeAddress
extends CellRangeAddressBase {
    public static final int ENCODED_SIZE = 8;

    public CellRangeAddress(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.getFirstRow());
        littleEndianOutput.writeShort(this.getLastRow());
        littleEndianOutput.writeShort(this.getFirstColumn());
        littleEndianOutput.writeShort(this.getLastColumn());
    }

    public CellRangeAddress(RecordInputStream recordInputStream) {
        super(CellRangeAddress.readUShortAndCheck(recordInputStream), recordInputStream.readUShort(), recordInputStream.readUShort(), recordInputStream.readUShort());
    }

    private static int readUShortAndCheck(RecordInputStream recordInputStream) {
        if (recordInputStream.remaining() < 8) {
            throw new RuntimeException("Ran out of data reading CellRangeAddress");
        }
        return recordInputStream.readUShort();
    }

    public CellRangeAddress copy() {
        return new CellRangeAddress(this.getFirstRow(), this.getLastRow(), this.getFirstColumn(), this.getLastColumn());
    }

    public static int getEncodedSize(int n) {
        return n * 8;
    }

    public String formatAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        CellReference cellReference = new CellReference(this.getFirstRow(), this.getFirstColumn());
        CellReference cellReference2 = new CellReference(this.getLastRow(), this.getLastColumn());
        stringBuffer.append(cellReference.formatAsString());
        if (!cellReference.equals(cellReference2)) {
            stringBuffer.append(':');
            stringBuffer.append(cellReference2.formatAsString());
        }
        return stringBuffer.toString();
    }
}

