/*
 * Decompiled with CFR 0.152.
 */
package com.bric.util;

import com.bric.reflect.Reflection;
import java.security.AccessControlException;

public class JVM {
    public static final float javaVersion = JVM.getMajorJavaVersion(true);
    private static final String osName = JVM.getOSName();
    public static final boolean isMac = osName.indexOf("mac") != -1;
    public static final boolean isLinux = osName.indexOf("linux") != -1;
    public static final boolean isWindows = osName.indexOf("windows") != -1;
    public static final boolean isVista = osName.indexOf("vista") != -1;
    public static final boolean isWindows7 = isWindows && osName.indexOf("7") != -1;
    public static final boolean isWindowsXP = isWindows && osName.indexOf("xp") != -1;
    public static final boolean isVistaOrWindows7 = isVista || isWindows7;
    public static final boolean usingQuartz = JVM.isUsingQuartz();

    public static boolean isJNLP() {
        try {
            Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Class<?> basicServiceClass = Class.forName("javax.jnlp.BasicService");
            Object basicService = Reflection.invokeMethod(serviceManagerClass, null, "lookup", new Object[]{"javax.jnlp.BasicSerivce"});
            if (basicService == Reflection.INVOCATION_ERROR) {
            }
            Object codeBase = Reflection.invokeMethod(basicServiceClass, basicService, "getCodeBase", new Object[0]);
            if (codeBase == Reflection.INVOCATION_ERROR) {
            }
            return codeBase != null;
        }
        finally {
            return false;
        }
    }

    public static void printProfile() {
        System.out.println(JVM.getProfile());
    }

    public static String getProfile() {
        StringBuffer sb = new StringBuffer();
        String k = JVM.isJNLP() ? ", JNLP" : "";
        sb.append("OS = " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + "), " + System.getProperty("os.arch") + k + "\n");
        sb.append("Java Version = " + System.getProperty("java.version") + "\n");
        return sb.toString();
    }

    private static String getOSName() {
        try {
            String s = System.getProperty("os.name").toLowerCase();
            return s;
        }
        catch (AccessControlException e) {
            e.printStackTrace();
            return "unknown";
        }
    }

    private static boolean isUsingQuartz() {
        try {
            return isMac && (javaVersion > 0.0f && javaVersion < 1.4f || System.getProperty("apple.awt.graphics.UseQuartz") != null && System.getProperty("apple.awt.graphics.UseQuartz").toString().equals("true"));
        }
        catch (AccessControlException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static float getMajorJavaVersion() throws AccessControlException {
        String majorVersion = null;
        try {
            System.getProperty("java.major.version");
        }
        catch (AccessControlException e) {
            return -1.0f;
        }
        if (majorVersion == null) {
            String s = System.getProperty("java.version");
            float f = -1.0f;
            int i = s.length();
            while (f < 0.0f && i > 0) {
                try {
                    f = Float.parseFloat(s.substring(0, i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --i;
            }
            majorVersion = Float.toString(f);
            System.setProperty("java.major.version", majorVersion);
        }
        return Float.parseFloat(majorVersion);
    }

    public static float getMajorJavaVersion(boolean catchSecurityException) {
        try {
            return JVM.getMajorJavaVersion();
        }
        catch (RuntimeException t) {
            if (catchSecurityException) {
                System.err.println("this exception was ignored without incident, but it means we can't determine the major java version:");
                t.printStackTrace();
                return -1.0f;
            }
            throw t;
        }
    }
}

