/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.housenumbertool;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Set;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.plugins.housenumbertool.TagDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class LaunchAction
extends JosmAction
implements DataSelectionListener {
    private static final long serialVersionUID = -2017126466206457986L;
    private OsmPrimitive selection;
    private final File pluginDir;

    public LaunchAction(File pluginDir) {
        super(I18n.tr((String)"HouseNumberTaggingTool", (Object[])new Object[0]), "home-icon32", I18n.tr((String)"Launches the HouseNumberTaggingTool dialog", (Object[])new Object[0]), Shortcut.registerShortcut((String)"edit:housenumbertaggingtool", (String)I18n.tr((String)"Data: {0}", (Object[])new Object[]{"HouseNumberTaggingTool"}), (int)75, (int)5003), true);
        this.pluginDir = pluginDir;
        SelectionEventManager.getInstance().addSelectionListener((DataSelectionListener)this);
        this.setEnabled(false);
    }

    protected void launchEditor() {
        if (!this.isEnabled()) {
            return;
        }
        TagDialog dialog = new TagDialog(this.pluginDir, this.selection);
        dialog.showDialog();
    }

    public void actionPerformed(ActionEvent e) {
        this.launchEditor();
    }

    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        Set newSelection = event.getSelection();
        if (newSelection != null && newSelection.size() == 1) {
            this.setEnabled(true);
            this.selection = (OsmPrimitive)newSelection.iterator().next();
        } else {
            this.setEnabled(false);
            this.selection = null;
        }
    }
}

