/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pointinfo.catastro;

import java.net.URL;
import java.util.Locale;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.pointinfo.AbstractPointInfoModule;
import org.openstreetmap.josm.plugins.pointinfo.catastro.CatastroRecord;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Logging;

public class CatastroModule
extends AbstractPointInfoModule {
    private static final String moduleName = "Catastro";
    private static final String areaName = "es";
    private static final String catURL = "http://ovc.catastro.meh.es/ovcservweb/OVCSWLocalizacionRC/OVCCoordenadas.asmx/Consulta_RCCOOR?SRS=EPSG:4326&Coordenada_X=%f&Coordenada_Y=%f";
    private CatastroRecord m_record = new CatastroRecord();

    @Override
    public String getHtml() {
        return this.m_record.getHtml();
    }

    @Override
    public void performAction(String act) {
        this.m_record.performAction(act);
    }

    @Override
    public void prepareData(LatLon pos) {
        try {
            String request = String.format(Locale.ENGLISH, catURL, pos.lon(), pos.lat());
            String result = HttpClient.create((URL)new URL(request)).connect().fetchContent();
            this.m_record.parseXML(result);
        }
        catch (Exception e) {
            Logging.warn((Throwable)e);
        }
    }

    @Override
    public String getName() {
        return moduleName;
    }

    @Override
    public String getArea() {
        return areaName;
    }
}

