/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.datasets.be;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.SimpleDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.datasets.be.BelgianConstants;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.DefaultCsvHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public abstract class BelgianDataSetHandler
extends SimpleDataSetHandler
implements BelgianConstants {
    private Projection singleProjection;
    private String nationalPortalPathDe;
    private String nationalPortalPathEn;
    private String nationalPortalPathFr;
    private String nationalPortalPathNl;
    protected static final Projection lambert1972 = OdConstants.PRJ_LAMBERT_1972.getProjection();
    protected static final Projection lambert2008 = OdConstants.PRJ_LAMBERT_2008.getProjection();
    protected static final Projection[] projections = new Projection[]{lambert1972, lambert2008};

    protected BelgianDataSetHandler() {
        this.init();
    }

    protected BelgianDataSetHandler(String relevantTag) {
        super(relevantTag);
        this.init();
    }

    protected BelgianDataSetHandler(boolean relevantUnion, String[] relevantTags) {
        super(relevantUnion, relevantTags);
        this.init();
    }

    protected BelgianDataSetHandler(boolean relevantUnion, Tag[] relevantTags) {
        super(relevantUnion, relevantTags);
        this.init();
    }

    private void init() {
        this.setCsvHandler(new InternalCsvHandler());
    }

    protected final void setNationalPortalPath(String nationalPortalPathDe, String nationalPortalPathEn, String nationalPortalPathFr, String nationalPortalPathNl) {
        this.nationalPortalPathDe = nationalPortalPathDe;
        this.nationalPortalPathEn = nationalPortalPathEn;
        this.nationalPortalPathFr = nationalPortalPathFr;
        this.nationalPortalPathNl = nationalPortalPathNl;
    }

    protected final void setSingleProjection(Projection singleProjection) {
        this.singleProjection = singleProjection;
        CsvHandler handler = this.getCsvHandler();
        if (handler != null) {
            handler.setHandlesProjection(singleProjection != null);
        }
    }

    @Override
    public URL getNationalPortalURL() {
        try {
            String nationalPortalPath = "";
            String lang = Config.getPref().get("language");
            if (lang == null || lang.isEmpty()) {
                lang = Locale.getDefault().toString();
            }
            nationalPortalPath = lang.startsWith("de") && this.nationalPortalPathDe != null ? this.nationalPortalPathDe : (lang.startsWith("fr") && this.nationalPortalPathFr != null ? this.nationalPortalPathFr : (lang.startsWith("nl") && this.nationalPortalPathNl != null ? this.nationalPortalPathNl : this.nationalPortalPathEn));
            return new URL("https://data.gov.be/{lang}/dataset/".replace("{lang}", lang.substring(0, 2)) + nationalPortalPath);
        }
        catch (MalformedURLException e) {
            Logging.error((Throwable)e);
            return null;
        }
    }

    @Override
    public String getLocalPortalIconName() {
        return "be24.png";
    }

    @Override
    public String getNationalPortalIconName() {
        return "be24.png";
    }

    protected class InternalCsvHandler
    extends DefaultCsvHandler {
        protected InternalCsvHandler() {
        }

        @Override
        public LatLon getCoor(EastNorth en, String[] fields) {
            if (BelgianDataSetHandler.this.singleProjection != null) {
                return BelgianDataSetHandler.this.singleProjection.eastNorth2latlon(en);
            }
            return super.getCoor(en, fields);
        }
    }
}

