/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tracer;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import org.openstreetmap.josm.data.coor.LatLon;

public class TracerServer {
    static final String URL = "http://localhost:5050/";

    private String callServer(String urlString) {
        try {
            String line;
            URL url = new URL(URL + urlString);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public ArrayList<LatLon> trace(LatLon pos) {
        try {
            String[] lines;
            String content = this.callServer("trace/simple/" + pos.lat() + ";" + pos.lon());
            ArrayList<LatLon> nodelist = new ArrayList<LatLon>();
            for (String line : lines = content.split("\\|")) {
                String[] items = line.split(";");
                double x = Double.parseDouble(items[0]);
                double y = Double.parseDouble(items[1]);
                nodelist.add(new LatLon(x, y));
            }
            return nodelist;
        }
        catch (Exception e) {
            return new ArrayList<LatLon>();
        }
    }

    public void log(String message) {
        this.callServer("log/" + message);
    }
}

