/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.archive;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class CandidateChooser
extends ExtendedDialog {
    private final JPanel projPanel = new JPanel(new GridBagLayout());
    private final JComboBox<File> fileCombo;

    public CandidateChooser(Component parent, List<File> candidates) {
        this(parent, I18n.tr((String)"File to load", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, candidates);
    }

    protected CandidateChooser(Component parent, String title, String[] buttonTexts, List<File> candidates) {
        super(parent, title, buttonTexts);
        this.fileCombo = new JComboBox<File>(candidates.toArray(new File[0]));
        this.fileCombo.setRenderer(new Renderer());
        this.addGui(candidates);
    }

    public void addGui(List<File> candidates) {
        this.projPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projPanel.setLayout(new GridBagLayout());
        this.projPanel.add((Component)new JLabel(I18n.tr((String)"File to load", (Object[])new Object[0])), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        this.projPanel.add(this.fileCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.setContent(this.projPanel);
    }

    public File getSelectedFile() {
        return (File)this.fileCombo.getSelectedItem();
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof File) {
                this.setText(((File)value).getName());
            }
            return this;
        }
    }
}

