/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.geotools.util.Converters;
import org.geotools.xml.impl.DatatypeConverterImpl;
import org.geotools.xs.XS;
import org.geotools.xs.XSUtils;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.SimpleBinding;

public class XSDateTimeBinding
implements SimpleBinding {
    @Override
    public QName getTarget() {
        return XS.DATETIME;
    }

    @Override
    public int getExecutionMode() {
        return 2;
    }

    public Class getType() {
        return Timestamp.class;
    }

    @Override
    public Timestamp parse(InstanceComponent instance, Object value) throws Exception {
        String str = (String)value;
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        Calendar calendar = DatatypeConverterImpl.getInstance().parseDateTime(str, true);
        Timestamp dateTime = new Timestamp(calendar.getTimeInMillis());
        return dateTime;
    }

    @Override
    public String encode(Object object, String value) {
        Date timestamp = Converters.convert(object, Date.class);
        Calendar calendar = XSUtils.getConfiguredCalendar();
        calendar.clear();
        calendar.setTimeInMillis(timestamp.getTime());
        return DatatypeConverterImpl.getInstance().printDateTime(calendar);
    }
}

