/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import org.apache.commons.lang3.StringUtils;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.factory.URI_Parser;
import org.geotools.referencing.factory.URI_Type;
import org.geotools.util.Version;
import org.opengis.referencing.NoSuchAuthorityCodeException;

final class URN_Parser
extends URI_Parser {
    private static final String[] URN_BASES = new String[]{"urn:ogc:def:", "urn:x-ogc:def:"};
    private static final char URN_SEPARATOR = ':';

    protected URN_Parser(String urn, URI_Type type, String authority, Version version, String code) {
        super(urn, type, authority, version, code);
    }

    public static URN_Parser buildParser(String urn) throws NoSuchAuthorityCodeException {
        String code = urn.trim();
        String type = urn;
        for (String urnBase : URN_BASES) {
            String urnCode;
            String urnAuthority;
            Version urnVersion;
            int lastEnd;
            int nameEnd;
            URI_Type candidate;
            int typeEnd;
            int typeStart = urnBase.length();
            if (!code.regionMatches(true, 0, urnBase, 0, typeStart) || (typeEnd = code.indexOf(58, typeStart)) < 0 || (candidate = URI_Type.get(type = code.substring(typeStart, typeEnd).trim())) == null || (nameEnd = code.indexOf(58, typeEnd + 1)) < 0) continue;
            int versionEnd = code.indexOf(58, nameEnd + 1);
            if (versionEnd != (lastEnd = code.lastIndexOf(58)) && versionEnd != -1) {
                urnVersion = lastEnd <= nameEnd ? null : new Version(code.substring(nameEnd + 1, versionEnd));
                urnAuthority = code.substring(typeEnd + 1, nameEnd);
                urnCode = code.substring(versionEnd + 1).trim();
                urnCode = urnCode.replaceAll(String.valueOf(':'), ",");
            } else {
                urnVersion = lastEnd <= nameEnd ? null : new Version(code.substring(nameEnd + 1, lastEnd));
                urnAuthority = code.substring(typeEnd + 1, nameEnd).trim();
                urnCode = code.substring(lastEnd + 1).trim();
            }
            Version version = urnVersion = StringUtils.isEmpty((CharSequence)urnVersion) ? null : urnVersion;
            if (urnCode.contains("CRS")) {
                urnAuthority = "CRS";
                urnCode = urnCode.substring(3);
            } else if (urnCode.contains("AUTO")) {
                urnAuthority = "AUTO";
                urnCode = urnCode.substring(4);
            }
            URI_Type urnType = candidate;
            return new URN_Parser(urn, urnType, urnAuthority, urnVersion, urnCode);
        }
        throw new NoSuchAuthorityCodeException(Errors.format(67, type), "urn:ogc:def", type);
    }
}

